/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import noppes.npcs.client.controllers.Preset;
import noppes.npcs.shared.common.util.LogWriter;

public class PresetController {
    public HashMap<String, Preset> presets = new HashMap();
    private File dir;
    public static PresetController instance;

    public PresetController(File dir) {
        instance = this;
        this.dir = dir;
        this.load();
    }

    public Preset getPreset(String username) {
        if (this.presets.isEmpty()) {
            this.load();
        }
        return this.presets.get(username.toLowerCase(Locale.ROOT));
    }

    public void load() {
        class_2487 compound = this.loadPreset();
        HashMap<String, Preset> presets = new HashMap<String, Preset>();
        if (compound != null) {
            class_2499 list = compound.method_10554("Presets", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 comp = list.method_10602(i);
                Preset preset = new Preset();
                preset.load(comp);
                presets.put(preset.name.toLowerCase(Locale.ROOT), preset);
            }
        }
        Preset.FillDefault(presets);
        this.presets = presets;
    }

    private class_2487 loadPreset() {
        String filename = "presets.dat";
        try {
            File file = new File(this.dir, filename);
            if (!file.exists()) {
                return null;
            }
            return class_2507.method_10629((InputStream)new FileInputStream(file), (class_2505)class_2505.method_53898());
        }
        catch (Exception e) {
            LogWriter.except(e);
            try {
                File file = new File(this.dir, filename + "_old");
                if (!file.exists()) {
                    return null;
                }
                return class_2507.method_10629((InputStream)new FileInputStream(file), (class_2505)class_2505.method_53898());
            }
            catch (Exception e2) {
                LogWriter.except(e2);
                return null;
            }
        }
    }

    public void save() {
        class_2487 compound = new class_2487();
        class_2499 list = new class_2499();
        for (Preset preset : this.presets.values()) {
            list.add((Object)preset.save());
        }
        compound.method_10566("Presets", (class_2520)list);
        this.savePreset(compound);
    }

    private void savePreset(class_2487 compound) {
        String filename = "presets.dat";
        try {
            File file = new File(this.dir, filename + "_new");
            File file1 = new File(this.dir, filename + "_old");
            File file2 = new File(this.dir, filename);
            class_2507.method_10634((class_2487)compound, (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
    }

    public void addPreset(Preset preset) {
        while (this.presets.containsKey(preset.name.toLowerCase(Locale.ROOT))) {
            preset.name = preset.name + "_";
        }
        this.presets.put(preset.name.toLowerCase(Locale.ROOT), preset);
        this.save();
    }

    public void removePreset(String preset) {
        if (preset == null) {
            return;
        }
        this.presets.remove(preset.toLowerCase(Locale.ROOT));
        this.save();
    }
}

