/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiAssetsSelectorWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiLabelWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.components.CustomGuiLabel;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketCustomGuiButton;
import noppes.npcs.packets.server.SPacketCustomGuiTextUpdate;
import noppes.npcs.shared.client.gui.components.GuiCustomScrollNop;
import noppes.npcs.shared.client.gui.listeners.ICustomScrollListener;
import noppes.npcs.shared.client.util.AssetsFinder;

public class CustomGuiAssetsSelector
extends class_339
implements IGuiComponent {
    private String up = "..<" + class_1074.method_4662((String)"gui.up", (Object[])new Object[0]) + ">..";
    private GuiCustom parent;
    private CustomGuiAssetsSelectorWrapper component;
    private GuiCustomScrollNop folders;
    private GuiCustomScrollNop items;
    private CustomGuiLabel label;
    public int id;
    private static final HashMap<String, List<class_2960>> domains = new HashMap();
    private static final HashMap<String, class_2960> textures = new HashMap();
    private String location = "";
    private String path = "";
    private String selectedDomain;
    public class_2960 prevResource = null;
    public class_2960 selectedResource = null;

    public CustomGuiAssetsSelector(GuiCustom parent, final CustomGuiAssetsSelectorWrapper component) {
        super(component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), (class_2561)class_2561.method_43473());
        this.parent = parent;
        this.component = component;
        this.folders = new GuiCustomScrollNop((class_437)parent, 101);
        this.items = new GuiCustomScrollNop((class_437)parent, 102);
        this.label = new CustomGuiLabel(parent, (CustomGuiLabelWrapper)new CustomGuiLabelWrapper().setCentered(true));
        this.method_25426();
        if (!component.getSelected().isEmpty()) {
            this.selectedResource = this.prevResource = class_2960.method_12829((String)component.getSelected());
        }
        List<class_2960> resources = AssetsFinder.find(component.getRoot(), "." + component.getFileType());
        for (class_2960 loc : resources) {
            domains.computeIfAbsent(loc.method_12836(), k -> new ArrayList()).add(loc);
        }
        if (this.selectedResource != null && !this.selectedResource.method_12832().isEmpty()) {
            this.selectedDomain = this.selectedResource.method_12836();
            if (!domains.containsKey(this.selectedDomain)) {
                this.selectedDomain = null;
            }
            int i = this.selectedResource.method_12832().lastIndexOf(47);
            this.location = this.path = this.selectedResource.method_12832().substring(0, i + 1);
            i = this.path.lastIndexOf(47, this.path.length() - 2);
            if (i > 0) {
                this.location = this.path.substring(0, i + 1);
            }
            this.label.setText(this.selectedDomain + ":" + this.location);
        }
        this.setFolders();
        this.setItems();
        this.folders.listener = new ICustomScrollListener(){

            @Override
            public void scrollClicked(double x, double y, int k, GuiCustomScrollNop scroll) {
                if (scroll.getSelected().equals(CustomGuiAssetsSelector.this.up)) {
                    return;
                }
                CustomGuiAssetsSelector.this.path = CustomGuiAssetsSelector.this.location + scroll.getSelected() + "/";
                CustomGuiAssetsSelector.this.setItems();
            }

            @Override
            public void scrollDoubleClicked(String selection, GuiCustomScrollNop scroll) {
                if (CustomGuiAssetsSelector.this.selectedDomain == null) {
                    CustomGuiAssetsSelector.this.selectedDomain = scroll.getSelected();
                    if (!component.getRoot().isEmpty()) {
                        CustomGuiAssetsSelector.this.path = CustomGuiAssetsSelector.this.location = component.getRoot() + "/";
                    }
                } else if (scroll.getSelected().equals(CustomGuiAssetsSelector.this.up)) {
                    int i = CustomGuiAssetsSelector.this.location.lastIndexOf(47, CustomGuiAssetsSelector.this.location.length() - 2);
                    if (i > 0) {
                        CustomGuiAssetsSelector.this.path = CustomGuiAssetsSelector.this.location;
                        CustomGuiAssetsSelector.this.location = CustomGuiAssetsSelector.this.location.substring(0, i + 1);
                    } else {
                        CustomGuiAssetsSelector.this.location = "";
                        CustomGuiAssetsSelector.this.path = "";
                    }
                    if (CustomGuiAssetsSelector.this.location.isEmpty()) {
                        CustomGuiAssetsSelector.this.selectedDomain = null;
                    }
                } else {
                    CustomGuiAssetsSelector.this.path = CustomGuiAssetsSelector.this.location = CustomGuiAssetsSelector.this.location + scroll.getSelected() + "/";
                }
                CustomGuiAssetsSelector.this.setFolders();
                CustomGuiAssetsSelector.this.setItems();
                CustomGuiAssetsSelector.this.label.setText(CustomGuiAssetsSelector.this.selectedDomain + ":" + CustomGuiAssetsSelector.this.location);
            }
        };
        this.items.listener = new ICustomScrollListener(){

            @Override
            public void scrollClicked(double i, double j, int k, GuiCustomScrollNop scroll) {
                CustomGuiAssetsSelector.this.selectedResource = textures.get(scroll.getSelected());
                component.setSelected(textures.get(scroll.getSelected()).toString());
                if (!component.disablePackets) {
                    Packets.sendServer(new SPacketCustomGuiTextUpdate(component.getUniqueID(), component.getSelected()));
                } else {
                    component.onChange(null);
                }
            }

            @Override
            public void scrollDoubleClicked(String selection, GuiCustomScrollNop scroll) {
                if (!component.disablePackets) {
                    Packets.sendServer(new SPacketCustomGuiButton(component.getUniqueID()));
                } else {
                    component.onPress(null);
                }
            }
        };
    }

    @Override
    public void method_25426() {
        this.id = this.component.getID();
        this.method_46421(this.component.getPosX());
        this.method_46419(this.component.getPosY());
        this.folders.guiTop = this.items.guiTop = this.method_46427() + 10;
        this.method_25358(this.component.getWidth());
        this.field_22759 = this.component.getHeight();
        this.folders.setSize(this.component.getWidth() / 2 - 1, this.component.getHeight() - 10);
        this.items.setSize(this.component.getWidth() / 2 - 1, this.component.getHeight() - 10);
        this.folders.guiLeft = this.method_46426();
        this.items.guiLeft = this.method_46426() + this.component.getWidth() / 2 + 1;
        this.label.method_25358(this.component.getWidth());
        this.label.method_46421(this.method_46426());
        this.label.method_46419(this.method_46427());
        this.label.method_53533(10);
        if (!this.component.getSelected().isEmpty()) {
            this.selectedResource = class_2960.method_12829((String)this.component.getSelected());
        }
    }

    private void setFolders() {
        if (this.selectedDomain == null) {
            this.folders.setList(Lists.newArrayList(domains.keySet()));
            if (this.selectedResource != null) {
                this.selectedDomain = this.selectedResource.method_12836();
                this.folders.setSelected(this.selectedDomain);
            }
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.up);
        for (class_2960 td : domains.get(this.selectedDomain)) {
            String path;
            int i;
            String fullPath = td.method_12832();
            if (fullPath.indexOf(47) >= 0) {
                fullPath = fullPath.substring(0, fullPath.lastIndexOf(47) + 1);
            }
            if (!this.location.isEmpty() && (!fullPath.startsWith(this.location) || fullPath.equals(this.location)) || (i = (path = fullPath.substring(this.location.length())).indexOf(47)) < 0 || (path = path.substring(0, i)).isEmpty() || list.contains(path)) continue;
            list.add(path);
        }
        this.folders.clearSelection();
        this.folders.setList(list);
        if (this.selectedResource != null && this.selectedResource.method_12832().startsWith(this.location) && !this.location.equals(this.path)) {
            this.folders.setSelected(this.path.substring(this.location.length(), this.path.length() - 1));
            this.folders.scrollTo(this.folders.getSelected());
        }
    }

    private void setItems() {
        if (this.selectedDomain == null) {
            return;
        }
        textures.clear();
        List<class_2960> data = domains.get(this.selectedDomain);
        ArrayList<String> list = new ArrayList<String>();
        for (class_2960 td : data) {
            String name = td.method_12832();
            String path = td.method_12832();
            if (name.indexOf(47) >= 0) {
                name = name.substring(name.lastIndexOf(47) + 1);
                path = path.substring(0, path.lastIndexOf(47) + 1);
            }
            if (!path.equals(this.path) || list.contains(name)) continue;
            list.add(name);
            textures.put(name, td);
        }
        this.items.clearSelection();
        this.items.setList(list);
        if (this.selectedResource != null) {
            int i = this.selectedResource.method_12832().lastIndexOf(47);
            String name = this.selectedResource.method_12832().substring(i + 1);
            String path = this.selectedResource.method_12832().substring(0, i + 1);
            if (path.equals(this.path)) {
                this.items.setSelected(name);
            }
        }
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void onRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void onRenderPost(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        boolean hovered;
        if (!this.field_22764) {
            return;
        }
        this.label.onRender(graphics, mouseX, mouseY, partialTicks);
        this.folders.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.items.method_25394(graphics, mouseX, mouseY, partialTicks);
        boolean bl = hovered = mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 && mouseY < this.method_46427() + this.field_22759;
        if (hovered && this.component.hasHoverText()) {
            this.parent.hoverText = this.component.getHoverTextList();
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double mouseScrolled, double arg4) {
        return this.folders.method_25401(mouseX, mouseY, mouseScrolled, arg4) || this.items.method_25401(mouseX, mouseY, mouseScrolled, arg4);
    }

    protected void method_48579(class_332 p_282139_, int p_268034_, int p_268009_, float p_268085_) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.folders.method_25402(mouseX, mouseY, button) || this.items.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        return this.folders.method_25404(p_231046_1_, p_231046_2_, p_231046_3_) || this.items.method_25404(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public boolean method_25400(char p_231042_1_, int p_231042_2_) {
        return this.folders.method_25400(p_231042_1_, p_231042_2_) || this.items.method_25400(p_231042_1_, p_231042_2_);
    }

    public void method_47399(class_6382 p_169152_) {
    }

    @Override
    public ICustomGuiComponent component() {
        return this.component;
    }
}

