/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_3675;
import net.minecraft.class_757;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.MouseHelperMixin;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketDialogSelected;
import noppes.npcs.packets.server.SPacketQuestCompletionCheckAll;
import noppes.npcs.shared.client.gui.listeners.IGuiClose;
import noppes.npcs.shared.client.util.NoppesStringUtils;

public class GuiDialogInteract
extends GuiNPCInterface
implements IGuiClose {
    private Dialog dialog;
    private int selected = 0;
    private List<TextBlockClient> lines = new ArrayList<TextBlockClient>();
    private List<Integer> options = new ArrayList<Integer>();
    private int rowStart = 0;
    private int rowTotal = 0;
    private int dialogHeight = 180;
    private class_2960 wheel;
    private class_2960[] wheelparts;
    private class_2960 indicator;
    private boolean isGrabbed = false;
    private double selectedX = 0.0;
    private double selectedY = 0.0;

    public GuiDialogInteract(EntityNPCInterface npc, Dialog dialog) {
        super(npc);
        this.dialog = dialog;
        this.appendDialog(dialog);
        this.imageHeight = 238;
        this.wheel = this.getResource("wheel.png");
        this.indicator = this.getResource("indicator.png");
        this.wheelparts = new class_2960[]{this.getResource("wheel1.png"), this.getResource("wheel2.png"), this.getResource("wheel3.png"), this.getResource("wheel4.png"), this.getResource("wheel5.png"), this.getResource("wheel6.png")};
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.isGrabbed = false;
        this.grabMouse(this.dialog.showWheel);
        this.guiTop = this.field_22790 - this.imageHeight;
        this.calculateRowHeight();
    }

    public void grabMouse(boolean grab) {
        if (grab && !this.isGrabbed) {
            MouseHelperMixin mouse = (MouseHelperMixin)class_310.method_1551().field_1729;
            mouse.setGrabbed(false);
            double xpos = 0.0;
            double ypos = 0.0;
            mouse.setX(xpos);
            mouse.setY(ypos);
            class_3675.method_15984((long)this.field_22787.method_22683().method_4490(), (int)212995, (double)xpos, (double)ypos);
            this.isGrabbed = true;
        } else if (!grab && this.isGrabbed) {
            class_310.method_1551().field_1729.method_1610();
            this.isGrabbed = false;
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.dialog.hideNPC) {
            int l = -70;
            int i1 = this.imageHeight;
            this.drawNpc(graphics, (class_1309)this.npc, l, i1, 1.4f, 0);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.5f, 100.065f);
        int count = 0;
        for (TextBlockClient block : new ArrayList<TextBlockClient>(this.lines)) {
            int size = ClientProxy.Font.width(block.getName() + ": ");
            this.drawString(graphics, block.getName() + ": ", -4 - size, block.color, count);
            for (class_2561 line : block.lines) {
                this.drawString(graphics, line.getString(), 0, block.color, count);
                ++count;
            }
            ++count;
        }
        if (!this.options.isEmpty()) {
            if (!this.dialog.showWheel) {
                this.drawLinedOptions(graphics, mouseY);
            } else {
                this.drawWheel(graphics);
            }
        }
        graphics.method_51448().method_22909();
    }

    private void drawWheel(class_332 graphics) {
        int yoffset = this.guiTop + this.dialogHeight + 14;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.wheel);
        graphics.method_25302(this.wheel, this.field_22789 / 2 - 31, yoffset, 0, 0, 63, 40);
        this.selectedX = this.field_22787.field_1729.method_1603() * 0.5;
        this.selectedY = -this.field_22787.field_1729.method_1604() * 0.5;
        int limit = 80;
        if (this.selectedX > (double)limit) {
            this.selectedX = limit;
        }
        if (this.selectedX < (double)(-limit)) {
            this.selectedX = -limit;
        }
        if (this.selectedY > (double)limit) {
            this.selectedY = limit;
        }
        if (this.selectedY < (double)(-limit)) {
            this.selectedY = -limit;
        }
        this.selected = 1;
        if (this.selectedY < -20.0) {
            ++this.selected;
        }
        if (this.selectedY > 54.0) {
            --this.selected;
        }
        if (this.selectedX < 0.0) {
            this.selected += 3;
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.wheelparts[this.selected]);
        graphics.method_25302(this.wheelparts[this.selected], this.field_22789 / 2 - 31, yoffset, 0, 0, 85, 55);
        for (int slot : this.dialog.options.keySet()) {
            DialogOption option = this.dialog.options.get(slot);
            if (option == null || option.optionType == 2 || option.hasDialog() && !option.getDialog().availability.isAvailable((class_1657)this.player)) continue;
            int color = option.optionColor;
            if (slot == this.selected) {
                color = 8622040;
            }
            int height = ClientProxy.Font.height(option.title);
            if (slot == 0) {
                graphics.method_25303(this.field_22793, option.title, this.field_22789 / 2 + 13, yoffset - height, color);
            }
            if (slot == 1) {
                graphics.method_25303(this.field_22793, option.title, this.field_22789 / 2 + 33, yoffset - height / 2 + 14, color);
            }
            if (slot == 2) {
                graphics.method_25303(this.field_22793, option.title, this.field_22789 / 2 + 27, yoffset + 27, color);
            }
            if (slot == 3) {
                graphics.method_25303(this.field_22793, option.title, this.field_22789 / 2 - 13 - ClientProxy.Font.width(option.title), yoffset - height, color);
            }
            if (slot == 4) {
                graphics.method_25303(this.field_22793, option.title, this.field_22789 / 2 - 33 - ClientProxy.Font.width(option.title), yoffset - height / 2 + 14, color);
            }
            if (slot != 5) continue;
            graphics.method_25303(this.field_22793, option.title, this.field_22789 / 2 - 27 - ClientProxy.Font.width(option.title), yoffset + 27, color);
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.indicator);
        graphics.method_25302(this.indicator, this.field_22789 / 2 + (int)this.selectedX / 4 - 2, yoffset + 16 - (int)this.selectedY / 6, 0, 0, 8, 8);
    }

    private void drawLinedOptions(class_332 graphics, int j) {
        int selected;
        graphics.method_25292(this.guiLeft - 60, this.guiLeft + this.imageWidth + 120, this.guiTop + this.dialogHeight - ClientProxy.Font.height(null) / 3, -1);
        int offset = this.dialogHeight;
        if (j >= this.guiTop + offset && (selected = (j - (this.guiTop + offset)) / ClientProxy.Font.height(null)) < this.options.size()) {
            this.selected = selected;
        }
        if (this.selected >= this.options.size()) {
            this.selected = 0;
        }
        if (this.selected < 0) {
            this.selected = 0;
        }
        for (int k = 0; k < this.options.size(); ++k) {
            int id = this.options.get(k);
            DialogOption option = this.dialog.options.get(id);
            int y = this.guiTop + offset + k * ClientProxy.Font.height(null);
            if (this.selected == k) {
                graphics.method_25303(this.field_22793, ">", this.guiLeft - 60, y, 0xE0E0E0);
            }
            graphics.method_25303(this.field_22793, NoppesStringUtils.formatText(option.title, new Object[]{this.player, this.npc}), this.guiLeft - 30, y, option.optionColor);
        }
    }

    private void drawString(class_332 graphics, String text, int left, int color, int count) {
        int height = count - this.rowStart;
        ClientProxy.Font.draw(graphics, text, this.guiLeft + left, this.guiTop + height * ClientProxy.Font.height(null), color);
    }

    private int getSelected() {
        if (this.selected <= 0) {
            return 0;
        }
        if (this.selected < this.options.size()) {
            return this.selected;
        }
        return this.options.size() - 1;
    }

    @Override
    public boolean method_25404(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (key == this.field_22787.field_1690.field_1894.field_1655.method_1444() || key == class_3675.method_15981((String)"key.keyboard.up").method_1444()) {
            --this.selected;
        }
        if (key == this.field_22787.field_1690.field_1881.field_1655.method_1444() || key == class_3675.method_15981((String)"key.keyboard.down").method_1444()) {
            ++this.selected;
        }
        if (key == class_3675.method_15981((String)"key.keyboard.enter").method_1444() || key == class_3675.method_15981((String)"key.keyboard.keypad.enter").method_1444()) {
            this.handleDialogSelection();
        }
        if (this.closeOnEsc && (key == class_3675.method_15981((String)"key.keyboard.escape").method_1444() || this.isInventoryKey(key))) {
            Packets.sendServer(new SPacketDialogSelected(this.dialog.id, -1));
            this.closed();
            this.method_25419();
        }
        return true;
    }

    @Override
    public boolean method_25402(double i, double j, int k) {
        if ((this.selected == -1 && this.options.isEmpty() || this.selected >= 0) && k == 0) {
            this.handleDialogSelection();
        }
        return true;
    }

    private void handleDialogSelection() {
        int optionId = -1;
        if (this.dialog.showWheel) {
            optionId = this.selected;
        } else if (!this.options.isEmpty()) {
            optionId = this.options.get(this.selected);
        }
        Packets.sendServer(new SPacketDialogSelected(this.dialog.id, optionId));
        if (this.dialog == null || !this.dialog.hasOtherOptions() || this.options.isEmpty()) {
            if (this.closeOnEsc) {
                this.closed();
                this.method_25419();
            }
            return;
        }
        DialogOption option = this.dialog.options.get(optionId);
        if (option == null || option.optionType != 1) {
            if (this.closeOnEsc) {
                this.closed();
                this.method_25419();
            }
            return;
        }
        this.lines.add(new TextBlockClient(this.player.method_5476().getString(), option.title, 280, option.optionColor, new Object[]{this.player, this.npc}));
        this.calculateRowHeight();
        NoppesUtil.clickSound();
    }

    private void closed() {
        this.grabMouse(false);
        Packets.sendServer(new SPacketQuestCompletionCheckAll());
    }

    public void appendDialog(Dialog dialog) {
        this.closeOnEsc = !dialog.disableEsc;
        this.dialog = dialog;
        this.options = new ArrayList<Integer>();
        if (dialog.sound != null && !dialog.sound.isEmpty()) {
            MusicController.Instance.stopMusic();
            class_2338 pos = this.npc.method_24515();
            MusicController.Instance.playSound(class_3419.field_15246, dialog.sound, pos, 1.0f, 1.0f);
        }
        this.lines.add(new TextBlockClient(this.npc.method_5671(), dialog.text, 280, 0xE0E0E0, new Object[]{this.player, this.npc}));
        for (int slot : dialog.options.keySet()) {
            DialogOption option = dialog.options.get(slot);
            if (option == null || !option.isAvailable((class_1657)this.player)) continue;
            this.options.add(slot);
        }
        this.calculateRowHeight();
        this.grabMouse(dialog.showWheel);
    }

    private void calculateRowHeight() {
        if (this.dialog.showWheel) {
            this.dialogHeight = this.imageHeight - 58;
        } else {
            this.dialogHeight = this.imageHeight - 3 * ClientProxy.Font.height(null) - 4;
            if (this.dialog.options.size() > 3) {
                this.dialogHeight -= (this.dialog.options.size() - 3) * ClientProxy.Font.height(null);
            }
        }
        this.rowTotal = 0;
        for (TextBlockClient block : this.lines) {
            this.rowTotal += block.lines.size() + 1;
        }
        int max = this.dialogHeight / ClientProxy.Font.height(null);
        this.rowStart = this.rowTotal - max;
        if (this.rowStart < 0) {
            this.rowStart = 0;
        }
    }

    @Override
    public void setClose(class_2487 data) {
        this.grabMouse(false);
    }

    @Override
    public void save() {
    }
}

