/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player.moderngui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.player.moderngui.GuiQuestModern;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.MouseHelperMixin;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketDialogSelected;
import noppes.npcs.packets.server.SPacketQuestCompletionCheckAll;
import noppes.npcs.shared.client.gui.listeners.IGuiClose;

public class GuiDialogModern
extends GuiNPCInterface
implements IGuiClose {
    private Dialog dialog;
    private int selected = -1;
    private List<Integer> options = new ArrayList<Integer>();
    private final class_2960 decomposed = new class_2960("customnpcs", "textures/gui/dialog_menu_decomposed.png");
    private boolean isGrabbed = false;

    public GuiDialogModern(EntityNPCInterface npc, Dialog dialog) {
        super(npc);
        this.dialog = dialog;
        this.appendDialog(dialog);
        this.imageHeight = 238;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.isGrabbed = false;
        this.grabMouse(this.dialog.showWheel);
        this.guiTop = this.field_22790 - this.imageHeight;
    }

    public void grabMouse(boolean grab) {
        if (grab && !this.isGrabbed) {
            MouseHelperMixin mouse = (MouseHelperMixin)class_310.method_1551().field_1729;
            mouse.setGrabbed(false);
            double xpos = 0.0;
            double ypos = 0.0;
            mouse.setX(xpos);
            mouse.setY(ypos);
            class_3675.method_15984((long)this.field_22787.method_22683().method_4490(), (int)212995, (double)xpos, (double)ypos);
            this.isGrabbed = true;
        } else if (!grab && this.isGrabbed) {
            class_310.method_1551().field_1729.method_1610();
            this.isGrabbed = false;
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25296(0, 0, this.field_22789, this.field_22790, 0x66000000, 0x66000000);
        this.method_57734(partialTicks);
        double wcoeff = (double)this.field_22789 / 960.0;
        double hcoeff = (double)this.field_22790 / 509.0;
        if (!this.dialog.hideNPC && !(this.npc instanceof EntityDialogNpc)) {
            this.drawNpc(graphics, (class_1309)this.npc, -210 + (int)(300.0 * (1.0 - wcoeff)), 350 - (int)(100.0 * (1.0 - hcoeff)), (float)(9.5 * hcoeff), -20);
        }
        int textBlockWidth = (int)(700.0 * wcoeff);
        int lineCount = this.getLineCount(this.dialog.text, textBlockWidth);
        int gap = Math.max(16, Math.min((int)(2.6f * (float)lineCount), 32));
        int textPartHeight = 26 + lineCount * ClientProxy.Font.height(null) + 2 * gap;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(0.0, 0.5, 2000.0650024414062);
        graphics.method_25296(0, this.field_22790 - textPartHeight, this.field_22789, this.field_22790, -1157627904, -1157627904);
        this.drawLine(graphics, 23, this.field_22790 - textPartHeight + 23, this.field_22789 - 23);
        graphics.method_51448().method_22905(1.5f, 1.5f, 1.0f);
        graphics.method_27535(this.field_22793, this.npc.method_5476(), 31, (int)((double)(this.field_22790 - textPartHeight + 5) / 1.5), -1);
        graphics.method_51448().method_22905(0.6666667f, 0.6666667f, 1.0f);
        this.drawTextBlock(graphics, this.dialog.text, (this.field_22789 - textBlockWidth) / 2, this.field_22790 - textPartHeight + 23 + 3 + gap, textBlockWidth);
        this.selected = -1;
        graphics.method_51448().method_22905((float)wcoeff, (float)wcoeff, (float)wcoeff);
        for (int i = 0; i < this.options.size(); ++i) {
            int optionHeight = (int)(220.0 * hcoeff + (double)(i * 19));
            int optionNum = this.options.get(i);
            DialogOption option = this.dialog.options.get(optionNum);
            if ((double)mouseX >= 723.0 * wcoeff && (double)mouseX <= 946.0 * wcoeff && (double)mouseY >= (double)optionHeight * wcoeff && (double)mouseY <= (double)(optionHeight + 13) * wcoeff) {
                this.selected = i;
            }
            RenderSystem.enableBlend();
            graphics.method_25302(this.decomposed, 723, optionHeight, 0, i == this.selected ? 13 : 0, 223, 13);
            RenderSystem.disableBlend();
            if (this.getQuestByOptionId(optionNum) != null) {
                graphics.method_25303(this.field_22793, "!", 727, optionHeight + 3, 7792731);
            } else {
                graphics.method_25303(this.field_22793, ">", 727, optionHeight + 3, -1);
            }
            graphics.method_25303(this.field_22793, option.title, 735, optionHeight + 3, option.optionColor);
        }
        graphics.method_51448().method_22909();
    }

    public Quest getQuestByOptionId(int id) {
        DialogOption option = this.dialog.options.get(id);
        if (option != null && option.getDialog() != null && option.getDialog().hasQuest()) {
            return option.getDialog().getQuest();
        }
        return null;
    }

    public void drawLine(class_332 graphics, int x, int y, int width) {
        graphics.method_25294(x, y, width, y + 1, -7522304);
        graphics.method_25294(x, y + 1, width, y + 2, -88773);
        graphics.method_25294(x, y + 2, width, y + 3, -5352703);
    }

    public void renderBackground(class_332 graphics, int p_238651_2_) {
        graphics.method_25296(0, 0, this.field_22789, this.field_22790, 0x66000000, 0x66000000);
    }

    @Override
    public boolean method_25404(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if ((key == class_3675.method_15981((String)"key.keyboard.enter").method_1444() || key == class_3675.method_15981((String)"key.keyboard.keypad.enter").method_1444()) && (this.selected == -1 && this.options.isEmpty() || this.selected >= 0)) {
            this.handleDialogSelection();
        }
        if (this.closeOnEsc && (key == class_3675.method_15981((String)"key.keyboard.escape").method_1444() || this.isInventoryKey(key))) {
            Packets.sendServer(new SPacketDialogSelected(this.dialog.id, -1));
            this.closed();
            this.method_25419();
        }
        return true;
    }

    @Override
    public boolean method_25402(double i, double j, int k) {
        if ((this.selected == -1 && this.options.isEmpty() || this.selected >= 0) && k == 0) {
            this.handleDialogSelection();
        }
        return true;
    }

    private void handleDialogSelection() {
        int optionId = -1;
        if (this.dialog.showWheel) {
            optionId = this.selected;
        } else if (!this.options.isEmpty()) {
            optionId = this.options.get(this.selected);
        }
        if (this.getQuestByOptionId(optionId) == null) {
            Packets.sendServer(new SPacketDialogSelected(this.dialog.id, optionId));
        } else {
            class_310.method_1551().method_1507((class_437)new GuiQuestModern(this.npc, this.getQuestByOptionId(optionId), this.dialog, optionId));
        }
        if (this.dialog != null && this.dialog.hasOtherOptions() && !this.options.isEmpty()) {
            DialogOption option = this.dialog.options.get(optionId);
            if (option != null && option.optionType == 1) {
                NoppesUtil.clickSound();
            } else if (this.closeOnEsc) {
                this.closed();
                this.method_25419();
            }
        } else if (this.closeOnEsc) {
            this.closed();
            this.method_25419();
        }
    }

    private void closed() {
        this.grabMouse(false);
        Packets.sendServer(new SPacketQuestCompletionCheckAll());
    }

    public void drawTextBlock(class_332 graphics, String text, int x, int y, int width) {
        TextBlockClient block = new TextBlockClient("", text, width, -1, new Object[]{this.player, this.npc});
        int count = 0;
        for (class_2561 line : block.lines) {
            int height = y + count * ClientProxy.Font.height(null);
            graphics.method_27534(this.field_22793, line, x + width / 2, height, -1);
            ++count;
        }
    }

    public int getLineCount(String text, int width) {
        TextBlockClient block = new TextBlockClient("", text, width, -1, new Object[]{this.player, this.npc});
        return block.lines.size();
    }

    public void appendDialog(Dialog dialog) {
        this.closeOnEsc = !dialog.disableEsc;
        this.dialog = dialog;
        this.options = new ArrayList<Integer>();
        if (dialog.sound != null && !dialog.sound.isEmpty()) {
            MusicController.Instance.stopMusic();
            class_2338 pos = this.npc.method_24515();
            MusicController.Instance.playSound(class_3419.field_15246, dialog.sound, pos, 1.0f, 1.0f);
        }
        for (int slot : dialog.options.keySet()) {
            DialogOption option = dialog.options.get(slot);
            if (option == null || !option.isAvailable((class_1657)this.player)) continue;
            this.options.add(slot);
        }
        this.grabMouse(dialog.showWheel);
    }

    @Override
    public void setClose(class_2487 data) {
        this.grabMouse(false);
    }
}

