/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.layer;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_922;
import noppes.npcs.ModelData;
import noppes.npcs.ModelPartData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.shared.client.model.NopModelPart;

public abstract class LayerInterface
extends class_3887 {
    protected class_922 render;
    protected EntityCustomNpc npc;
    protected ModelData playerdata;
    public class_572 base;
    private int color;

    public LayerInterface(class_922 render) {
        super((class_3883)render);
        this.render = render;
        this.base = (class_572)render.method_4038();
    }

    public void setColor(ModelPartData data, class_1309 entity) {
    }

    protected float red() {
        if (this.npc.field_6235 > 0 || this.npc.field_6213 > 0) {
            return 1.0f;
        }
        return (float)(this.color >> 16 & 0xFF) / 255.0f;
    }

    protected float green() {
        if (this.npc.field_6235 > 0 || this.npc.field_6213 > 0) {
            return 0.0f;
        }
        return (float)(this.color >> 8 & 0xFF) / 255.0f;
    }

    protected float blue() {
        if (this.npc.field_6235 > 0 || this.npc.field_6213 > 0) {
            return 0.0f;
        }
        return (float)(this.color & 0xFF) / 255.0f;
    }

    protected float alpha() {
        boolean flag = !this.npc.method_5767();
        boolean flag1 = !flag && !this.npc.method_5756((class_1657)class_310.method_1551().field_1724);
        return flag1 ? 0.15f : 0.99f;
    }

    public void preRender(ModelPartData data) {
        if (this.npc.field_6235 > 0 || this.npc.field_6213 > 0) {
            return;
        }
        this.color = data.color;
        if (this.npc.display.getTint() != 0xFFFFFF) {
            this.color = data.color != 0xFFFFFF ? this.blend(data.color, this.npc.display.getTint(), 0.5f) : this.npc.display.getTint();
        }
    }

    public int blend(int color1, int color2, float ratio) {
        if (ratio >= 1.0f) {
            return color2;
        }
        if (ratio <= 0.0f) {
            return color1;
        }
        int aR = (color1 & 0xFF0000) >> 16;
        int aG = (color1 & 0xFF00) >> 8;
        int aB = color1 & 0xFF;
        int bR = (color2 & 0xFF0000) >> 16;
        int bG = (color2 & 0xFF00) >> 8;
        int bB = color2 & 0xFF;
        int R = (int)((float)aR + (float)(bR - aR) * ratio);
        int G = (int)((float)aG + (float)(bG - aG) * ratio);
        int B = (int)((float)aB + (float)(bB - aB) * ratio);
        return R << 16 | G << 8 | B;
    }

    public void method_4199(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, class_1297 entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.npc = (EntityCustomNpc)entity;
        if (this.npc.method_5756((class_1657)class_310.method_1551().field_1724)) {
            return;
        }
        this.playerdata = this.npc.modelData;
        this.base = (class_572)this.render.method_4038();
        this.rotate(matrixStackIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        matrixStackIn.method_22903();
        if (entity.method_5767()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
        }
        if (this.npc.field_6235 > 0 || this.npc.field_6213 > 0) {
            // empty if block
        }
        if (this.npc.method_18276()) {
            // empty if block
        }
        this.render(matrixStackIn, bufferIn, packedLightIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        if (entity.method_5767()) {
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrixStackIn.method_22909();
    }

    public class_1921 getRenderType(ModelPartData data) {
        class_2960 resource = this.npc.textureLocation;
        if (!data.playerTexture) {
            resource = data.getResource();
        }
        return class_1921.method_23580((class_2960)resource);
    }

    public void setRotation(NopModelPart model, float x, float y, float z) {
        model.xRot = x;
        model.yRot = y;
        model.zRot = z;
    }

    public abstract void render(class_4587 var1, class_4597 var2, int var3, float var4, float var5, float var6, float var7, float var8, float var9);

    public abstract void rotate(class_4587 var1, float var2, float var3, float var4, float var5, float var6, float var7);
}

