/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.parts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_5250;
import noppes.npcs.ModelEyeData;
import noppes.npcs.client.parts.AnimationContainer;
import noppes.npcs.client.parts.MpmPart;
import noppes.npcs.client.parts.MpmPartAnimation;
import noppes.npcs.client.parts.MpmPartBedrock;
import noppes.npcs.client.parts.MpmPartEyes;
import noppes.npcs.client.parts.MpmPartSimple;
import noppes.npcs.client.parts.PartBehaviorType;
import noppes.npcs.client.parts.PartRenderType;
import noppes.npcs.constants.BodyPart;
import noppes.npcs.shared.client.util.AssetsFinder;
import noppes.npcs.shared.common.NoppesException;
import noppes.npcs.shared.common.util.LogWriter;
import noppes.npcs.shared.common.util.NopVector2i;
import noppes.npcs.shared.common.util.NopVector3f;
import noppes.npcs.shared.common.util.NopVector3i;

public class MpmPartReader {
    public static Map<class_2960, MpmPart> PARTS = new HashMap<class_2960, MpmPart>();
    public static Map<String, List<AnimationContainer>> ANIMATIONS = new HashMap<String, List<AnimationContainer>>();

    public static void reload() {
        HashMap<String, List<AnimationContainer>> mapA = new HashMap<String, List<AnimationContainer>>();
        List<class_2960> list = AssetsFinder.find("animations", ".json");
        for (class_2960 loc : list) {
            class_3298 class_32982 = class_310.method_1551().method_1478().method_14486(loc).orElse(null);
            if (class_32982 == null) continue;
            try {
                InputStream stream = class_32982.method_14482();
                try {
                    JsonObject root = JsonParser.parseReader((Reader)new InputStreamReader(stream, "UTF-8")).getAsJsonObject();
                    mapA.put(loc.method_12832().substring(11, loc.method_12832().length() - 5), MpmPartAnimation.loadAnimations(root));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Throwable stream) {}
        }
        ANIMATIONS = mapA;
        HashMap<class_2960, MpmPart> map = new HashMap<class_2960, MpmPart>();
        list = AssetsFinder.find("parts", ".json");
        for (class_2960 class_29602 : list) {
            MpmPart part = MpmPartReader.loadPart(class_29602);
            if (part == null) continue;
            map.put(class_29602, part);
        }
        PARTS = map;
        PARTS.put(ModelEyeData.RESOURCE, new MpmPartEyes(0, ModelEyeData.RESOURCE));
        PARTS.put(ModelEyeData.RESOURCE_RIGHT, new MpmPartEyes(1, ModelEyeData.RESOURCE_RIGHT));
        PARTS.put(ModelEyeData.RESOURCE_LEFT, new MpmPartEyes(2, ModelEyeData.RESOURCE_LEFT));
        for (Map.Entry entry : PARTS.entrySet()) {
            if (((MpmPart)entry.getValue()).parentId == null || PARTS.containsKey(((MpmPart)entry.getValue()).parentId)) continue;
            LogWriter.error("Error in " + ((class_2960)entry.getKey()).toString() + " - Unable to find parent " + String.valueOf(((MpmPart)entry.getValue()).parentId));
            MpmPartReader.Notify((class_2561)class_2561.method_43470((String)("Error in " + ((class_2960)entry.getKey()).toString() + " - Unable to find parent " + String.valueOf(((MpmPart)entry.getValue()).parentId))));
        }
    }

    private static MpmPart loadPart(class_2960 location) {
        class_3298 r = class_310.method_1551().method_1478().method_14486(location).orElse(null);
        if (r != null) {
            MpmPart mpmPart;
            block15: {
                InputStream stream = r.method_14482();
                try {
                    JsonObject root = JsonParser.parseReader((Reader)new InputStreamReader(stream, "UTF-8")).getAsJsonObject();
                    PartRenderType renderType = PartRenderType.valueOf(MpmPartReader.getRequiredString(root, "render_type").toUpperCase(Locale.ROOT));
                    MpmPart part = new MpmPart();
                    if (renderType == PartRenderType.BEDROCK) {
                        part = new MpmPartBedrock();
                    }
                    if (renderType == PartRenderType.SIMPLE) {
                        part = new MpmPartSimple();
                    }
                    part.isEnabled = !root.has("enabled") || root.get("enabled").getAsBoolean();
                    part.id = location;
                    part.name = MpmPartReader.getRequiredString(root, "name");
                    part.texture = root.has("texture") ? class_2960.method_12829((String)root.get("texture").getAsString()) : null;
                    part.menu = MpmPartReader.getRequiredString(root, "menu");
                    part.author = MpmPartReader.getRequiredString(root, "author");
                    part.translate = MpmPartReader.jsonVector3f(root.get("translate"));
                    part.scale = MpmPartReader.jsonVector3fOrOne(root.get("scale"));
                    part.rotatePoint = MpmPartReader.jsonVector3f(root.get("rotate_offset"));
                    part.rotate = MpmPartReader.jsonVector3f(root.get("rotate"));
                    part.previewRotation = root.get("preview_rotation").getAsInt();
                    part.hiddenParts = MpmPartReader.jsonEnumList(BodyPart.class, root.get("hidden_parts"));
                    part.disableCustomTextures = root.has("disable_custom_textures") && root.get("disable_custom_textures").getAsBoolean();
                    part.defaultUsePlayerSkins = root.has("default_use_player_skins") && root.get("default_use_player_skins").getAsBoolean();
                    part.renderType = renderType;
                    part.bodyPart = BodyPart.valueOf(MpmPartReader.getRequiredString(root, "body_part").toUpperCase(Locale.ROOT));
                    part.load(root.has("render_data") ? root.get("render_data").getAsJsonObject() : null);
                    if (root.has("parent")) {
                        part.parentId = class_2960.method_12829((String)root.get("parent").getAsString());
                    }
                    PartBehaviorType partBehaviorType = part.animationType = root.has("animation_type") ? PartBehaviorType.valueOf(root.get("animation_type").getAsString().toUpperCase(Locale.ROOT)) : PartBehaviorType.NONE;
                    if (root.has("animation_inherit")) {
                        String inpart = root.get("animation_inherit").getAsString().toLowerCase(Locale.ROOT);
                        if (!ANIMATIONS.containsKey(inpart)) {
                            throw new NoppesException("Unknown animation inherit: " + inpart, new Object[0]);
                        }
                        part.animationData.load(ANIMATIONS.get(inpart), part);
                    }
                    if (root.has("animation_data")) {
                        part.animationData.load(MpmPartAnimation.loadAnimations(root.get("animation_data").getAsJsonObject()), part);
                    }
                    mpmPart = part;
                    if (stream == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        LogWriter.error("Error in " + location.toString(), e);
                        MpmPartReader.Notify((class_2561)class_2561.method_43470((String)("Error in " + String.valueOf(location) + " - " + e.getMessage())));
                    }
                }
                stream.close();
            }
            return mpmPart;
        }
        return null;
    }

    public static String getRequiredString(JsonObject root, String part) {
        if (!root.has(part)) {
            throw new NoppesException("Can't fine " + part, new Object[0]);
        }
        return root.get(part).getAsString();
    }

    public static <T extends Enum> List<T> jsonEnumList(Class<T> type, JsonElement el) {
        ArrayList<T> list = new ArrayList<T>();
        if (el == null || !el.isJsonArray()) {
            return list;
        }
        JsonArray arr = el.getAsJsonArray();
        for (int i = 0; i < arr.size(); ++i) {
            list.add(Enum.valueOf(type, arr.get(i).getAsString().toUpperCase(Locale.ROOT)));
        }
        return list;
    }

    public static NopVector2i jsonVector2i(JsonElement el) {
        if (el == null || !el.isJsonArray()) {
            return NopVector2i.ZERO;
        }
        JsonArray arr = el.getAsJsonArray();
        int[] r = new int[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            r[i] = arr.get(i).getAsInt();
        }
        return new NopVector2i(r);
    }

    public static NopVector3i jsonVector3i(JsonElement el) {
        if (el == null || !el.isJsonArray()) {
            return NopVector3i.ZERO;
        }
        JsonArray arr = el.getAsJsonArray();
        int[] r = new int[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            r[i] = arr.get(i).getAsInt();
        }
        return new NopVector3i(r);
    }

    public static NopVector3f jsonVector3f(JsonElement el) {
        if (el == null) {
            return NopVector3f.ZERO;
        }
        JsonArray arr = el.getAsJsonArray();
        float[] r = new float[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            r[i] = arr.get(i).getAsFloat();
        }
        return new NopVector3f(r);
    }

    public static NopVector3f jsonVector3fOrOne(JsonElement el) {
        if (el == null) {
            return NopVector3f.ONE;
        }
        JsonArray arr = el.getAsJsonArray();
        float[] r = new float[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            r[i] = arr.get(i).getAsFloat();
        }
        return new NopVector3f(r);
    }

    public static void Notify(class_2561 message) {
        class_5250 chatcomponenttranslation = ((class_5250)message).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
        if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_9201()) {
            class_310.method_1551().field_1724.method_43496((class_2561)chatcomponenttranslation);
        }
    }
}

