/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.data.Bank;

public class BankController {
    public HashMap<Integer, Bank> banks;
    private String filePath = "";
    private static BankController instance;

    public BankController(class_7225.class_7874 lookupProvider) {
        instance = this;
        this.banks = new HashMap();
        this.loadBanks(lookupProvider);
        if (this.banks.isEmpty()) {
            Bank bank = new Bank();
            bank.id = 0;
            bank.name = "Default Bank";
            for (int i = 0; i < 6; ++i) {
                bank.slotTypes.put(i, 0);
            }
            this.banks.put(bank.id, bank);
        }
    }

    public static BankController getInstance(class_7225.class_7874 lookupProvider) {
        if (BankController.newInstance()) {
            instance = new BankController(lookupProvider);
        }
        return instance;
    }

    private static boolean newInstance() {
        if (instance == null) {
            return true;
        }
        File file = CustomNpcs.getLevelSaveDirectory();
        if (file == null) {
            return false;
        }
        return !BankController.instance.filePath.equals(file.getAbsolutePath());
    }

    private void loadBanks(class_7225.class_7874 lookupProvider) {
        File saveDir = CustomNpcs.getLevelSaveDirectory();
        if (saveDir == null) {
            return;
        }
        this.filePath = saveDir.getAbsolutePath();
        try {
            File file = new File(saveDir, "bank.dat");
            if (file.exists()) {
                this.loadBanks(lookupProvider, file);
            }
        }
        catch (Exception e) {
            try {
                File file = new File(saveDir, "bank.dat_old");
                if (file.exists()) {
                    this.loadBanks(lookupProvider, file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadBanks(class_7225.class_7874 lookupProvider, File file) throws IOException {
        this.loadBanks(lookupProvider, class_2507.method_10629((InputStream)new FileInputStream(file), (class_2505)class_2505.method_53898()));
    }

    public void loadBanks(class_7225.class_7874 lookupProvider, class_2487 nbttagcompound1) throws IOException {
        HashMap<Integer, Bank> banks = new HashMap<Integer, Bank>();
        class_2499 list = nbttagcompound1.method_10554("Data", 10);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                class_2487 nbttagcompound = list.method_10602(i);
                Bank bank = new Bank();
                bank.readAdditionalSaveData(lookupProvider, nbttagcompound);
                banks.put(bank.id, bank);
            }
        }
        this.banks = banks;
    }

    public class_2487 getNBT(class_7225.class_7874 lookupProvider) {
        class_2499 list = new class_2499();
        for (Bank bank : this.banks.values()) {
            class_2487 nbtfactions = new class_2487();
            bank.addAdditionalSaveData(lookupProvider, nbtfactions);
            list.add((Object)nbtfactions);
        }
        class_2487 nbttagcompound = new class_2487();
        nbttagcompound.method_10566("Data", (class_2520)list);
        return nbttagcompound;
    }

    public Bank getBank(int bankId) {
        Bank bank = this.banks.get(bankId);
        if (bank != null) {
            return bank;
        }
        return this.banks.values().iterator().next();
    }

    public void saveBanks(class_7225.class_7874 lookupProvider) {
        try {
            File saveDir = CustomNpcs.getLevelSaveDirectory();
            File file = new File(saveDir, "bank.dat_new");
            File file1 = new File(saveDir, "bank.dat_old");
            File file2 = new File(saveDir, "bank.dat");
            class_2507.method_10634((class_2487)this.getNBT(lookupProvider), (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveBank(class_7225.class_7874 lookupProvider, Bank bank) {
        if (bank.id < 0) {
            bank.id = this.getUnusedId();
        }
        this.banks.put(bank.id, bank);
        this.saveBanks(lookupProvider);
    }

    public int getUnusedId() {
        int id = 0;
        while (this.banks.containsKey(id)) {
            ++id;
        }
        return id;
    }

    public void removeBank(class_7225.class_7874 lookupProvider, int bank) {
        if (bank < 0 || this.banks.size() <= 1) {
            return;
        }
        this.banks.remove(bank);
        this.saveBanks(lookupProvider);
    }
}

