/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.wrapper.WorldWrapper;
import noppes.npcs.controllers.data.ForgeScriptData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.shared.common.util.LogWriter;
import noppes.npcs.util.NBTJsonUtil;

public class ScriptController {
    public static ScriptController Instance;
    public static boolean HasStart;
    private ScriptEngineManager manager;
    public Map<String, String> languages = new HashMap<String, String>();
    public Map<String, ScriptEngineFactory> factories = new HashMap<String, ScriptEngineFactory>();
    public Map<String, String> scripts = new HashMap<String, String>();
    public PlayerScriptData playerScripts = new PlayerScriptData(null);
    public ForgeScriptData forgeScripts = new ForgeScriptData();
    public long lastLoaded = 0L;
    public long lastPlayerUpdate = 0L;
    public File dir;
    public class_2487 compound = new class_2487();
    private boolean loaded = false;
    public boolean shouldSave = false;

    public ScriptController() {
        Instance = this;
        if (!CustomNpcs.NashorArguments.isEmpty()) {
            System.setProperty("nashorn.args", CustomNpcs.NashorArguments);
        }
        LogWriter.info("Script Engines Available:");
        try {
            ScriptEngineFactory factory;
            Object c3;
            this.manager = new ScriptEngineManager();
            try {
                if (this.manager.getEngineByName("ecmascript") == null) {
                    c3 = Class.forName("org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory");
                    factory = (ScriptEngineFactory)((Class)c3).newInstance();
                    factory.getScriptEngine();
                    LogWriter.info(factory.getLanguageName() + ": .js");
                    this.manager.registerEngineName("ecmascript", factory);
                    this.manager.registerEngineExtension("js", factory);
                    this.manager.registerEngineMimeType("application/ecmascript", factory);
                    this.languages.put(factory.getLanguageName(), ".js");
                    this.factories.put(factory.getLanguageName().toLowerCase(Locale.ROOT), factory);
                }
            }
            catch (Throwable c2) {
                // empty catch block
            }
            try {
                c3 = Class.forName("org.jetbrains.kotlin.script.jsr223.KotlinJsr223JvmLocalScriptEngineFactory");
                factory = (ScriptEngineFactory)((Class)c3).newInstance();
                factory.getScriptEngine();
                LogWriter.info(factory.getLanguageName() + ": .ktl");
                this.manager.registerEngineName("kotlin", factory);
                this.manager.registerEngineExtension("ktl", factory);
                this.manager.registerEngineMimeType("application/kotlin", factory);
                this.languages.put(factory.getLanguageName(), ".ktl");
                this.factories.put(factory.getLanguageName().toLowerCase(Locale.ROOT), factory);
            }
            catch (Throwable c3) {
                // empty catch block
            }
            try {
                c3 = Class.forName("noppes.scriptengines.ScriptEngines");
                List seFactories = (List)((Class)c3).getDeclaredField("factories").get(null);
                for (ScriptEngineFactory fac : seFactories) {
                    if (fac.getExtensions().size() == 0 || this.languages.containsKey(fac.getLanguageName()) || !(fac.getScriptEngine() instanceof Invocable) && !fac.getLanguageName().equals("lua")) continue;
                    String ext = "." + fac.getExtensions().get(0).toLowerCase(Locale.ROOT);
                    LogWriter.info(fac.getLanguageName() + ": " + ext);
                    this.languages.put(fac.getLanguageName(), ext);
                    this.factories.put(fac.getLanguageName().toLowerCase(Locale.ROOT), fac);
                }
            }
            catch (Throwable c4) {
                // empty catch block
            }
            for (ScriptEngineFactory fac : this.manager.getEngineFactories()) {
                try {
                    if (fac.getExtensions().size() == 0 || this.languages.containsKey(fac.getLanguageName()) || !(fac.getScriptEngine() instanceof Invocable) && !fac.getLanguageName().equals("lua")) continue;
                    String ext = "." + fac.getExtensions().get(0).toLowerCase(Locale.ROOT);
                    LogWriter.info(fac.getLanguageName() + ": " + ext);
                    this.languages.put(fac.getLanguageName(), ext);
                    this.factories.put(fac.getLanguageName().toLowerCase(Locale.ROOT), fac);
                }
                catch (Throwable e) {
                    LogWriter.except(e);
                }
            }
        }
        catch (Throwable e) {
            LogWriter.except(e);
        }
    }

    public void loadCategories() {
        this.dir = new File(CustomNpcs.getLevelSaveDirectory(), "scripts");
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        if (!this.worldDataFile().exists()) {
            this.shouldSave = true;
        }
        WorldWrapper.tempData.clear();
        this.scripts.clear();
        for (String language : this.languages.keySet()) {
            String ext = this.languages.get(language);
            File scriptDir = new File(this.dir, language.toLowerCase(Locale.ROOT));
            if (!scriptDir.exists()) {
                scriptDir.mkdir();
                continue;
            }
            this.loadDir(scriptDir, "", ext);
        }
        this.lastLoaded = System.currentTimeMillis();
    }

    private void loadDir(File dir, String name, String ext) {
        for (File file : dir.listFiles()) {
            String filename = name + file.getName().toLowerCase(Locale.ROOT);
            if (file.isDirectory()) {
                this.loadDir(file, filename + "/", ext);
                continue;
            }
            if (!filename.endsWith(ext)) continue;
            try {
                this.scripts.put(filename, this.readFile(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean loadStoredData() {
        this.compound = new class_2487();
        File file = this.worldDataFile();
        try {
            if (!file.exists()) {
                return false;
            }
            this.compound = NBTJsonUtil.LoadFile(file);
            this.shouldSave = false;
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            return false;
        }
        return true;
    }

    private File worldDataFile() {
        return new File(this.dir, "world_data.json");
    }

    private File playerScriptsFile() {
        return new File(this.dir, "player_scripts.json");
    }

    private File forgeScriptsFile() {
        return new File(this.dir, "forge_scripts.json");
    }

    public boolean loadPlayerScripts() {
        this.playerScripts.clear();
        File file = this.playerScriptsFile();
        try {
            if (!file.exists()) {
                return false;
            }
            this.playerScripts.load(NBTJsonUtil.LoadFile(file));
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            return false;
        }
        return true;
    }

    public void setPlayerScripts(class_2487 compound) {
        this.playerScripts.load(compound);
        File file = this.playerScriptsFile();
        try {
            NBTJsonUtil.SaveFile(file, compound);
            this.lastPlayerUpdate = System.currentTimeMillis();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NBTJsonUtil.JsonException e) {
            e.printStackTrace();
        }
    }

    public boolean loadForgeScripts() {
        this.forgeScripts.clear();
        File file = this.forgeScriptsFile();
        try {
            if (!file.exists()) {
                return false;
            }
            this.forgeScripts.load(NBTJsonUtil.LoadFile(file));
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            return false;
        }
        return true;
    }

    public void setForgeScripts(class_2487 compound) {
        this.forgeScripts.load(compound);
        File file = this.forgeScriptsFile();
        try {
            NBTJsonUtil.SaveFile(file, compound);
            this.forgeScripts.lastInited = -1L;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NBTJsonUtil.JsonException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
    }

    public ScriptEngine getEngineByName(String language) {
        ScriptEngineFactory fac = this.factories.get(language.toLowerCase(Locale.ROOT));
        if (fac == null) {
            return null;
        }
        return fac.getScriptEngine();
    }

    public class_2499 nbtLanguages() {
        class_2499 list = new class_2499();
        for (String language : this.languages.keySet()) {
            class_2487 compound = new class_2487();
            class_2499 scripts = new class_2499();
            for (String script : this.getScripts(language)) {
                scripts.add((Object)class_2519.method_23256((String)script));
            }
            compound.method_10566("Scripts", (class_2520)scripts);
            compound.method_10582("Language", language);
            list.add((Object)compound);
        }
        return list;
    }

    private List<String> getScripts(String language) {
        ArrayList<String> list = new ArrayList<String>();
        String ext = this.languages.get(language);
        if (ext == null) {
            return list;
        }
        for (String script : this.scripts.keySet()) {
            if (!script.endsWith(ext)) continue;
            list.add(script);
        }
        return list;
    }

    public void doSave(class_1937 level) {
        if (!this.shouldSave || !(level instanceof class_3218) || level.method_27983() != class_1937.field_25179) {
            return;
        }
        try {
            NBTJsonUtil.SaveFile(this.worldDataFile(), this.compound.method_10553());
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
        this.shouldSave = false;
    }

    public void saveLevel(class_1937 level) {
        this.doSave(level);
    }

    static {
        HasStart = false;
    }
}

