/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.entity.EntityNPCInterface;

public class VisibilityController {
    public static VisibilityController instance = new VisibilityController();
    private Map<Integer, EntityNPCInterface> trackedEntityHashTable = new TreeMap<Integer, EntityNPCInterface>();

    public void trackNpc(EntityNPCInterface npc) {
        if (npc.isClientSide()) {
            return;
        }
        boolean hasOptions = npc.display.availability.hasOptions();
        if ((hasOptions || npc.display.getVisible() != 0) && !this.trackedEntityHashTable.containsKey(npc.method_5628())) {
            this.trackedEntityHashTable.put(npc.method_5628(), npc);
        }
        if (!hasOptions && npc.display.getVisible() == 0 && this.trackedEntityHashTable.containsKey(npc.method_5628())) {
            this.trackedEntityHashTable.remove(npc.method_5628());
        }
    }

    public void remove(EntityNPCInterface npc) {
        if (npc.isClientSide()) {
            return;
        }
        this.trackedEntityHashTable.remove(npc.method_5628());
    }

    public void onUpdate(class_3222 player) {
        if (!CustomNpcs.EnableInvisibleNpcs || CustomNpcs.InvisibilityAlgorithm != 0) {
            return;
        }
        for (Map.Entry<Integer, EntityNPCInterface> entry : this.trackedEntityHashTable.entrySet()) {
            VisibilityController.checkIsVisible(entry.getValue(), player);
        }
    }

    public static void checkIsVisible(EntityNPCInterface npc, class_3222 playerMP) {
        if (!CustomNpcs.EnableInvisibleNpcs || CustomNpcs.InvisibilityAlgorithm != 0) {
            return;
        }
        if (npc.display.isVisibleTo((class_1657)playerMP) || playerMP.method_7325() || playerMP.method_6047().method_7909() == CustomItems.wand) {
            npc.setVisible(playerMP);
        } else {
            npc.setInvisible(playerMP);
        }
    }

    public static void addValue(HashMap<Integer, ArrayList<EntityNPCInterface>> map, int id, EntityNPCInterface npc) {
        ArrayList<EntityNPCInterface> npcs;
        if (!map.containsKey(id)) {
            map.put(id, new ArrayList());
        }
        if (!(npcs = map.get(id)).contains((Object)npc)) {
            npcs.add(npc);
            map.replace(id, npcs);
        }
    }
}

