/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import noppes.npcs.ICompatibilty;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.VersionCompatibility;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.api.handler.data.IQuestCategory;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.constants.EnumQuestCompletion;
import noppes.npcs.constants.EnumQuestRepeat;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.FactionOptions;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.db.DatabaseColumn;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketQuestCompletion;
import noppes.npcs.quests.QuestDialog;
import noppes.npcs.quests.QuestInterface;
import noppes.npcs.quests.QuestItem;
import noppes.npcs.quests.QuestKill;
import noppes.npcs.quests.QuestLocation;
import noppes.npcs.quests.QuestManual;

public class Quest
implements ICompatibilty,
IQuest {
    public int version = VersionCompatibility.ModRev;
    @DatabaseColumn(name="id", type=DatabaseColumn.Type.INT)
    public int id = -1;
    @DatabaseColumn(name="title", type=DatabaseColumn.Type.VARCHAR)
    public String title = "default";
    @DatabaseColumn(name="type", type=DatabaseColumn.Type.SMALLINT)
    public int type = 0;
    @DatabaseColumn(name="repeat_type", type=DatabaseColumn.Type.ENUM)
    public EnumQuestRepeat repeat = EnumQuestRepeat.NONE;
    @DatabaseColumn(name="completion_type", type=DatabaseColumn.Type.ENUM)
    public EnumQuestCompletion completion = EnumQuestCompletion.Npc;
    @DatabaseColumn(name="category", type=DatabaseColumn.Type.VARCHAR)
    public String categoryName;
    public QuestCategory category;
    @DatabaseColumn(name="log_text", type=DatabaseColumn.Type.TEXT)
    public String logText = "";
    @DatabaseColumn(name="complete_text", type=DatabaseColumn.Type.TEXT)
    public String completeText = "";
    @DatabaseColumn(name="complete_npc", type=DatabaseColumn.Type.VARCHAR)
    public String completerNpc = "";
    @DatabaseColumn(name="next_quest", type=DatabaseColumn.Type.INT)
    public int nextQuestid = -1;
    @DatabaseColumn(name="command", type=DatabaseColumn.Type.TEXT)
    public String command = "";
    @DatabaseColumn(name="mail_data", type=DatabaseColumn.Type.JSON)
    public class_2487 mailData = new class_2487();
    public PlayerMail mail = new PlayerMail();
    @DatabaseColumn(name="quest_data", type=DatabaseColumn.Type.JSON)
    public class_2487 questData = new class_2487();
    public QuestInterface questInterface = new QuestItem();
    @DatabaseColumn(name="reward_exp", type=DatabaseColumn.Type.INT)
    public int rewardExp = 0;
    @DatabaseColumn(name="reward_items", type=DatabaseColumn.Type.JSON)
    public class_2487 rewardItemsData = new class_2487();
    public NpcMiscInventory rewardItems = new NpcMiscInventory(9);
    @DatabaseColumn(name="reward_randomized", type=DatabaseColumn.Type.BOOLEAN)
    public boolean randomReward = false;
    @DatabaseColumn(name="faction_options", type=DatabaseColumn.Type.JSON)
    public FactionOptions factionOptions = new FactionOptions();

    public Quest(QuestCategory category) {
        this.category = category;
    }

    public void readNBT(class_7225.class_7874 lookupProvider, class_2487 compound) {
        this.id = compound.method_10550("Id");
        this.readNBTPartial(lookupProvider, compound);
    }

    public void readNBTPartial(class_7225.class_7874 lookupProvider, class_2487 compound) {
        this.version = compound.method_10550("ModRev");
        VersionCompatibility.CheckAvailabilityCompatibility(lookupProvider, this, compound);
        this.setType(compound.method_10550("Type"));
        this.title = compound.method_10558("Title");
        this.logText = compound.method_10558("Text");
        this.completeText = compound.method_10558("CompleteText");
        this.completerNpc = compound.method_10558("CompleterNpc");
        this.command = compound.method_10558("QuestCommand");
        this.nextQuestid = compound.method_10550("NextQuestId");
        this.randomReward = compound.method_10577("RandomReward");
        this.rewardExp = compound.method_10550("RewardExp");
        this.rewardItems.setFromNBT(lookupProvider, compound.method_10562("Rewards"));
        this.completion = EnumQuestCompletion.values()[compound.method_10550("QuestCompletion")];
        this.repeat = EnumQuestRepeat.values()[compound.method_10550("QuestRepeat")];
        this.questInterface.readAdditionalSaveData(lookupProvider, compound);
        this.factionOptions.load(compound.method_10562("QuestFactionPoints"));
        this.mail.readNBT(compound.method_10562("QuestMail"));
    }

    @Override
    public void setType(int questType) {
        this.type = questType;
        if (this.type == 0) {
            this.questInterface = new QuestItem();
        } else if (this.type == 1) {
            this.questInterface = new QuestDialog();
        } else if (this.type == 2 || this.type == 4) {
            this.questInterface = new QuestKill();
        } else if (this.type == 3) {
            this.questInterface = new QuestLocation();
        } else if (this.type == 5) {
            this.questInterface = new QuestManual();
        }
        if (this.questInterface != null) {
            this.questInterface.questId = this.id;
        }
    }

    @Override
    public class_2487 save(class_7225.class_7874 lookupProvider, class_2487 compound) {
        compound.method_10569("Id", this.id);
        return this.writeToNBTPartial(lookupProvider, compound);
    }

    public class_2487 writeToNBTPartial(class_7225.class_7874 lookupProvider, class_2487 compound) {
        compound.method_10569("ModRev", this.version);
        compound.method_10569("Type", this.type);
        compound.method_10582("Title", this.title);
        compound.method_10582("Text", this.logText);
        compound.method_10582("CompleteText", this.completeText);
        compound.method_10582("CompleterNpc", this.completerNpc);
        compound.method_10569("NextQuestId", this.nextQuestid);
        compound.method_10569("RewardExp", this.rewardExp);
        compound.method_10566("Rewards", (class_2520)this.rewardItems.getToNBT(lookupProvider));
        compound.method_10582("QuestCommand", this.command);
        compound.method_10556("RandomReward", this.randomReward);
        compound.method_10569("QuestCompletion", this.completion.ordinal());
        compound.method_10569("QuestRepeat", this.repeat.ordinal());
        this.questInterface.addAdditionalSaveData(lookupProvider, compound);
        compound.method_10566("QuestFactionPoints", (class_2520)this.factionOptions.save(new class_2487()));
        compound.method_10566("QuestMail", (class_2520)this.mail.writeNBT());
        return compound;
    }

    public boolean hasNewQuest() {
        return this.getNextQuest() != null;
    }

    @Override
    public Quest getNextQuest() {
        return QuestController.instance == null ? null : QuestController.instance.quests.get(this.nextQuestid);
    }

    public boolean complete(class_1657 player, QuestData data) {
        if (this.completion == EnumQuestCompletion.Instant) {
            Packets.send((class_3222)player, new PacketQuestCompletion(data.quest.id));
            return true;
        }
        return false;
    }

    public Quest copy(class_7225.class_7874 lookupProvider) {
        Quest quest = new Quest(this.category);
        quest.readNBT(lookupProvider, this.save(lookupProvider, new class_2487()));
        return quest;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public IQuestCategory getCategory() {
        return this.category;
    }

    @Override
    public void save(class_7225.class_7874 lookupProvider) {
        QuestController.instance.saveQuest(lookupProvider, this.category, this);
    }

    @Override
    public void setName(String name) {
        this.title = name;
    }

    @Override
    public String getLogText() {
        return this.logText;
    }

    @Override
    public void setLogText(String text) {
        this.logText = text;
    }

    @Override
    public String getCompleteText() {
        return this.completeText;
    }

    @Override
    public void setCompleteText(String text) {
        this.completeText = text;
    }

    @Override
    public void setNextQuest(IQuest quest) {
        if (quest == null) {
            this.nextQuestid = -1;
        } else {
            if (quest.getId() < 0) {
                throw new CustomNPCsException("Quest id is lower than 0", new Object[0]);
            }
            this.nextQuestid = quest.getId();
        }
    }

    @Override
    public String getNpcName() {
        return this.completerNpc;
    }

    @Override
    public void setNpcName(String name) {
        this.completerNpc = name;
    }

    @Override
    public IQuestObjective[] getObjectives(IPlayer player) {
        if (!player.hasActiveQuest(this.id)) {
            throw new CustomNPCsException("Player doesnt have this quest active.", new Object[0]);
        }
        return this.questInterface.getObjectives((class_1657)player.getMCEntity());
    }

    @Override
    public boolean getIsRepeatable() {
        return this.repeat != EnumQuestRepeat.NONE;
    }

    @Override
    public IContainer getRewards() {
        return NpcAPI.Instance().getIContainer((class_1263)this.rewardItems);
    }
}

