/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import noppes.npcs.api.entity.data.INPCRanged;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.shared.client.util.NoppesStringUtils;
import noppes.npcs.util.ValueUtil;

public class DataRanged
implements INPCRanged {
    private EntityNPCInterface npc;
    private int burstCount = 1;
    private int pDamage = 4;
    private int pSpeed = 10;
    private int pImpact = 0;
    private int pSize = 5;
    private int pArea = 0;
    private int pTrail = 0;
    private int minDelay = 20;
    private int maxDelay = 40;
    private int rangedRange = 15;
    private int fireRate = 5;
    private int shotCount = 1;
    private int accuracy = 60;
    private int meleeDistance = 0;
    private int canFireIndirect = 0;
    private boolean pRender3D = true;
    private boolean pSpin = false;
    private boolean pStick = false;
    private boolean pPhysics = true;
    private boolean pXlr8 = false;
    private boolean pGlows = false;
    private boolean aimWhileShooting = false;
    private int pEffect = 0;
    private int pDur = 5;
    private int pEffAmp = 0;
    private String fireSound = "minecraft:entity.arrow.shoot";
    private String hitSound = "minecraft:entity.arrow.hit";
    private String groundSound = "minecraft:block.stone.break";

    public DataRanged(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public void load(class_2487 compound) {
        this.pDamage = compound.method_10550("pDamage");
        this.pSpeed = compound.method_10550("pSpeed");
        this.burstCount = compound.method_10550("BurstCount");
        this.pImpact = compound.method_10550("pImpact");
        this.pSize = compound.method_10550("pSize");
        this.pArea = compound.method_10550("pArea");
        this.pTrail = compound.method_10550("pTrail");
        this.rangedRange = compound.method_10550("MaxFiringRange");
        this.fireRate = compound.method_10550("FireRate");
        this.minDelay = ValueUtil.CorrectInt(compound.method_10550("minDelay"), 1, 9999);
        this.maxDelay = ValueUtil.CorrectInt(compound.method_10550("maxDelay"), 1, 9999);
        this.shotCount = ValueUtil.CorrectInt(compound.method_10550("ShotCount"), 1, 10);
        this.accuracy = compound.method_10550("Accuracy");
        this.pRender3D = compound.method_10577("pRender3D");
        this.pSpin = compound.method_10577("pSpin");
        this.pStick = compound.method_10577("pStick");
        this.pPhysics = compound.method_10577("pPhysics");
        this.pXlr8 = compound.method_10577("pXlr8");
        this.pGlows = compound.method_10577("pGlows");
        this.aimWhileShooting = compound.method_10577("AimWhileShooting");
        this.pEffect = compound.method_10550("pEffect");
        this.pDur = compound.method_10550("pDur");
        this.pEffAmp = compound.method_10550("pEffAmp");
        this.fireSound = compound.method_10558("FiringSound");
        this.hitSound = compound.method_10558("HitSound");
        this.groundSound = compound.method_10558("GroundSound");
        this.canFireIndirect = compound.method_10550("FireIndirect");
        this.meleeDistance = compound.method_10550("DistanceToMelee");
    }

    public class_2487 save(class_2487 compound) {
        compound.method_10569("BurstCount", this.burstCount);
        compound.method_10569("pSpeed", this.pSpeed);
        compound.method_10569("pDamage", this.pDamage);
        compound.method_10569("pImpact", this.pImpact);
        compound.method_10569("pSize", this.pSize);
        compound.method_10569("pArea", this.pArea);
        compound.method_10569("pTrail", this.pTrail);
        compound.method_10569("MaxFiringRange", this.rangedRange);
        compound.method_10569("FireRate", this.fireRate);
        compound.method_10569("minDelay", this.minDelay);
        compound.method_10569("maxDelay", this.maxDelay);
        compound.method_10569("ShotCount", this.shotCount);
        compound.method_10569("Accuracy", this.accuracy);
        compound.method_10556("pRender3D", this.pRender3D);
        compound.method_10556("pSpin", this.pSpin);
        compound.method_10556("pStick", this.pStick);
        compound.method_10556("pPhysics", this.pPhysics);
        compound.method_10556("pXlr8", this.pXlr8);
        compound.method_10556("pGlows", this.pGlows);
        compound.method_10556("AimWhileShooting", this.aimWhileShooting);
        compound.method_10569("pEffect", this.pEffect);
        compound.method_10569("pDur", this.pDur);
        compound.method_10569("pEffAmp", this.pEffAmp);
        compound.method_10582("FiringSound", this.fireSound);
        compound.method_10582("HitSound", this.hitSound);
        compound.method_10582("GroundSound", this.groundSound);
        compound.method_10569("FireIndirect", this.canFireIndirect);
        compound.method_10569("DistanceToMelee", this.meleeDistance);
        return compound;
    }

    @Override
    public int getStrength() {
        return this.pDamage;
    }

    @Override
    public void setStrength(int strength) {
        this.pDamage = strength;
    }

    @Override
    public int getSpeed() {
        return this.pSpeed;
    }

    @Override
    public void setSpeed(int speed) {
        this.pSpeed = ValueUtil.CorrectInt(speed, 0, 100);
    }

    @Override
    public int getKnockback() {
        return this.pImpact;
    }

    @Override
    public void setKnockback(int punch) {
        this.pImpact = punch;
    }

    @Override
    public int getSize() {
        return this.pSize;
    }

    @Override
    public void setSize(int size) {
        this.pSize = size;
    }

    @Override
    public boolean getRender3D() {
        return this.pRender3D;
    }

    @Override
    public void setRender3D(boolean render3d) {
        this.pRender3D = render3d;
    }

    @Override
    public boolean getSpins() {
        return this.pSpin;
    }

    @Override
    public void setSpins(boolean spins) {
        this.pSpin = spins;
    }

    @Override
    public boolean getSticks() {
        return this.pStick;
    }

    @Override
    public void setSticks(boolean sticks) {
        this.pStick = sticks;
    }

    @Override
    public boolean getHasGravity() {
        return this.pPhysics;
    }

    @Override
    public void setHasGravity(boolean hasGravity) {
        this.pPhysics = hasGravity;
    }

    @Override
    public boolean getAccelerate() {
        return this.pXlr8;
    }

    @Override
    public void setAccelerate(boolean accelerate) {
        this.pXlr8 = accelerate;
    }

    @Override
    public int getExplodeSize() {
        return this.pArea;
    }

    @Override
    public void setExplodeSize(int size) {
        this.pArea = size;
    }

    @Override
    public int getEffectType() {
        return this.pEffect;
    }

    @Override
    public int getEffectTime() {
        return this.pDur;
    }

    @Override
    public int getEffectStrength() {
        return this.pEffAmp;
    }

    @Override
    public void setEffect(int type, int strength, int time) {
        this.pEffect = type;
        this.pDur = time;
        this.pEffAmp = strength;
    }

    @Override
    public boolean getGlows() {
        return this.pGlows;
    }

    @Override
    public void setGlows(boolean glows) {
        this.pGlows = glows;
    }

    @Override
    public int getParticle() {
        return this.pTrail;
    }

    @Override
    public void setParticle(int type) {
        this.pTrail = type;
    }

    @Override
    public int getAccuracy() {
        return this.accuracy;
    }

    @Override
    public void setAccuracy(int accuracy) {
        this.accuracy = ValueUtil.CorrectInt(accuracy, 1, 100);
    }

    @Override
    public int getRange() {
        return this.rangedRange;
    }

    @Override
    public void setRange(int range) {
        this.rangedRange = ValueUtil.CorrectInt(range, 1, 100);
    }

    @Override
    public int getDelayMin() {
        return this.minDelay;
    }

    @Override
    public int getDelayMax() {
        return this.maxDelay;
    }

    @Override
    public int getDelayRNG() {
        int delay = this.minDelay;
        if (this.maxDelay - this.minDelay > 0) {
            delay += this.npc.method_37908().field_9229.method_43048(this.maxDelay - this.minDelay);
        }
        return delay;
    }

    @Override
    public void setDelay(int min, int max) {
        this.minDelay = min = Math.min(min, max);
        this.maxDelay = max;
    }

    @Override
    public int getBurst() {
        return this.burstCount;
    }

    @Override
    public void setBurst(int count) {
        this.burstCount = count;
    }

    @Override
    public int getBurstDelay() {
        return this.fireRate;
    }

    @Override
    public void setBurstDelay(int delay) {
        this.fireRate = delay;
    }

    @Override
    public String getSound(int type) {
        String sound = null;
        if (type == 0) {
            sound = this.fireSound;
        }
        if (type == 1) {
            sound = this.hitSound;
        }
        if (type == 2) {
            sound = this.groundSound;
        }
        if (sound == null || sound.isEmpty()) {
            return null;
        }
        return NoppesStringUtils.cleanResource(sound);
    }

    public class_3414 getSoundEvent(int type) {
        String sound = this.getSound(type);
        if (sound == null) {
            return null;
        }
        class_2960 res = class_2960.method_12829((String)sound);
        class_3414 ev = (class_3414)class_7923.field_41172.method_10223(res);
        if (ev != null) {
            return ev;
        }
        return class_3414.method_47908((class_2960)res);
    }

    @Override
    public void setSound(int type, String sound) {
        if (sound == null) {
            sound = "";
        }
        if (type == 0) {
            this.fireSound = NoppesStringUtils.cleanResource(sound);
        }
        if (type == 1) {
            this.hitSound = NoppesStringUtils.cleanResource(sound);
        }
        if (type == 2) {
            this.groundSound = NoppesStringUtils.cleanResource(sound);
        }
        this.npc.updateClient = true;
    }

    @Override
    public int getShotCount() {
        return this.shotCount;
    }

    @Override
    public void setShotCount(int count) {
        this.shotCount = count;
    }

    @Override
    public boolean getHasAimAnimation() {
        return this.aimWhileShooting;
    }

    @Override
    public void setHasAimAnimation(boolean aim) {
        this.aimWhileShooting = aim;
    }

    @Override
    public int getFireType() {
        return this.canFireIndirect;
    }

    @Override
    public void setFireType(int type) {
        this.canFireIndirect = type;
    }

    @Override
    public int getMeleeRange() {
        return this.meleeDistance;
    }

    @Override
    public void setMeleeRange(int range) {
        this.meleeDistance = range;
        this.npc.updateAI = true;
    }
}

