/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_7225;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.shared.common.PacketBasic;

public class PacketSyncUpdate
extends PacketBasic {
    private final int id;
    private final int type;
    private final class_2487 data;

    public PacketSyncUpdate(int id, int type, class_2487 data) {
        this.id = id;
        this.type = type;
        this.data = data;
    }

    public static void encode(PacketSyncUpdate msg, class_2540 buf) {
        buf.method_53002(msg.id);
        buf.method_53002(msg.type);
        buf.method_10794((class_2520)msg.data);
    }

    public static PacketSyncUpdate decode(class_2540 buf) {
        return new PacketSyncUpdate(buf.readInt(), buf.readInt(), buf.method_10798());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void handle() {
        if (this.type == 1) {
            Faction faction = new Faction();
            faction.readNBT(this.data);
            FactionController.instance.factions.put(faction.id, faction);
        } else if (this.type == 4) {
            DialogCategory category = DialogController.instance.categories.get(this.id);
            Dialog dialog = new Dialog(category);
            dialog.readNBT((class_7225.class_7874)this.player.method_56673(), this.data);
            DialogController.instance.dialogs.put(dialog.id, dialog);
            category.dialogs.put(dialog.id, dialog);
        } else if (this.type == 5) {
            DialogCategory category = new DialogCategory();
            category.readNBT((class_7225.class_7874)this.player.method_56673(), this.data);
            DialogController.instance.categories.put(category.id, category);
        } else if (this.type == 2) {
            QuestCategory category = QuestController.instance.categories.get(this.id);
            Quest quest = new Quest(category);
            quest.readNBT((class_7225.class_7874)this.player.method_56673(), this.data);
            QuestController.instance.quests.put(quest.id, quest);
            category.quests.put(quest.id, quest);
        } else if (this.type == 3) {
            QuestCategory category = new QuestCategory();
            category.readNBT((class_7225.class_7874)this.player.method_56673(), this.data);
            QuestController.instance.categories.put(category.id, category);
        }
    }

    public void clientSync(boolean syncEnd) {
    }
}

