/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import java.util.ArrayList;
import java.util.Vector;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerTransportData;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.PacketServerBasic;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiOpen;
import noppes.npcs.packets.client.PacketGuiScrollList;
import noppes.npcs.packets.client.PacketNpcRole;
import noppes.npcs.roles.RoleTransporter;
import noppes.npcs.util.CustomNPCsScheduler;

public class SPacketGuiOpen
extends PacketServerBasic {
    private EnumGuiType type;
    private class_2338 pos;

    public SPacketGuiOpen(EnumGuiType type, class_2338 pos) {
        this.type = type;
        this.pos = pos;
    }

    public static void encode(SPacketGuiOpen msg, class_2540 buf) {
        buf.method_10817((Enum)msg.type);
        buf.method_10807(msg.pos);
    }

    public static SPacketGuiOpen decode(class_2540 buf) {
        return new SPacketGuiOpen((EnumGuiType)buf.method_10818(EnumGuiType.class), buf.method_10811());
    }

    @Override
    protected void handle() {
        SPacketGuiOpen.sendOpenGui((class_1657)this.player, this.type, this.npc, this.pos);
    }

    public static void sendOpenGui(class_1657 player, EnumGuiType gui, EntityNPCInterface npc, class_2338 pos) {
        if (!(player instanceof class_3222)) {
            return;
        }
        NoppesUtilServer.setEditingNpc(player, npc);
        if (gui == EnumGuiType.PlayerFollower || gui == EnumGuiType.PlayerFollowerHire || gui == EnumGuiType.PlayerTrader || gui == EnumGuiType.PlayerTransporter) {
            if (npc.role.getType() == 0) {
                return;
            }
            class_2487 comp = new class_2487();
            npc.role.save(comp);
            comp.method_10569("Role", npc.role.getType());
            Packets.send((class_3222)player, new PacketNpcRole(npc.method_5628(), comp));
        }
        CustomNPCsScheduler.runTack(() -> player.method_5682().method_20493(() -> {
            if (!gui.hasContainer) {
                Packets.send((class_3222)player, new PacketGuiOpen(gui, pos));
            } else {
                NoppesUtilServer.openContainerGui((class_3222)player, gui, buffer -> buffer.method_53002(npc.method_5628()));
            }
            ArrayList<String> list = SPacketGuiOpen.getScrollData(player, gui, npc);
            if (list == null || list.isEmpty()) {
                return;
            }
            Packets.send((class_3222)player, new PacketGuiScrollList(new Vector<String>(list)));
        }), 200);
    }

    private static ArrayList<String> getScrollData(class_1657 player, EnumGuiType gui, EntityNPCInterface npc) {
        if (gui == EnumGuiType.PlayerTransporter) {
            RoleTransporter role = (RoleTransporter)npc.role;
            ArrayList<String> list = new ArrayList<String>();
            TransportLocation location = role.getLocation();
            String name = role.getLocation().name;
            for (TransportLocation loc : location.category.getDefaultLocations()) {
                if (list.contains(loc.name)) continue;
                list.add(loc.name);
            }
            PlayerTransportData playerdata = PlayerData.get((class_1657)player).transportData;
            for (int i : playerdata.transports) {
                TransportLocation loc = TransportController.getInstance().getTransport(i);
                if (loc == null || !location.category.locations.containsKey(loc.id) || list.contains(loc.name)) continue;
                list.add(loc.name);
            }
            list.remove(name);
            return list;
        }
        return null;
    }
}

