/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_7225;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.quests.QuestInterface;
import noppes.npcs.util.ValueUtil;

public class QuestItem
extends QuestInterface {
    public NpcMiscInventory items = new NpcMiscInventory(3);
    public boolean leaveItems = false;
    public boolean ignoreDamage = false;
    public boolean ignoreNBT = false;

    @Override
    public void readAdditionalSaveData(class_7225.class_7874 lookupProvider, class_2487 compound) {
        this.items.setFromNBT(lookupProvider, compound.method_10562("Items"));
        this.leaveItems = compound.method_10577("LeaveItems");
        this.ignoreDamage = compound.method_10577("IgnoreDamage");
        this.ignoreNBT = compound.method_10577("IgnoreNBT");
    }

    @Override
    public void addAdditionalSaveData(class_7225.class_7874 lookupProvider, class_2487 compound) {
        compound.method_10566("Items", (class_2520)this.items.getToNBT(lookupProvider));
        compound.method_10556("LeaveItems", this.leaveItems);
        compound.method_10556("IgnoreDamage", this.ignoreDamage);
        compound.method_10556("IgnoreNBT", this.ignoreNBT);
    }

    @Override
    public boolean isCompleted(class_1657 player) {
        List<class_1799> questItems = NoppesUtilPlayer.countStacks((class_1263)this.items, this.ignoreDamage, this.ignoreNBT);
        for (class_1799 reqItem : questItems) {
            if (NoppesUtilPlayer.compareItems(player, reqItem, this.ignoreDamage, this.ignoreNBT)) continue;
            return false;
        }
        return true;
    }

    public Map<class_1799, Integer> getProgressSet(class_1657 player) {
        HashMap<class_1799, Integer> map = new HashMap<class_1799, Integer>();
        List<class_1799> questItems = NoppesUtilPlayer.countStacks((class_1263)this.items, this.ignoreDamage, this.ignoreNBT);
        for (class_1799 item : questItems) {
            if (NoppesUtilServer.IsItemStackNull(item)) continue;
            map.put(item, 0);
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 item;
            item = player.method_31548().method_5438(i);
            if (NoppesUtilServer.IsItemStackNull(item)) continue;
            for (Map.Entry<class_1799, Integer> questItem : map.entrySet()) {
                if (!NoppesUtilPlayer.compareItems(questItem.getKey(), item, this.ignoreDamage, this.ignoreNBT)) continue;
                map.put(questItem.getKey(), questItem.getValue() + item.method_7947());
            }
        }
        return map;
    }

    @Override
    public void handleComplete(class_1657 player) {
        if (this.leaveItems) {
            return;
        }
        block0: for (class_1799 questitem : this.items.items) {
            if (questitem.method_7960()) continue;
            int stacksize = questitem.method_7947();
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                class_1799 item = player.method_31548().method_5438(i);
                if (NoppesUtilServer.IsItemStackNull(item) || !NoppesUtilPlayer.compareItems(item, questitem, this.ignoreDamage, this.ignoreNBT)) continue;
                int size = item.method_7947();
                if (stacksize - size >= 0) {
                    player.method_31548().method_5447(i, class_1799.field_8037);
                    item.method_7971(size);
                } else {
                    item.method_7971(stacksize);
                }
                if ((stacksize -= size) <= 0) continue block0;
            }
        }
    }

    @Override
    public IQuestObjective[] getObjectives(class_1657 player) {
        ArrayList<QuestItemObjective> list = new ArrayList<QuestItemObjective>();
        List<class_1799> questItems = NoppesUtilPlayer.countStacks((class_1263)this.items, this.ignoreDamage, this.ignoreNBT);
        for (class_1799 stack : questItems) {
            if (stack.method_7960()) continue;
            list.add(new QuestItemObjective(player, stack));
        }
        return list.toArray(new IQuestObjective[list.size()]);
    }

    class QuestItemObjective
    implements IQuestObjective {
        private final class_1657 player;
        private final class_1799 questItem;

        public QuestItemObjective(class_1657 player, class_1799 item) {
            this.player = player;
            this.questItem = item;
        }

        @Override
        public int getProgress() {
            int count = 0;
            for (int i = 0; i < this.player.method_31548().method_5439(); ++i) {
                class_1799 item = this.player.method_31548().method_5438(i);
                if (NoppesUtilServer.IsItemStackNull(item) || !NoppesUtilPlayer.compareItems(this.questItem, item, QuestItem.this.ignoreDamage, QuestItem.this.ignoreNBT)) continue;
                count += item.method_7947();
            }
            return ValueUtil.CorrectInt(count, 0, this.questItem.method_7947());
        }

        @Override
        public void setProgress(int progress) {
            throw new CustomNPCsException("Cant set the progress of ItemQuests", new Object[0]);
        }

        @Override
        public int getMaxProgress() {
            return this.questItem.method_7947();
        }

        @Override
        public boolean isCompleted() {
            return NoppesUtilPlayer.compareItems(this.player, this.questItem, QuestItem.this.ignoreDamage, QuestItem.this.ignoreNBT);
        }

        @Override
        public String getText() {
            return this.getMCText().getString();
        }

        @Override
        public class_2561 getMCText() {
            return class_2561.method_43470((String)"").method_10852(this.questItem.method_7964()).method_27693(": " + this.getProgress() + "/" + this.getMaxProgress());
        }
    }
}

