/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import noppes.npcs.controllers.ChunkController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobChunkLoader
extends JobInterface {
    private List<class_1923> chunks = new ArrayList<class_1923>();
    private int ticks = 20;
    private long playerLastSeen = -1L;

    public JobChunkLoader(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public class_2487 save(class_2487 compound) {
        compound.method_10544("ChunkPlayerLastSeen", this.playerLastSeen);
        return compound;
    }

    @Override
    public void load(class_2487 compound) {
        this.playerLastSeen = compound.method_10537("ChunkPlayerLastSeen");
    }

    @Override
    public boolean aiShouldExecute() {
        --this.ticks;
        if (this.ticks > 0) {
            return false;
        }
        this.ticks = 20;
        List players = this.npc.method_37908().method_18467(class_1657.class, this.npc.method_5829().method_1009(48.0, 48.0, 48.0));
        if (!players.isEmpty()) {
            this.playerLastSeen = System.currentTimeMillis();
        }
        if (this.playerLastSeen < 0L) {
            return false;
        }
        if (System.currentTimeMillis() > this.playerLastSeen + 600000L) {
            ChunkController.instance.unload((class_3218)this.npc.method_37908(), this.npc.method_5667(), this.npc.method_31476().field_9181, this.npc.method_31476().field_9180);
            this.chunks.clear();
            this.playerLastSeen = -1L;
            return false;
        }
        double x = this.npc.method_23317() / 16.0;
        double z = this.npc.method_23321() / 16.0;
        ArrayList<class_1923> list = new ArrayList<class_1923>();
        list.add(new class_1923(class_3532.method_15357((double)x), class_3532.method_15357((double)z)));
        list.add(new class_1923(class_3532.method_15384((double)x), class_3532.method_15384((double)z)));
        list.add(new class_1923(class_3532.method_15357((double)x), class_3532.method_15384((double)z)));
        list.add(new class_1923(class_3532.method_15384((double)x), class_3532.method_15357((double)z)));
        for (class_1923 chunk : list) {
            if (!this.chunks.contains(chunk)) {
                ChunkController.instance.load((class_3218)this.npc.method_37908(), this.npc.method_5667(), chunk.field_9181, chunk.field_9180);
            }
            this.chunks.remove(chunk);
        }
        for (class_1923 chunk : this.chunks) {
            ChunkController.instance.unload((class_3218)this.npc.method_37908(), this.npc.method_5667(), chunk.field_9181, chunk.field_9180);
        }
        this.chunks = list;
        return false;
    }

    @Override
    public boolean aiContinueExecute() {
        return false;
    }

    @Override
    public void reset() {
        if (this.npc.method_37908() instanceof class_3218) {
            ChunkController.instance.unload((class_3218)this.npc.method_37908(), this.npc.method_5667(), this.npc.method_31476().field_9181, this.npc.method_31476().field_9180);
            this.chunks.clear();
            this.playerLastSeen = 0L;
        }
    }

    @Override
    public void delete() {
    }

    @Override
    public int getType() {
        return 8;
    }
}

