/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.io.File;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.data.role.IRoleTrader;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleInterface;
import noppes.npcs.util.NBTJsonUtil;

public class RoleTrader
extends RoleInterface
implements IRoleTrader {
    public String marketName = "";
    public NpcMiscInventory inventoryCurrency = new NpcMiscInventory(36);
    public NpcMiscInventory inventorySold = new NpcMiscInventory(18);
    public boolean ignoreDamage = false;
    public boolean ignoreNBT = false;
    public boolean toSave = false;

    public RoleTrader(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public class_2487 save(class_2487 nbttagcompound) {
        nbttagcompound.method_10582("TraderMarket", this.marketName);
        this.writeNBT(nbttagcompound);
        if (this.toSave && !this.npc.isClientSide()) {
            RoleTrader.save(this, this.marketName);
        }
        this.toSave = false;
        return nbttagcompound;
    }

    public class_2487 writeNBT(class_2487 nbttagcompound) {
        nbttagcompound.method_10566("TraderCurrency", (class_2520)this.inventoryCurrency.getToNBT((class_7225.class_7874)this.npc.method_56673()));
        nbttagcompound.method_10566("TraderSold", (class_2520)this.inventorySold.getToNBT((class_7225.class_7874)this.npc.method_56673()));
        nbttagcompound.method_10556("TraderIgnoreDamage", this.ignoreDamage);
        nbttagcompound.method_10556("TraderIgnoreNBT", this.ignoreNBT);
        return nbttagcompound;
    }

    @Override
    public void load(class_2487 nbttagcompound) {
        this.marketName = nbttagcompound.method_10558("TraderMarket");
        this.readNBT(nbttagcompound);
    }

    public void readNBT(class_2487 nbttagcompound) {
        this.inventoryCurrency.setFromNBT((class_7225.class_7874)this.npc.method_56673(), nbttagcompound.method_10562("TraderCurrency"));
        this.inventorySold.setFromNBT((class_7225.class_7874)this.npc.method_56673(), nbttagcompound.method_10562("TraderSold"));
        this.ignoreDamage = nbttagcompound.method_10577("TraderIgnoreDamage");
        this.ignoreNBT = nbttagcompound.method_10577("TraderIgnoreNBT");
    }

    @Override
    public void interact(class_1657 player) {
        this.npc.say(player, this.npc.advanced.getInteractLine());
        try {
            RoleTrader.load(this, this.marketName);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerTrader, this.npc);
    }

    public boolean hasCurrency(class_1799 itemstack) {
        if (itemstack == null) {
            return false;
        }
        for (class_1799 item : this.inventoryCurrency.items) {
            if (item.method_7960() || !NoppesUtilPlayer.compareItems(item, itemstack, this.ignoreDamage, this.ignoreNBT)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IItemStack getSold(int slot) {
        return NpcAPI.Instance().getIItemStack(this.inventorySold.method_5438(slot));
    }

    @Override
    public IItemStack getCurrency1(int slot) {
        return NpcAPI.Instance().getIItemStack(this.inventoryCurrency.method_5438(slot));
    }

    @Override
    public IItemStack getCurrency2(int slot) {
        return NpcAPI.Instance().getIItemStack(this.inventoryCurrency.method_5438(slot + 18));
    }

    @Override
    public void set(int slot, IItemStack currency, IItemStack currency2, IItemStack sold) {
        if (sold == null) {
            throw new CustomNPCsException("Sold item was null", new Object[0]);
        }
        if (slot >= 18 || slot < 0) {
            throw new CustomNPCsException("Invalid slot: " + slot, new Object[0]);
        }
        if (currency == null) {
            currency = currency2;
            currency2 = null;
        }
        if (currency != null) {
            this.inventoryCurrency.items.set(slot, (Object)currency.getMCItemStack());
        } else {
            this.inventoryCurrency.items.set(slot, (Object)class_1799.field_8037);
        }
        if (currency2 != null) {
            this.inventoryCurrency.items.set(slot + 18, (Object)currency2.getMCItemStack());
        } else {
            this.inventoryCurrency.items.set(slot + 18, (Object)class_1799.field_8037);
        }
        this.inventorySold.items.set(slot, (Object)sold.getMCItemStack());
    }

    @Override
    public void remove(int slot) {
        if (slot >= 18 || slot < 0) {
            throw new CustomNPCsException("Invalid slot: " + slot, new Object[0]);
        }
        this.inventoryCurrency.items.set(slot, (Object)class_1799.field_8037);
        this.inventoryCurrency.items.set(slot + 18, (Object)class_1799.field_8037);
        this.inventorySold.items.set(slot, (Object)class_1799.field_8037);
    }

    @Override
    public void setMarket(String name) {
        this.marketName = name;
        RoleTrader.load(this, name);
    }

    @Override
    public String getMarket() {
        return this.marketName;
    }

    public static void save(RoleTrader r, String name) {
        if (name.isEmpty()) {
            return;
        }
        File file = RoleTrader.getFile(name + "_new");
        File file1 = RoleTrader.getFile(name);
        try {
            NBTJsonUtil.SaveFile(file, r.writeNBT(new class_2487()));
            if (file1.exists()) {
                file1.delete();
            }
            file.renameTo(file1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void load(RoleTrader role, String name) {
        if (role.npc.method_37908().field_9236) {
            return;
        }
        File file = RoleTrader.getFile(name);
        if (!file.exists()) {
            return;
        }
        try {
            role.readNBT(NBTJsonUtil.LoadFile(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static File getFile(String name) {
        File dir = new File(CustomNpcs.getLevelSaveDirectory(), "markets");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return new File(dir, name.toLowerCase(Locale.ROOT) + ".json");
    }

    public static void setMarket(EntityNPCInterface npc, String marketName) {
        if (marketName.isEmpty()) {
            return;
        }
        if (!RoleTrader.getFile(marketName).exists()) {
            RoleTrader.save((RoleTrader)npc.role, marketName);
        }
        RoleTrader.load((RoleTrader)npc.role, marketName);
    }

    @Override
    public int getType() {
        return 1;
    }
}

