/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.entity.data.role.IRoleTransporter;
import noppes.npcs.api.event.RoleEvent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerTransportData;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketChatBubble;
import noppes.npcs.packets.server.SPacketDimensionTeleport;
import noppes.npcs.roles.RoleInterface;

public class RoleTransporter
extends RoleInterface
implements IRoleTransporter {
    public int transportId = -1;
    public String name;
    private int ticks = 10;

    public RoleTransporter(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public class_2487 save(class_2487 nbttagcompound) {
        nbttagcompound.method_10569("TransporterId", this.transportId);
        return nbttagcompound;
    }

    @Override
    public void load(class_2487 nbttagcompound) {
        this.transportId = nbttagcompound.method_10550("TransporterId");
        TransportLocation loc = this.getLocation();
        if (loc != null) {
            this.name = loc.name;
        }
    }

    @Override
    public boolean aiShouldExecute() {
        --this.ticks;
        if (this.ticks > 0) {
            return false;
        }
        this.ticks = 10;
        if (!this.hasTransport()) {
            return false;
        }
        TransportLocation loc = this.getLocation();
        if (loc.type != 0) {
            return false;
        }
        List inRange = this.npc.method_37908().method_18467(class_1657.class, this.npc.method_5829().method_1009(6.0, 6.0, 6.0));
        for (class_1657 player : inRange) {
            if (!this.npc.canNpcSee((class_1297)player)) continue;
            this.unlock(player, loc);
        }
        return false;
    }

    @Override
    public void interact(class_1657 player) {
        if (this.hasTransport()) {
            TransportLocation loc = this.getLocation();
            if (loc.type == 2) {
                this.unlock(player, loc);
            }
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerTransporter, this.npc);
        }
    }

    public void transport(class_3222 player, String location) {
        TransportLocation loc = TransportController.getInstance().getTransport(location);
        PlayerTransportData playerdata = PlayerData.get((class_1657)player).transportData;
        if (loc == null || !loc.isDefault() && !playerdata.transports.contains(loc.id)) {
            return;
        }
        RoleEvent.TransporterUseEvent event = new RoleEvent.TransporterUseEvent((class_1657)player, this.npc.wrappedNPC, loc);
        if (EventHooks.onNPCRole(this.npc, event)) {
            return;
        }
        SPacketDimensionTeleport.teleportPlayer(player, loc.pos.method_10263(), loc.pos.method_10264(), loc.pos.method_10260(), loc.dimension);
    }

    private void unlock(class_1657 player, TransportLocation loc) {
        PlayerTransportData data = PlayerData.get((class_1657)player).transportData;
        if (data.transports.contains(this.transportId)) {
            return;
        }
        RoleEvent.TransporterUnlockedEvent event = new RoleEvent.TransporterUnlockedEvent(player, this.npc.wrappedNPC);
        if (EventHooks.onNPCRole(this.npc, event)) {
            return;
        }
        data.transports.add(this.transportId);
        this.npc.say(player, new Line("mailbox.gotmail"));
        Packets.send((class_3222)player, new PacketChatBubble(this.npc.method_5628(), (class_2561)class_2561.method_43469((String)"transporter.unlock", (Object[])new Object[]{loc.name}), true));
    }

    @Override
    public TransportLocation getLocation() {
        if (this.npc.isClientSide()) {
            return null;
        }
        return TransportController.getInstance().getTransport(this.transportId);
    }

    public boolean hasTransport() {
        TransportLocation loc = this.getLocation();
        return loc != null && loc.id == this.transportId;
    }

    public void setTransport(TransportLocation location) {
        this.transportId = location.id;
        this.name = location.name;
    }

    @Override
    public int getType() {
        return 4;
    }
}

