/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.schematics;

import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_7225;
import noppes.npcs.schematics.BlueprintUtil;
import noppes.npcs.schematics.ISchematic;

public class Blueprint
implements ISchematic {
    private List<String> requiredMods;
    private short sizeX;
    private short sizeY;
    private short sizeZ;
    private short palleteSize;
    private class_2680[] pallete;
    private String name;
    private String[] architects;
    private short[][][] structure;
    private class_2487[] tileEntities;

    public Blueprint(short sizeX, short sizeY, short sizeZ, short palleteSize, class_2680[] pallete, short[][][] structure, class_2487[] tileEntities, List<String> requiredMods) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.palleteSize = palleteSize;
        this.pallete = pallete;
        this.structure = structure;
        this.tileEntities = tileEntities;
        this.requiredMods = requiredMods;
    }

    public void build(class_1937 level, class_2338 pos) {
        class_2680 state;
        short x;
        short z;
        short y;
        class_2680[] pallete = this.getPallete();
        short[][][] structure = this.getStructure();
        for (y = 0; y < this.getSizeY(); y = (short)(y + 1)) {
            for (z = 0; z < this.getSizeZ(); z = (short)(z + 1)) {
                for (x = 0; x < this.getSizeX(); x = (short)(x + 1)) {
                    state = pallete[structure[y][z][x] & 0xFFFF];
                    if (state.method_26204() == class_2246.field_10369 || !state.method_26234((class_1922)class_2682.field_12294, class_2338.field_10980)) continue;
                    level.method_8652(pos.method_10069((int)x, (int)y, (int)z), state, 2);
                }
            }
        }
        for (y = 0; y < this.getSizeY(); y = (short)(y + 1)) {
            for (z = 0; z < this.getSizeZ(); z = (short)(z + 1)) {
                for (x = 0; x < this.getSizeX(); x = (short)(x + 1)) {
                    state = pallete[structure[y][z][x]];
                    if (state.method_26204() == class_2246.field_10369 || state.method_26234((class_1922)class_2682.field_12294, class_2338.field_10980)) continue;
                    level.method_8652(pos.method_10069((int)x, (int)y, (int)z), state, 2);
                }
            }
        }
        if (this.getTileEntities() != null) {
            for (class_2487 tag : this.getTileEntities()) {
                class_2586 te = level.method_8321(pos.method_10069((int)tag.method_10568("x"), (int)tag.method_10568("y"), (int)tag.method_10568("z")));
                tag.method_10569("x", pos.method_10263() + tag.method_10568("x"));
                tag.method_10569("y", pos.method_10264() + tag.method_10568("y"));
                tag.method_10569("z", pos.method_10260() + tag.method_10568("z"));
                te.method_58690(tag, (class_7225.class_7874)level.method_30349());
            }
        }
    }

    public short getSizeX() {
        return this.sizeX;
    }

    public short getSizeY() {
        return this.sizeY;
    }

    public short getSizeZ() {
        return this.sizeZ;
    }

    public short getPalleteSize() {
        return this.palleteSize;
    }

    public class_2680[] getPallete() {
        return this.pallete;
    }

    public short[][][] getStructure() {
        return this.structure;
    }

    public class_2487[] getTileEntities() {
        return this.tileEntities;
    }

    public List<String> getRequiredMods() {
        return this.requiredMods;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getArchitects() {
        return this.architects;
    }

    public void setArchitects(String[] architects) {
        this.architects = architects;
    }

    @Override
    public short getWidth() {
        return this.getSizeX();
    }

    @Override
    public short getHeight() {
        return this.getSizeZ();
    }

    @Override
    public short getLength() {
        return this.getSizeY();
    }

    @Override
    public int getBlockEntityDimensions() {
        return this.tileEntities.length;
    }

    @Override
    public class_2487 getBlockEntity(int i) {
        return this.tileEntities[i];
    }

    @Override
    public class_2680 getBlockState(int x, int y, int z) {
        return this.pallete[this.structure[y][z][x]];
    }

    @Override
    public class_2680 getBlockState(int i) {
        int x = i % this.getWidth();
        int z = (i - x) / this.getWidth() % this.getLength();
        int y = ((i - x) / this.getWidth() - z) / this.getLength();
        return this.getBlockState(x, y, z);
    }

    @Override
    public class_2487 getNBT() {
        return BlueprintUtil.writeBlueprintToNBT(this);
    }
}

