/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.shared.client.model.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import noppes.npcs.shared.common.util.NopVector2i;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryUtil;

public class BatchRenderer {
    private static final FloatBuffer MATRIX_BUFFER = MemoryUtil.memAllocFloat((int)16);
    public static class_1921 lastType = null;
    private static final BatchRenderer instance = new BatchRenderer();
    private final Map<class_1921, List<Batch>> queue = new LinkedHashMap<class_1921, List<Batch>>();

    public static BatchRenderer getInstance() {
        return instance;
    }

    public void add(class_1921 renderType, class_2960 resource, int id, class_293 format, Matrix4f matrix, int vertexCount, NopVector2i texPos, int light, int overlay, float red, float green, float blue, float alpha) {
        if (renderType == null) {
            renderType = lastType;
        }
        this.queue.computeIfAbsent(renderType, k -> new LinkedList()).add(new Batch(this, resource, id, format, matrix, vertexCount, texPos, light, overlay, red, green, blue, alpha));
    }

    public void draw() {
        this.queue.forEach((renderType, batches) -> {
            if (batches.isEmpty()) {
                return;
            }
            RenderSystem.assertOnRenderThread();
            renderType.method_23516();
            class_5944 shaderinstance = RenderSystem.getShader();
            for (Batch b : batches) {
                RenderSystem.setShaderTexture((int)0, (class_2960)b.resource);
                shaderinstance.field_29474.method_1253(new float[]{b.red, b.green, b.blue, b.alpha});
                if (shaderinstance.field_29475 != null) {
                    shaderinstance.field_29475.method_35649(b.light1);
                }
                if (shaderinstance.field_29476 != null) {
                    shaderinstance.field_29476.method_35649(b.light2);
                }
                shaderinstance.field_29470.method_1250(b.matrix);
                if (shaderinstance.field_29477 != null) {
                    shaderinstance.field_29477.method_1251(RenderSystem.getShaderFogStart());
                }
                if (shaderinstance.field_29478 != null) {
                    shaderinstance.field_29478.method_1251(RenderSystem.getShaderFogEnd());
                }
                if (shaderinstance.field_29479 != null) {
                    shaderinstance.field_29479.method_1253(RenderSystem.getShaderFogColor());
                }
                if (shaderinstance.field_36373 != null) {
                    shaderinstance.field_36373.method_35649(RenderSystem.getShaderFogShape().method_40036());
                }
                if (shaderinstance.field_29472 != null) {
                    shaderinstance.field_29472.method_1250(BatchRenderer.createTranslateMatrix(b.texPos.x, b.texPos.y, 0.0f));
                }
                if (shaderinstance.field_29481 != null) {
                    shaderinstance.field_29481.method_1251(RenderSystem.getShaderGameTime());
                }
                if (shaderinstance.field_29473 != null) {
                    class_1041 window = class_310.method_1551().method_22683();
                    shaderinstance.field_29473.method_1255((float)window.method_4489(), (float)window.method_4506());
                }
                RenderSystem.glBindBuffer((int)34962, (int)b.id);
                b.format.method_22649();
                shaderinstance.method_34586();
                RenderSystem.drawElements((int)4, (int)0, (int)b.vertexCount);
                shaderinstance.method_34585();
                b.format.method_22651();
                RenderSystem.glBindBuffer((int)34962, (int)0);
            }
            renderType.method_23518();
        });
        this.queue.clear();
    }

    public static Matrix4f createTranslateMatrix(float p_27654_, float p_27655_, float p_27656_) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.m00(1.0f);
        matrix4f.m11(1.0f);
        matrix4f.m22(1.0f);
        matrix4f.m33(1.0f);
        matrix4f.m03(p_27654_);
        matrix4f.m13(p_27655_);
        matrix4f.m23(p_27656_);
        return matrix4f;
    }

    class Batch {
        final Matrix4f matrix;
        final int vertexCount;
        final class_2960 resource;
        final int id;
        final class_293 format;
        final int light1;
        final int light2;
        final int overlay1;
        final int overlay2;
        final float red;
        final float green;
        final float blue;
        final float alpha;
        final NopVector2i texPos;

        public Batch(BatchRenderer this$0, class_2960 resource, int id, class_293 format, Matrix4f matrix, int vertexCount, NopVector2i texPos, int light, int overlay, float red, float green, float blue, float alpha) {
            this.resource = resource;
            this.id = id;
            this.format = format;
            this.matrix = matrix;
            this.vertexCount = vertexCount;
            this.texPos = texPos;
            this.light1 = light & 0xFFFF;
            this.light2 = light >> 16 & 0xFFFF;
            this.overlay1 = overlay & 0xFFFF;
            this.overlay2 = overlay >> 16 & 0xFFFF;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }
    }
}

