/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.shared.client.util;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import noppes.npcs.shared.SharedReferences;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class ImageDownloadAlt
extends class_1049 {
    private static final Logger logger = LogManager.getLogger();
    public final File cacheFile;
    private final String imageUrl;
    private boolean fix64;
    private Runnable r;
    public final class_2960 location;
    public boolean uploaded = false;

    public ImageDownloadAlt(File file, String url, class_2960 location, class_2960 defaultLocation, boolean fix64, Runnable r) {
        super(defaultLocation);
        this.location = location;
        this.cacheFile = file;
        this.imageUrl = url;
        this.fix64 = fix64;
        this.r = r;
    }

    public void setImage(class_1011 image) {
        class_310.method_1551().execute(() -> {
            this.uploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(image));
            } else {
                this.upload(image);
            }
            this.r.run();
        });
    }

    private void upload(class_1011 imageIn) {
        TextureUtil.prepareImage((int)this.method_4624(), (int)imageIn.method_4307(), (int)imageIn.method_4323());
        imageIn.method_4301(0, 0, 0, true);
    }

    public void method_4625(class_3300 resourceManager) throws IOException {
        if (this.cacheFile != null && this.cacheFile.isFile()) {
            logger.debug("Loading http texture from local cache ({})", new Object[]{this.cacheFile});
            class_1011 image = null;
            try {
                image = class_1011.method_4309((InputStream)new FileInputStream(this.cacheFile));
                this.setImage(this.parseUserSkin(image));
                return;
            }
            catch (IOException ioexception) {
                super.method_4625(resourceManager);
                logger.error("Couldn't load skin " + String.valueOf(this.cacheFile), (Throwable)ioexception);
            }
        }
        if (!this.uploaded) {
            try {
                this.uploaded = true;
                super.method_4625(resourceManager);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTextureFromServer() {
        HttpURLConnection connection = null;
        logger.debug("Downloading http texture from {} to {}", new Object[]{this.imageUrl, this.cacheFile});
        try {
            connection = (HttpURLConnection)new URL(this.imageUrl).openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 5.1; rv:19.0) Gecko/20100101 Firefox/19.0");
            connection.connect();
            String type = connection.getContentType();
            long size = connection.getContentLengthLong();
            if (connection.getResponseCode() / 100 != 2 || !type.equals("image/png") || size > 2000000L && !class_310.method_1551().method_1496()) {
                return;
            }
            FileUtils.copyInputStreamToFile((InputStream)connection.getInputStream(), (File)this.cacheFile);
        }
        catch (Exception exception) {
            logger.error("Couldn't download http texture", (Throwable)exception);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public class_1011 parseUserSkin(class_1011 image) {
        boolean lvt_2_1_;
        if (image.method_4323() != image.method_4307() && image.method_4307() / 2 != image.method_4323()) {
            throw new IllegalArgumentException("Invalid texture size: " + image.method_4307() + "x" + image.method_4323());
        }
        int scale = image.method_4307() / 64;
        boolean bl = lvt_2_1_ = image.method_4323() != image.method_4307();
        if (lvt_2_1_ && this.fix64) {
            class_1011 nativeImage = new class_1011(64 * scale, 64 * scale, true);
            nativeImage.method_4317(image);
            image.close();
            image = nativeImage;
            nativeImage.method_4326(0, 32 * scale, 64 * scale, 32 * scale, 0);
            nativeImage.method_4304(4 * scale, 16 * scale, 16 * scale, 32 * scale, 4 * scale, 4 * scale, true, false);
            nativeImage.method_4304(8 * scale, 16 * scale, 16 * scale, 32 * scale, 4 * scale, 4 * scale, true, false);
            nativeImage.method_4304(0, 20 * scale, 24 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.method_4304(4 * scale, 20 * scale, 16 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.method_4304(8 * scale, 20 * scale, 8 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.method_4304(12 * scale, 20 * scale, 16 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.method_4304(44 * scale, 16 * scale, -8 * scale, 32 * scale, 4 * scale, 4 * scale, true, false);
            nativeImage.method_4304(48 * scale, 16 * scale, -8 * scale, 32 * scale, 4 * scale, 4 * scale, true, false);
            nativeImage.method_4304(40 * scale, 20 * scale, 0, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.method_4304(44 * scale, 20 * scale, -8 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.method_4304(48 * scale, 20 * scale, -16 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.method_4304(52 * scale, 20 * scale, -8 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
        }
        if (!SharedReferences.AllowFullyInvisibleSkins()) {
            ImageDownloadAlt.setAreaOpaque(image, 0, 0, 32 * scale, 16 * scale);
        }
        if (lvt_2_1_ && this.fix64) {
            ImageDownloadAlt.setAreaTransparent(image, 32 * scale, 0, 64 * scale, 32 * scale);
        }
        return image;
    }

    private static void setAreaTransparent(class_1011 image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                int k = image.method_4315(i, j);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l = x; l < width; ++l) {
            for (int i1 = y; i1 < height; ++i1) {
                image.method_4305(l, i1, image.method_4315(l, i1) & 0xFFFFFF);
            }
        }
    }

    private static void setAreaOpaque(class_1011 image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                image.method_4305(i, j, image.method_4315(i, j) | 0xFF000000);
            }
        }
    }
}

