/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.nextgen_furniture.block;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nhatjs.nextgen_furniture.block.ModBlocks;
import org.jetbrains.annotations.Nullable;

public class Table2x1CenterBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape HORIZONTAL = Shapes.or((VoxelShape)Block.box((double)-8.0, (double)15.25, (double)0.0, (double)24.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)-7.5, (double)0.0, (double)0.5, (double)-6.5, (double)15.25, (double)1.5), Block.box((double)-7.5, (double)0.0, (double)14.5, (double)-6.5, (double)15.25, (double)15.5), Block.box((double)22.5, (double)0.0, (double)0.5, (double)23.5, (double)15.25, (double)1.5), Block.box((double)22.5, (double)0.0, (double)14.5, (double)23.5, (double)15.25, (double)15.5)});
    private static final VoxelShape VERTICAL = Shapes.or((VoxelShape)Block.box((double)0.0, (double)15.25, (double)-8.0, (double)16.0, (double)16.0, (double)24.0), (VoxelShape[])new VoxelShape[]{Block.box((double)14.5, (double)0.0, (double)-7.5, (double)15.5, (double)15.25, (double)-6.5), Block.box((double)0.5, (double)0.0, (double)-7.5, (double)1.5, (double)15.25, (double)-6.5), Block.box((double)14.5, (double)0.0, (double)22.5, (double)15.5, (double)15.25, (double)23.5), Block.box((double)0.5, (double)0.0, (double)22.5, (double)1.5, (double)15.25, (double)23.5)});

    public Table2x1CenterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> HORIZONTAL;
            case Direction.SOUTH -> HORIZONTAL;
            case Direction.EAST -> VERTICAL;
            case Direction.WEST -> VERTICAL;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        super.useWithoutItem(state, level, pos, player, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getBlockPos().getX();
        double hitY = hit.getBlockPos().getY();
        double hitZ = hit.getBlockPos().getZ();
        Direction direction = hit.getDirection();
        if (player.isShiftKeyDown()) {
            if (level.getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).getBlock() == ModBlocks.TABLE_2X1_BLACK.get()) {
                BlockPos _bp = BlockPos.containing((double)x, (double)y, (double)z);
                BlockState _bs = ((Block)ModBlocks.TABLE_2X1_BLACK_ALT.get()).defaultBlockState();
                BlockState _bso = level.getBlockState(_bp);
                for (Map.Entry entry : _bso.getValues().entrySet()) {
                    Property _property = _bs.getBlock().getStateDefinition().getProperty(((Property)entry.getKey()).getName());
                    if (_property == null || _bs.getValue(_property) == null) continue;
                    try {
                        _bs = (BlockState)_bs.setValue(_property, (Comparable)entry.getValue());
                    }
                    catch (Exception exception) {}
                }
                level.setBlock(_bp, _bs, 3);
            } else if (level.getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).getBlock() == ModBlocks.TABLE_2X1_WHITE.get()) {
                BlockPos _bp = BlockPos.containing((double)x, (double)y, (double)z);
                BlockState _bs = ((Block)ModBlocks.TABLE_2X1_WHITE_ALT.get()).defaultBlockState();
                BlockState _bso = level.getBlockState(_bp);
                for (Map.Entry entry : _bso.getValues().entrySet()) {
                    Property _property = _bs.getBlock().getStateDefinition().getProperty(((Property)entry.getKey()).getName());
                    if (_property == null || _bs.getValue(_property) == null) continue;
                    try {
                        _bs = (BlockState)_bs.setValue(_property, (Comparable)entry.getValue());
                    }
                    catch (Exception exception) {}
                }
                level.setBlock(_bp, _bs, 3);
            }
        } else {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }
}

