/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.nextgen_furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nhatjs.nextgen_furniture.entity.client.ChairBlockEntity;
import org.jetbrains.annotations.Nullable;

public class ChairBlock
extends Block {
    public static final DirectionProperty DIRECTION = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty MOVE = BooleanProperty.create((String)"move");

    public ChairBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)MOVE, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape shapeFor(Direction d) {
        switch (d) {
            default: 
        }
        return Block.box((double)3.0, (double)0.0, (double)2.25, (double)13.0, (double)10.65, (double)13.75);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return (Boolean)state.getValue((Property)MOVE) != false ? Shapes.empty() : ChairBlock.shapeFor((Direction)state.getValue((Property)DIRECTION));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return ChairBlock.shapeFor((Direction)state.getValue((Property)DIRECTION));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DIRECTION, MOVE});
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        boolean move = (Boolean)state.getValue((Property)MOVE);
        if (player.isShiftKeyDown()) {
            if (!move) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOVE, (Comparable)Boolean.valueOf(true)), 3);
                return InteractionResult.SUCCESS;
            }
            if (move) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOVE, (Comparable)Boolean.valueOf(false)), 3);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        if (move) {
            return InteractionResult.SUCCESS;
        }
        return ChairBlockEntity.create(level, pos, 0.4, player, (Direction)state.getValue((Property)DIRECTION));
    }
}

