/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.nextgen_furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nhatjs.nextgen_furniture.entity.client.ChairBlockEntity;

public class SofaBlock
extends Block {
    public static final DirectionProperty DIRECTION = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    private final DyeColor color;

    public SofaBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(settings);
        this.color = color;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)DIRECTION)) {
            default: 
        }
        return Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)7.525, (double)16.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{DIRECTION, PART});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getHorizontalDirection();
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)facing);
        if (state != null) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)this.getShape(state, (LevelAccessor)ctx.getLevel(), ctx.getClickedPos())));
        }
        return null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return (BlockState)state.setValue(PART, (Comparable)((Object)this.getShape(state, level, pos)));
    }

    public Part getShape(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)DIRECTION);
        Direction front = this.getSofaState(level, pos, facing.getOpposite());
        if (front != null) {
            if (front == facing.getClockWise()) {
                return Part.CORNER_RIGHT;
            }
            if (front == facing.getCounterClockWise()) {
                return Part.CORNER_LEFT;
            }
        }
        boolean left = this.isConnectable(level, pos, facing, facing.getCounterClockWise());
        boolean right = this.isConnectable(level, pos, facing, facing.getClockWise());
        if (left && right) {
            return Part.MIDDLE;
        }
        if (left) {
            return Part.RIGHT;
        }
        if (right) {
            return Part.LEFT;
        }
        return Part.SINGLE;
    }

    private Direction getSofaState(LevelAccessor level, BlockPos pos, Direction side) {
        BlockState relativeState = level.getBlockState(pos.relative(side));
        return relativeState.getBlock() instanceof SofaBlock ? (Direction)relativeState.getValue((Property)DIRECTION) : null;
    }

    private boolean isConnectable(LevelAccessor level, BlockPos pos, Direction facing, Direction offset) {
        BlockPos relativePos = pos.relative(offset);
        BlockState relativeState = level.getBlockState(pos.relative(offset));
        if (relativeState.getBlock() instanceof SofaBlock) {
            Direction other = (Direction)relativeState.getValue((Property)DIRECTION);
            return other == facing || other == offset;
        }
        return relativeState.isFaceSturdy((BlockGetter)level, relativePos, offset.getOpposite());
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        return ChairBlockEntity.create(level, pos, 0.35, player, (Direction)state.getValue((Property)DIRECTION));
    }

    public static enum Part implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

