/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.nextgen_furniture.entity.client;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.nhatjs.nextgen_furniture.entity.ModEntities;

public class ChairBlockEntity
extends Entity {
    public ChairBlockEntity(Level pLevel) {
        super((EntityType)ModEntities.CHAIR.get(), pLevel);
    }

    private ChairBlockEntity(Level level, BlockPos source, double yOffset, Direction direction) {
        this(level);
        this.setPos((double)source.getX() + 0.5, (double)source.getY() + yOffset, (double)source.getZ() + 0.5);
        this.setRot(direction.getOpposite().toYRot(), 0.0f);
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        this.kill();
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            BlockPos pos = this.blockPosition();
            if (this.getPassengers().isEmpty() || this.level().isEmptyBlock(pos)) {
                this.discard();
                this.level().updateNeighbourForOutputSignal(pos, this.level().getBlockState(pos).getBlock());
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide) {
            if (this.isVehicle()) {
                this.getPassengers().forEach(p -> p.stopRiding());
            }
            this.ejectPassengers();
        }
        super.remove(reason);
    }

    public static InteractionResult create(Level level, BlockPos pos, double yOffset, Player player, Direction direction) {
        List seats;
        if (!level.isClientSide() && (seats = level.getEntitiesOfClass(ChairBlockEntity.class, new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 1.0, (double)pos.getZ() + 1.0))).isEmpty()) {
            ChairBlockEntity seat = new ChairBlockEntity(level, pos, yOffset, direction);
            level.addFreshEntity((Entity)seat);
            player.startRiding((Entity)seat, false);
        }
        return InteractionResult.SUCCESS;
    }
}

