/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.nextgen_furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PictureFrameBlock
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;

    public PictureFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Block.box((double)3.5, (double)2.0, (double)15.65, (double)12.5, (double)14.0, (double)16.0);
            case Direction.SOUTH -> Block.box((double)3.5, (double)2.0, (double)0.0, (double)12.5, (double)14.0, (double)0.35);
            case Direction.EAST -> Block.box((double)0.0, (double)2.0, (double)3.5, (double)0.35, (double)14.0, (double)12.5);
            case Direction.WEST -> Block.box((double)15.65, (double)2.0, (double)3.5, (double)16.0, (double)14.0, (double)12.5);
            case Direction.UP -> Block.box((double)3.5, (double)0.0, (double)2.0, (double)12.5, (double)0.35, (double)14.0);
            case Direction.DOWN -> Block.box((double)3.5, (double)15.65, (double)2.0, (double)12.5, (double)16.0, (double)14.0);
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getNearestLookingDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{FACING});
    }
}

