/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.nextgen_furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LaptopBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty OPEN_STAGE = IntegerProperty.m_61631_((String)"open_stage", (int)0, (int)8);
    public static final BooleanProperty OPEN_TARGET = BooleanProperty.m_61465_((String)"open_target");
    public static final IntegerProperty BOOT_STAGE = IntegerProperty.m_61631_((String)"boot_stage", (int)0, (int)5);
    public static final BooleanProperty SCREEN_ON = BooleanProperty.m_61465_((String)"screen_on");

    public LaptopBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN_STAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)OPEN_TARGET, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOT_STAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SCREEN_ON, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            default: 
        }
        return LaptopBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> b) {
        b.m_61104_(new Property[]{FACING, OPEN_STAGE, OPEN_TARGET, BOOT_STAGE, SCREEN_ON});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState s, Rotation r) {
        return (BlockState)s.m_61124_((Property)FACING, (Comparable)r.m_55954_((Direction)s.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState s, Mirror m) {
        return s.m_60717_(m.m_54846_((Direction)s.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        int stage = (Integer)state.m_61143_((Property)OPEN_STAGE);
        boolean screenOn = (Boolean)state.m_61143_((Property)SCREEN_ON);
        if (player.m_6144_()) {
            if (stage == 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN_TARGET, (Comparable)Boolean.valueOf(true)), 3);
                LaptopBlock.schedule(level, pos, 2);
            } else if (!(stage != 7 && stage != 8 || screenOn)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN_TARGET, (Comparable)Boolean.valueOf(false)), 3);
                LaptopBlock.schedule(level, pos, 2);
            }
            return InteractionResult.CONSUME;
        }
        if (stage == 7) {
            level.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)OPEN_STAGE, (Comparable)Integer.valueOf(8))).m_61124_((Property)BOOT_STAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SCREEN_ON, (Comparable)Boolean.valueOf(false)), 3);
            LaptopBlock.schedule(level, pos, 10);
            return InteractionResult.CONSUME;
        }
        if (stage == 8) {
            if (screenOn) {
                level.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)SCREEN_ON, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOT_STAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)OPEN_STAGE, (Comparable)Integer.valueOf(7)), 3);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BOOT_STAGE, (Comparable)Integer.valueOf(0)), 3);
                LaptopBlock.schedule(level, pos, 10);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME;
    }

    private static void schedule(Level level, BlockPos pos, int delay) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            sl.m_186460_(pos, sl.m_8055_(pos).m_60734_(), delay);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        int stage = (Integer)state.m_61143_((Property)OPEN_STAGE);
        boolean wantOpen = (Boolean)state.m_61143_((Property)OPEN_TARGET);
        if (wantOpen && stage < 7 || !wantOpen && stage > 0) {
            int next = wantOpen ? stage + 1 : stage - 1;
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN_STAGE, (Comparable)Integer.valueOf(next)), 3);
            LaptopBlock.schedule((Level)level, pos, 1);
            return;
        }
        if (stage == 8 && !((Boolean)state.m_61143_((Property)SCREEN_ON)).booleanValue()) {
            int boot = (Integer)state.m_61143_((Property)BOOT_STAGE);
            if (boot < 5) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BOOT_STAGE, (Comparable)Integer.valueOf(boot + 1)), 3);
                LaptopBlock.schedule((Level)level, pos, 20);
            } else {
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)SCREEN_ON, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOOT_STAGE, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }
}

