/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.nextgen_furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LaptopBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty OPEN_STAGE = IntegerProperty.create((String)"open_stage", (int)0, (int)8);
    public static final BooleanProperty OPEN_TARGET = BooleanProperty.create((String)"open_target");
    public static final IntegerProperty BOOT_STAGE = IntegerProperty.create((String)"boot_stage", (int)0, (int)5);
    public static final BooleanProperty SCREEN_ON = BooleanProperty.create((String)"screen_on");

    public LaptopBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN_STAGE, (Comparable)Integer.valueOf(0))).setValue((Property)OPEN_TARGET, (Comparable)Boolean.valueOf(false))).setValue((Property)BOOT_STAGE, (Comparable)Integer.valueOf(0))).setValue((Property)SCREEN_ON, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            default: 
        }
        return LaptopBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN_STAGE, OPEN_TARGET, BOOT_STAGE, SCREEN_ON});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult r = this.handleUse(state, level, pos, player);
        return r.consumesAction() ? ItemInteractionResult.sidedSuccess((boolean)level.isClientSide()) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player);
    }

    private InteractionResult handleUse(BlockState state, Level level, BlockPos pos, Player player) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        int stage = (Integer)state.getValue((Property)OPEN_STAGE);
        boolean screenOn = (Boolean)state.getValue((Property)SCREEN_ON);
        if (player.isShiftKeyDown()) {
            if (stage == 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN_TARGET, (Comparable)Boolean.valueOf(true)), 3);
                LaptopBlock.schedule(level, pos, 2);
                return InteractionResult.CONSUME;
            }
            if (stage == 7 || stage == 8) {
                if (screenOn) {
                    return InteractionResult.CONSUME;
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN_TARGET, (Comparable)Boolean.valueOf(false)), 3);
                LaptopBlock.schedule(level, pos, 2);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.CONSUME;
        }
        if (stage == 7) {
            level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)OPEN_STAGE, (Comparable)Integer.valueOf(8))).setValue((Property)BOOT_STAGE, (Comparable)Integer.valueOf(0))).setValue((Property)SCREEN_ON, (Comparable)Boolean.valueOf(false)), 3);
            LaptopBlock.schedule(level, pos, 10);
            return InteractionResult.CONSUME;
        }
        if (stage == 8) {
            if (screenOn) {
                level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)SCREEN_ON, (Comparable)Boolean.valueOf(false))).setValue((Property)BOOT_STAGE, (Comparable)Integer.valueOf(0))).setValue((Property)OPEN_STAGE, (Comparable)Integer.valueOf(7)), 3);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)BOOT_STAGE, (Comparable)Integer.valueOf(0)), 3);
                LaptopBlock.schedule(level, pos, 10);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME;
    }

    private static void schedule(Level level, BlockPos pos, int delay) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            sl.scheduleTick(pos, sl.getBlockState(pos).getBlock(), delay);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int stage = (Integer)state.getValue((Property)OPEN_STAGE);
        boolean wantOpen = (Boolean)state.getValue((Property)OPEN_TARGET);
        if (wantOpen && stage < 7 || !wantOpen && stage > 0) {
            int next = wantOpen ? stage + 1 : stage - 1;
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN_STAGE, (Comparable)Integer.valueOf(next)), 3);
            LaptopBlock.schedule((Level)level, pos, 1);
            return;
        }
        if (stage == 8 && !((Boolean)state.getValue((Property)SCREEN_ON)).booleanValue()) {
            int boot = (Integer)state.getValue((Property)BOOT_STAGE);
            if (boot < 5) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BOOT_STAGE, (Comparable)Integer.valueOf(boot + 1)), 3);
                LaptopBlock.schedule((Level)level, pos, 20);
            } else {
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)SCREEN_ON, (Comparable)Boolean.valueOf(true))).setValue((Property)BOOT_STAGE, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }
}

