/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.nextgen_furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nhatjs.nextgen_furniture.block.state.Table2x1Position;

public class Table2x1Block
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Table2x1Position> POSITION = EnumProperty.create((String)"position", Table2x1Position.class);

    public Table2x1Block(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(POSITION, (Comparable)((Object)Table2x1Position.CENTER))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            default: 
        }
        return Table2x1Block.box((double)0.0, (double)0.05, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{FACING, POSITION});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue(POSITION, (Comparable)((Object)Table2x1Position.CENTER));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player);
    }

    private InteractionResult handleUse(BlockState state, Level level, BlockPos pos, Player player) {
        Table2x1Position next;
        ItemStack held = player.getMainHandItem();
        if (!player.isShiftKeyDown() || !held.isEmpty()) {
            return InteractionResult.PASS;
        }
        switch ((Table2x1Position)((Object)state.getValue(POSITION))) {
            default: {
                throw new MatchException(null, null);
            }
            case CENTER: {
                Table2x1Position table2x1Position = Table2x1Position.LEFT;
                break;
            }
            case LEFT: {
                Table2x1Position table2x1Position = Table2x1Position.RIGHT;
                break;
            }
            case RIGHT: {
                Table2x1Position table2x1Position = next = Table2x1Position.CENTER;
            }
        }
        if (!level.isClientSide) {
            level.setBlock(pos, (BlockState)state.setValue(POSITION, (Comparable)((Object)next)), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }
}

