/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.nextgen_furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nhatjs.nextgen_furniture.entity.client.ChairBlockEntity;

public class SofaBlock
extends Block {
    public static final DirectionProperty DIRECTION = BlockStateProperties.f_61374_;
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)DIRECTION)) {
            default: 
        }
        return Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)7.525, (double)16.0);
    }

    public SofaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)Part.SINGLE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DIRECTION, PART});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_8125_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)facing);
        if (state != null) {
            return (BlockState)state.m_61124_(PART, (Comparable)((Object)this.getShape(state, (LevelAccessor)ctx.m_43725_(), ctx.m_8083_())));
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return (BlockState)state.m_61124_(PART, (Comparable)((Object)this.getShape(state, level, pos)));
    }

    public Part getShape(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)DIRECTION);
        Direction front = this.getSofaState(level, pos, facing.m_122424_());
        if (front != null) {
            if (front == facing.m_122427_()) {
                return Part.CORNER_RIGHT;
            }
            if (front == facing.m_122428_()) {
                return Part.CORNER_LEFT;
            }
        }
        boolean left = this.isConnectable(level, pos, facing, facing.m_122428_());
        boolean right = this.isConnectable(level, pos, facing, facing.m_122427_());
        if (left && right) {
            return Part.MIDDLE;
        }
        if (left) {
            return Part.RIGHT;
        }
        if (right) {
            return Part.LEFT;
        }
        return Part.SINGLE;
    }

    private Direction getSofaState(LevelAccessor level, BlockPos pos, Direction side) {
        BlockState relativeState = level.m_8055_(pos.m_121945_(side));
        return relativeState.m_60734_() instanceof SofaBlock ? (Direction)relativeState.m_61143_((Property)DIRECTION) : null;
    }

    private boolean isConnectable(LevelAccessor level, BlockPos pos, Direction facing, Direction offset) {
        BlockPos relativePos = pos.m_121945_(offset);
        BlockState relativeState = level.m_8055_(pos.m_121945_(offset));
        if (relativeState.m_60734_() instanceof SofaBlock) {
            Direction other = (Direction)relativeState.m_61143_((Property)DIRECTION);
            return other == facing || other == offset;
        }
        return relativeState.m_60783_((BlockGetter)level, relativePos, offset.m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return ChairBlockEntity.create(level, pos, 0.35, player, (Direction)state.m_61143_((Property)DIRECTION));
    }

    public static enum Part implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

