/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.nextgen_furniture.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nhatjs.nextgen_furniture.entity.ModEntities;

public class SofaBlock
extends Block {
    public static final EnumProperty<Direction> DIRECTION = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    private static final MapCodec<SofaBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)DyeColor.CODEC.fieldOf("color").forGetter(block -> block.color), (App)SofaBlock.propertiesCodec()).apply((Applicative)builder, SofaBlock::new));
    private final DyeColor color;

    public SofaBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(settings);
        this.color = color;
    }

    public DyeColor getColor() {
        return this.color;
    }

    protected MapCodec<SofaBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue(DIRECTION)) {
            default: 
        }
        return Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)7.525, (double)16.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{DIRECTION, PART});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getHorizontalDirection();
        BlockState state = (BlockState)this.defaultBlockState().setValue(DIRECTION, (Comparable)facing);
        if (state != null) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)this.getShape(state, (LevelReader)ctx.getLevel(), ctx.getClickedPos())));
        }
        return null;
    }

    protected BlockState updateShape(BlockState state, LevelReader reader, ScheduledTickAccess access, BlockPos pos, Direction direction, BlockPos pos1, BlockState state1, RandomSource rand) {
        return (BlockState)state.setValue(PART, (Comparable)((Object)this.getShape(state, reader, pos)));
    }

    public Part getShape(BlockState state, LevelReader reader, BlockPos pos) {
        Direction facing = (Direction)state.getValue(DIRECTION);
        Direction front = this.getSofaState(reader, pos, facing.getOpposite());
        if (front != null) {
            if (front == facing.getClockWise()) {
                return Part.CORNER_RIGHT;
            }
            if (front == facing.getCounterClockWise()) {
                return Part.CORNER_LEFT;
            }
        }
        boolean left = this.isConnectable(reader, pos, facing, facing.getCounterClockWise());
        boolean right = this.isConnectable(reader, pos, facing, facing.getClockWise());
        if (left && right) {
            return Part.MIDDLE;
        }
        if (left) {
            return Part.RIGHT;
        }
        if (right) {
            return Part.LEFT;
        }
        return Part.SINGLE;
    }

    private Direction getSofaState(LevelReader reader, BlockPos pos, Direction side) {
        BlockState relativeState = reader.getBlockState(pos.relative(side));
        return relativeState.getBlock() instanceof SofaBlock ? (Direction)relativeState.getValue(DIRECTION) : null;
    }

    private boolean isConnectable(LevelReader reader, BlockPos pos, Direction facing, Direction offset) {
        BlockPos relativePos = pos.relative(offset);
        BlockState relativeState = reader.getBlockState(pos.relative(offset));
        if (relativeState.getBlock() instanceof SofaBlock) {
            Direction other = (Direction)relativeState.getValue(DIRECTION);
            return other == facing || other == offset;
        }
        return relativeState.isFaceSturdy((BlockGetter)reader, relativePos, offset.getOpposite());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Entity entity = null;
            List entities = level.getEntities((EntityTypeTest)ModEntities.SOFA.get(), new AABB(pos), sofa -> true);
            entity = entities.isEmpty() ? ModEntities.SOFA.get().spawn((ServerLevel)level, pos, EntitySpawnReason.TRIGGERED) : (Entity)entities.get(0);
            player.startRiding(entity);
        }
        return InteractionResult.SUCCESS;
    }

    public static enum Part implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

