/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.nextgen_furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TVBlock
extends Block {
    public static final EnumProperty<Direction> DIRECTION = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty TV_ON = BooleanProperty.create((String)"tv_on");
    public static final EnumProperty<Mount> MOUNT = EnumProperty.create((String)"mount", Mount.class);
    private static final VoxelShape NORTH_MOUNT = Block.box((double)-10.75, (double)4.45, (double)14.6, (double)26.75, (double)26.3, (double)16.0);
    private static final VoxelShape SOUTH_MOUNT = Block.box((double)-10.75, (double)4.45, (double)0.0, (double)26.75, (double)26.3, (double)1.4);
    private static final VoxelShape WEST_MOUNT = Block.box((double)14.6, (double)4.45, (double)-10.75, (double)16.0, (double)26.3, (double)26.75);
    private static final VoxelShape EAST_MOUNT = Block.box((double)0.0, (double)4.45, (double)-10.75, (double)1.4, (double)26.3, (double)26.75);
    private static final VoxelShape NORTH_STAND = Block.box((double)-10.75, (double)1.75, (double)12.1, (double)26.75, (double)23.8, (double)13.7);
    private static final VoxelShape SOUTH_STAND = Block.box((double)-10.75, (double)1.75, (double)2.3, (double)26.75, (double)23.8, (double)3.9);
    private static final VoxelShape WEST_STAND = Block.box((double)12.1, (double)1.75, (double)-10.75, (double)13.7, (double)23.8, (double)26.75);
    private static final VoxelShape EAST_STAND = Block.box((double)2.3, (double)1.75, (double)-10.75, (double)3.9, (double)23.8, (double)26.75);

    public TVBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)TV_ON, (Comparable)Boolean.valueOf(false))).setValue(MOUNT, (Comparable)((Object)Mount.STAND)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{DIRECTION, TV_ON, MOUNT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue(DIRECTION);
        boolean wall = state.getValue(MOUNT) == Mount.WALL;
        return switch (direction) {
            default -> {
                if (wall) {
                    yield NORTH_MOUNT;
                }
                yield Shapes.or((VoxelShape)NORTH_STAND, (VoxelShape[])new VoxelShape[0]);
            }
            case Direction.SOUTH -> {
                if (wall) {
                    yield SOUTH_MOUNT;
                }
                yield Shapes.or((VoxelShape)SOUTH_STAND, (VoxelShape[])new VoxelShape[0]);
            }
            case Direction.EAST -> {
                if (wall) {
                    yield EAST_MOUNT;
                }
                yield Shapes.or((VoxelShape)EAST_STAND, (VoxelShape[])new VoxelShape[0]);
            }
            case Direction.WEST -> wall ? WEST_MOUNT : Shapes.or((VoxelShape)WEST_STAND, (VoxelShape[])new VoxelShape[0]);
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction face = ctx.getClickedFace();
        if (face.getAxis().isHorizontal()) {
            BlockPos back = ctx.getClickedPos().offset(face.getOpposite().getUnitVec3i());
            if (this.hasSupport((LevelAccessor)ctx.getLevel(), back, face)) {
                return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(DIRECTION, (Comparable)face)).setValue(MOUNT, (Comparable)((Object)Mount.WALL))).setValue((Property)TV_ON, (Comparable)Boolean.valueOf(false));
            }
            return null;
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(DIRECTION, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue(MOUNT, (Comparable)((Object)Mount.STAND))).setValue((Property)TV_ON, (Comparable)Boolean.valueOf(false));
    }

    private boolean hasSupport(LevelAccessor level, BlockPos pos, Direction supportFace) {
        BlockState bs = level.getBlockState(pos);
        return bs.isFaceSturdy((BlockGetter)level, pos, supportFace) || bs.isRedstoneConductor((BlockGetter)level, pos);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            boolean next = (Boolean)state.getValue((Property)TV_ON) == false;
            level.setBlock(pos, (BlockState)state.setValue((Property)TV_ON, (Comparable)Boolean.valueOf(next)), 3);
        }
        return InteractionResult.SUCCESS;
    }

    public static enum Mount implements StringRepresentable
    {
        STAND("stand"),
        WALL("wall");

        private final String name;

        private Mount(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

