/*
 * Decompiled with CFR 0.152.
 */
package banduty.kingdomsieges.entity.custom.sieges;

import banduty.kingdomsieges.sounds.ModSounds;
import banduty.stoneycore.entity.custom.AbstractSiegeEntity;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.siege.SiegeManager;
import banduty.stoneycore.util.BlockDamageTracker;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BatteringRamEntity
extends AbstractSiegeEntity
implements GeoEntity {
    private int moveTick;
    private final Random random = new Random();
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation attack = RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE);
    protected static final class_2940<Boolean> ATTACK_HAPPENED = class_2945.method_12791(BatteringRamEntity.class, (class_2941)class_2943.field_13323);

    public BatteringRamEntity(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 150.0).method_26868(class_5134.field_23719, 0.025).method_26868(class_5134.field_23718, 265.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTACK_HAPPENED, (Object)true);
    }

    public void setAttackHappened(boolean attackHappened) {
        this.field_6011.method_12778(ATTACK_HAPPENED, (Object)attackHappened);
    }

    public boolean getAttackHappened() {
        return (Boolean)this.field_6011.method_12789(ATTACK_HAPPENED);
    }

    public boolean method_5818(class_1297 entity) {
        return this.method_5685().isEmpty() && (entity instanceof class_1657 || entity instanceof class_1498);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_3218 serverWorld;
        block8: {
            block7: {
                class_1937 class_19372 = this.method_37908();
                if (!(class_19372 instanceof class_3218)) break block7;
                serverWorld = (class_3218)class_19372;
                if (hand == class_1268.field_5808) break block8;
            }
            return super.method_5688(player, hand);
        }
        super.method_5688(player, hand);
        UUID playerId = player.method_5667();
        Optional siegeOpt = SiegeManager.getPlayerSiege((class_3218)serverWorld, (UUID)playerId);
        if (siegeOpt.map(siege -> siege.isDisabled(playerId)).orElse(false).booleanValue()) {
            return class_1269.field_5814;
        }
        LandState stateManager = LandState.get((class_3218)serverWorld);
        Optional maybeLand = stateManager.getLandAt(this.method_24515());
        boolean isOwnerOrAlly = maybeLand.map(land -> land.getOwnerUUID().equals(playerId) || land.isAlly(playerId) || player.method_7337()).orElse(true);
        if (!isOwnerOrAlly) {
            return class_1269.field_5814;
        }
        if (this.method_31483() != null) {
            return class_1269.field_5814;
        }
        if (this.getCooldown() <= 0 && player.method_5715()) {
            this.triggerAnim("anim_controller", "attack");
            this.setAttackHappened(false);
            this.setCooldown(50);
            this.setOwner((class_1297)this);
            serverWorld.method_18456().forEach(p -> {
                float t;
                float volume;
                double distance = p.method_19538().method_1022(this.method_19538());
                if (distance <= 15.0 && (volume = 1.0f - (t = (float)(distance / 15.0))) > 0.0f) {
                    p.method_17356((class_3414)ModSounds.ROPE_CHARGE_BR.get(), class_3419.field_15256, volume, this.random.nextFloat(0.75f, 1.25f));
                }
            });
        }
        return class_1269.field_5812;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "anim_controller", state -> PlayState.STOP).triggerableAnim("attack", this.attack)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public void method_5773() {
        boolean isMoving;
        super.method_5773();
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        boolean bl = isMoving = this.method_18798().field_1352 != 0.0 || this.method_18798().field_1350 != 0.0;
        if (isMoving && this.method_5805()) {
            if (this.moveTick >= 150 || this.moveTick == 0) {
                serverWorld.method_18456().forEach(p -> {
                    if (p.method_19538().method_1022(this.method_19538()) <= 30.0) {
                        p.method_17356((class_3414)ModSounds.SIEGE_ENGINE_MOVE.get(), class_3419.field_15256, (float)(1.0 - p.method_19538().method_1022(this.method_19538()) / 30.0), 1.0f);
                    }
                });
                if (this.moveTick != 0) {
                    this.moveTick = 0;
                }
            }
            ++this.moveTick;
        } else if (this.moveTick != 0 || !this.method_5805()) {
            this.moveTick = 0;
            serverWorld.method_18456().forEach(p -> p.field_13987.method_14364((class_2596)new class_2770(((class_3414)ModSounds.SIEGE_ENGINE_MOVE.get()).method_14833(), class_3419.field_15256)));
        }
        this.setCooldown(this.getCooldown() - 1);
        BlockDamageTracker.clean((class_3218)serverWorld);
        if (this.getCooldown() <= 6 && !this.getAttackHappened()) {
            this.destroyBlocksInFront();
            this.setAttackHappened(true);
            serverWorld.method_18456().forEach(p -> {
                double distance = p.method_19538().method_1022(this.method_19538());
                if (distance <= 40.0) {
                    float volume;
                    if (distance <= 5.0) {
                        volume = 1.0f;
                    } else {
                        float t = (float)((distance - 5.0) / 35.0);
                        volume = 1.0f - t;
                    }
                    if (volume > 0.0f) {
                        p.method_17356((class_3414)ModSounds.RAM_IMPACT.get(), class_3419.field_15256, volume, this.random.nextFloat(0.75f, 1.25f));
                    }
                }
            });
        }
    }

    private void destroyBlocksInFront() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_243 lookVec = this.method_5828(1.0f).method_1029();
        class_243 front = this.method_19538().method_1019(lookVec.method_1021(2.5));
        int baseX = (int)Math.floor(front.field_1352);
        int baseY = (int)Math.floor(this.method_23318() + 1.0);
        int baseZ = (int)Math.floor(front.field_1350);
        double radius = 1.5;
        class_243 boxCenter = new class_243((double)baseX + 0.5, (double)baseY, (double)baseZ + 0.5);
        class_243 knockbackDir = this.method_5828(1.0f).method_1029().method_1021(2.5);
        float baseDamage = (float)this.getBaseDamage();
        serverWorld.method_8333((class_1297)this, new class_238(boxCenter.field_1352 - radius, boxCenter.field_1351 - 1.0, boxCenter.field_1350 - radius, boxCenter.field_1352 + radius, boxCenter.field_1351 + 2.0, boxCenter.field_1350 + radius), entity -> {
            class_1657 playerEntity;
            return entity instanceof class_1309 && (!(entity instanceof class_1657) || !(playerEntity = (class_1657)entity).method_7337());
        }).forEach(entity -> {
            entity.method_5643(serverWorld.method_48963().method_48812((class_1309)this.getOwner()), baseDamage);
            class_243 knockback = new class_243(knockbackDir.field_1352, 0.25, knockbackDir.field_1350);
            entity.method_45319(knockback);
            entity.field_6037 = true;
        });
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    class_2338 pos = new class_2338(baseX + x, baseY + y, baseZ + z);
                    class_2680 state = serverWorld.method_8320(pos);
                    if (state.method_26215() || state.method_26214((class_1922)serverWorld, pos) < 0.0f) continue;
                    float hardness = state.method_26214((class_1922)serverWorld, pos);
                    float damageFactor = 1.0f / (40.0f / baseDamage);
                    BlockDamageTracker.damageBlock((class_3218)serverWorld, (class_2338)pos, (float)damageFactor, (float)hardness);
                }
            }
        }
    }

    public class_243 getPassengerOffset(class_1297 entity) {
        if (entity instanceof class_1498) {
            return new class_243(0.0, 0.0, -1.25);
        }
        return new class_243(0.0, 0.0, 1.25);
    }

    public class_243 getPlayerPOV() {
        return new class_243(0.0, (double)-0.7f, 0.0);
    }
}

