/*
 * Decompiled with CFR 0.152.
 */
package banduty.kingdomsieges.util.servertick;

import banduty.kingdomsieges.Kingdomsieges;
import banduty.kingdomsieges.config.KSConfigs;
import banduty.kingdomsieges.config.KingdomSiegesConfig;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.siege.SiegeManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3709;
import net.minecraft.class_3721;
import net.minecraft.class_5712;

public class BellRinger {
    private static long lastHour = -1L;
    private static long lastRealHour = -1L;
    private static final Map<class_3218, List<BellChimeTask>> chimeTasks = new HashMap<class_3218, List<BellChimeTask>>();
    private static final Map<Land, Integer> siegeRingTimers = new HashMap<Land, Integer>();

    public static void tick(class_3218 world, LandState landState) {
        long last;
        BellRinger.tickChimeTasks(world);
        HashSet<Land> allLands = new HashSet<Land>(landState.getAllLands());
        HashSet<Land> landsUnderSiege = new HashSet<Land>();
        for (Land land : allLands) {
            if (!SiegeManager.isLandDefenseSiege((class_3218)world, (Land)land)) continue;
            siegeRingTimers.putIfAbsent(land, 800);
        }
        Iterator<Map.Entry<Land, Integer>> iter = siegeRingTimers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Land, Integer> entry = iter.next();
            Land land = entry.getKey();
            int ticksLeft = entry.getValue();
            if (!allLands.contains(land) || ticksLeft <= 0) {
                iter.remove();
                continue;
            }
            landsUnderSiege.add(land);
            siegeRingTimers.put(land, ticksLeft - 1);
            if (ticksLeft % 30 != 0) continue;
            for (class_2338 bellPos : BellRinger.findBellsInClaim(world, land)) {
                BellRinger.scheduleBellRing(world, bellPos, 0, 1.2f);
            }
        }
        long timeOfDay = world.method_8532() % 24000L;
        long currentIngameHour = (timeOfDay / 1000L + 6L) % 24L;
        Calendar calendar = Calendar.getInstance();
        int realHour = calendar.get(11);
        KingdomSiegesConfig config = Kingdomsieges.getConfig();
        KSConfigs.Choices choice = config.bellRingTime();
        if (!BellRinger.shouldRingBell(choice, currentIngameHour, realHour)) {
            return;
        }
        boolean isIngame = choice == KSConfigs.Choices.EVERY_INGAME_HOUR || choice == KSConfigs.Choices.TWELVE_INGAME_HOURS;
        long currentHour = isIngame ? currentIngameHour : (long)realHour;
        long l = last = isIngame ? lastHour : lastRealHour;
        if (currentHour != last) {
            if (isIngame) {
                lastHour = currentHour;
            } else {
                lastRealHour = currentHour;
            }
            BellRinger.chimeHour(world, allLands, landsUnderSiege, currentHour);
        }
    }

    private static boolean shouldRingBell(KSConfigs.Choices choice, long ingameHour, int realHour) {
        return switch (choice) {
            case KSConfigs.Choices.EVERY_INGAME_HOUR, KSConfigs.Choices.EVERY_HOUR -> true;
            case KSConfigs.Choices.TWELVE_INGAME_HOURS -> {
                if (ingameHour % 12L == 0L) {
                    yield true;
                }
                yield false;
            }
            case KSConfigs.Choices.TWELVE_HOURS -> {
                if (realHour % 12 == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static void chimeHour(class_3218 world, Set<Land> allLands, Set<Land> landsUnderSiege, long hour) {
        int rings = (int)(hour % 12L);
        rings = rings == 0 ? 12 : rings;
        for (Land land : allLands) {
            if (landsUnderSiege.contains(land)) continue;
            for (class_2338 bellPos : BellRinger.findBellsInClaim(world, land)) {
                int totalDelay = 0;
                float pitch = 0.8f;
                BellRinger.scheduleBellRing(world, bellPos, totalDelay, pitch);
                totalDelay += 50;
                for (int i = 0; i < (rings == 12 ? 24 : rings); ++i) {
                    boolean isEven;
                    boolean bl = isEven = i % 2 == 0;
                    if (rings == 12) {
                        pitch = isEven ? 1.1f : 0.9f;
                    }
                    BellRinger.scheduleBellRing(world, bellPos, totalDelay, pitch);
                    totalDelay += rings == 12 ? (isEven ? 10 : 50) : 50;
                }
            }
        }
    }

    private static List<class_2338> findBellsInClaim(class_3218 world, Land land) {
        ArrayList<class_2338> bells = new ArrayList<class_2338>();
        int bottomY = world.method_31607();
        int topY = world.method_31600();
        for (class_2338 basePos : land.getClaimed()) {
            for (int y = bottomY; y <= topY; ++y) {
                class_2338 pos = new class_2338(basePos.method_10263(), y, basePos.method_10260());
                if (!(world.method_8320(pos).method_26204() instanceof class_3709)) continue;
                bells.add(pos);
            }
        }
        return bells;
    }

    private static void scheduleBellRing(class_3218 world, class_2338 pos, int delay, float pitch) {
        chimeTasks.computeIfAbsent(world, k -> new ArrayList()).add(new BellChimeTask(pos, delay, pitch));
    }

    private static void tickChimeTasks(class_3218 world) {
        List<BellChimeTask> tasks = chimeTasks.get(world);
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        Iterator<BellChimeTask> iter = tasks.iterator();
        while (iter.hasNext()) {
            BellChimeTask task = iter.next();
            if (--task.delay > 0) continue;
            class_2680 state = world.method_8320(task.pos);
            if (state.method_26204() instanceof class_3709) {
                BellRinger.ringBell(world, task.pos, state, task.pitch);
            }
            iter.remove();
        }
    }

    private static void ringBell(class_3218 world, class_2338 pos, class_2680 state, float pitch) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof class_3721) {
            class_3721 bell = (class_3721)be;
            class_2350 direction = (class_2350)state.method_11654((class_2769)class_3709.field_16324);
            bell.method_17031(direction);
            world.method_8396(null, pos, class_3417.field_17265, class_3419.field_15245, 2.0f, pitch);
            world.method_33596(null, class_5712.field_28733, pos);
        }
    }

    private static class BellChimeTask {
        final class_2338 pos;
        int delay;
        final float pitch;

        BellChimeTask(class_2338 pos, int delay, float pitch) {
            this.pos = pos;
            this.delay = delay;
            this.pitch = pitch;
        }
    }
}

