/*
 * Decompiled with CFR 0.152.
 */
package banduty.kingdomsieges.entity.custom.projectiles;

import banduty.stoneycore.entity.custom.AbstractSiegeEntity;
import banduty.stoneycore.entity.custom.AbstractSiegeProjectile;
import banduty.stoneycore.util.BlockDamageTracker;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3965;

public class TrebuchetProjectile
extends AbstractSiegeProjectile {
    private ImpactMode impactMode = ImpactMode.BREAK_BLOCKS;
    private class_1293 statusEffectInstance;
    private int cloudDuration;
    protected static final class_2940<String> TEXTURE_NAME = class_2945.method_12791(TrebuchetProjectile.class, (class_2941)class_2943.field_13326);

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TEXTURE_NAME, (Object)"");
    }

    public void setTextureName(String textureName) {
        this.field_6011.method_12778(TEXTURE_NAME, (Object)textureName);
    }

    public String getTextureName() {
        return (String)this.field_6011.method_12789(TEXTURE_NAME);
    }

    public TrebuchetProjectile(class_1299<? extends class_1665> entityEntityType, class_1937 world) {
        super(entityEntityType, world);
    }

    public TrebuchetProjectile(class_1299<TrebuchetProjectile> cannonProjectile, class_1309 shooter, class_1937 world) {
        super(cannonProjectile, shooter, world);
    }

    public void setImpactMode(ImpactMode mode) {
        this.impactMode = mode;
    }

    public ImpactMode getImpactMode() {
        return this.impactMode;
    }

    public void method_5773() {
        super.method_5773();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            BlockDamageTracker.clean((class_3218)serverWorld);
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        class_3218 serverWorld;
        int baseRadius;
        block8: {
            block7: {
                super.method_24920(blockHitResult);
                baseRadius = Math.max(1, (int)(this.method_7448() / 8.0));
                class_1937 world = this.method_37908();
                if (!(world instanceof class_3218)) break block7;
                serverWorld = (class_3218)world;
                if (this.method_24921() instanceof AbstractSiegeEntity) break block8;
            }
            return;
        }
        switch (this.getImpactMode().ordinal()) {
            case 0: {
                this.handleBlockBreaking(blockHitResult, serverWorld, baseRadius);
                break;
            }
            case 1: {
                this.handleSpreadFire(blockHitResult, serverWorld, baseRadius);
                break;
            }
            case 2: {
                this.handleSpreadEffect(blockHitResult, serverWorld, baseRadius);
            }
        }
        this.field_7588 = true;
        this.field_7574 = 7;
        this.method_7439(false);
        this.method_7451((byte)0);
        this.method_7444(class_3417.field_15151);
        this.method_7442(false);
        this.method_31472();
    }

    private void handleBlockBreaking(class_3965 blockHitResult, class_3218 serverWorld, int baseRadius) {
        class_2338 centerPos = blockHitResult.method_17777();
        Random random = new Random();
        int sideHitX = blockHitResult.method_17780().method_10166() == class_2350.class_2351.field_11048 ? 0 : baseRadius;
        int sideHitY = blockHitResult.method_17780().method_10166() == class_2350.class_2351.field_11052 ? 0 : baseRadius;
        int sideHitZ = blockHitResult.method_17780().method_10166() == class_2350.class_2351.field_11051 ? 0 : baseRadius;
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (int x = -sideHitX - 1; x <= sideHitX + 1; ++x) {
            for (int y = -sideHitY - 1; y <= sideHitY + 1; ++y) {
                for (int z = -sideHitZ - 1; z <= sideHitZ + 1; ++z) {
                    int i = x * x + y * y + z * z;
                    int radiusExtension = random.nextFloat() < 0.1f ? 1 : 0;
                    int effectiveRadius = baseRadius + radiusExtension;
                    if (i > effectiveRadius * effectiveRadius || random.nextFloat() < 0.199f * (float)(effectiveRadius - baseRadius) + 0.001f) continue;
                    mutablePos.method_10103(centerPos.method_10263() + x, centerPos.method_10264() + y, centerPos.method_10260() + z);
                    class_2338 pos = mutablePos.method_10062();
                    class_2680 state = serverWorld.method_8320(pos);
                    float hardness = state.method_26214((class_1922)serverWorld, pos);
                    if (state.method_26215() || hardness < 0.0f) continue;
                    BlockDamageTracker.damageBlock((class_3218)serverWorld, (class_2338)pos, (float)(1.0f / (40.0f / (float)this.method_7448()) * ((float)baseRadius / (float)effectiveRadius)), (float)hardness);
                }
            }
        }
        class_2680 blockState = this.method_37908().method_8320(blockHitResult.method_17777());
        blockState.method_26175(this.method_37908(), blockState, blockHitResult, (class_1676)this);
        class_243 vec3d = blockHitResult.method_17784().method_1023(this.method_23317(), this.method_23318(), this.method_23321());
        this.method_18799(vec3d);
        class_243 vec3d2 = vec3d.method_1029().method_1021((double)0.05f);
        this.method_23327(this.method_23317() - vec3d2.field_1352, this.method_23318() - vec3d2.field_1351, this.method_23321() - vec3d2.field_1350);
    }

    private void handleSpreadFire(class_3965 hitResult, class_3218 world, int baseRadius) {
        class_2338 center = hitResult.method_17777();
        Random random = new Random();
        for (class_2338 pos : class_2338.method_25996((class_2338)center, (int)baseRadius, (int)baseRadius, (int)baseRadius)) {
            if (!world.method_8320(pos).method_26215()) continue;
            boolean canPlaceFire = false;
            for (class_2350 dir : class_2350.values()) {
                class_2338 neighbor = pos.method_10093(dir);
                class_2680 neighborState = world.method_8320(neighbor);
                if (!neighborState.method_26216((class_1922)world, neighbor) && !neighborState.method_50011()) continue;
                canPlaceFire = true;
                break;
            }
            if (!canPlaceFire || !(random.nextFloat() < 0.3f)) continue;
            world.method_8501(pos, class_2246.field_10036.method_9564());
        }
    }

    protected class_3414 method_7440() {
        return class_3417.field_15152;
    }

    private void handleSpreadEffect(class_3965 hitResult, class_3218 world, int baseRadius) {
        if (this.statusEffectInstance == null) {
            return;
        }
        class_243 center = class_243.method_24953((class_2382)hitResult.method_17777());
        class_1295 cloud = new class_1295((class_1937)world, center.field_1352, center.field_1351, center.field_1350);
        cloud.method_5603((float)baseRadius);
        cloud.method_5609(-0.25f);
        cloud.method_5595(0);
        cloud.method_5604(this.getCloudDuration());
        cloud.method_5596(-1.0E-4f);
        cloud.method_5610(this.getStatusEffectInstance());
        world.method_8649((class_1297)cloud);
    }

    public class_1293 getStatusEffectInstance() {
        return this.statusEffectInstance;
    }

    public void setStatusEffectInstance(class_1293 statusEffectInstance) {
        this.statusEffectInstance = statusEffectInstance;
    }

    public int getCloudDuration() {
        return this.cloudDuration;
    }

    public void setCloudDuration(int cloudDuration) {
        this.cloudDuration = cloudDuration;
    }

    public static enum ImpactMode {
        BREAK_BLOCKS,
        SPREAD_FIRE,
        SPREAD_EFFECT;

    }
}

