/*
 * Decompiled with CFR 0.152.
 */
package banduty.kingdomsieges.entity.custom.sieges;

import banduty.kingdomsieges.entity.ModEntities;
import banduty.kingdomsieges.entity.custom.projectiles.CannonProjectile;
import banduty.kingdomsieges.items.KSItems;
import banduty.kingdomsieges.sounds.ModSounds;
import banduty.stoneycore.entity.custom.AbstractSiegeEntity;
import banduty.stoneycore.items.SCItems;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.particle.ModParticles;
import banduty.stoneycore.siege.SiegeManager;
import banduty.stoneycore.util.SCDamageCalculator;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2770;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CannonEntity
extends AbstractSiegeEntity
implements GeoEntity {
    private int moveTick;
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation fire = RawAnimation.begin().then("fire", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation loaded = RawAnimation.begin().then("loaded", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation unloaded = RawAnimation.begin().then("unloaded", Animation.LoopType.PLAY_ONCE);
    public int loadStage;

    public CannonEntity(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23719, 0.05).method_26868(class_5134.field_23718, 265.0);
    }

    public void method_5651(class_2487 nbt) {
        this.loadStage = nbt.method_10550("loadStage");
        super.method_5651(nbt);
    }

    public boolean method_5818(class_1297 entity) {
        return this.method_5685().isEmpty() && (entity instanceof class_1657 || entity instanceof class_1498);
    }

    public class_2487 method_5647(class_2487 nbt) {
        nbt.method_10569("loadStage", this.loadStage);
        return super.method_5647(nbt);
    }

    public int getLoadStage() {
        return this.loadStage;
    }

    public void setLoadStage(int loadStage) {
        this.loadStage = loadStage;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1792 expected;
        class_3218 serverWorld;
        block25: {
            block24: {
                class_1937 class_19372 = this.method_37908();
                if (!(class_19372 instanceof class_3218)) break block24;
                serverWorld = (class_3218)class_19372;
                if (hand == class_1268.field_5808) break block25;
            }
            return super.method_5688(player, hand);
        }
        super.method_5688(player, hand);
        UUID playerId = player.method_5667();
        Optional siegeOpt = SiegeManager.getPlayerSiege((class_3218)serverWorld, (UUID)playerId);
        if (siegeOpt.map(siege -> siege.isDisabled(playerId)).orElse(false).booleanValue()) {
            return class_1269.field_5814;
        }
        LandState stateManager = LandState.get((class_3218)serverWorld);
        Optional maybeLand = stateManager.getLandAt(this.method_24515());
        boolean isOwnerOrAlly = maybeLand.map(land -> land.getOwnerUUID().equals(playerId) || land.isAlly(playerId) || player.method_7337()).orElse(true);
        if (!isOwnerOrAlly) {
            return class_1269.field_5814;
        }
        if (this.method_31483() != null) {
            return class_1269.field_5814;
        }
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        int stage = this.getLoadStage();
        int cooldown = this.getCooldown();
        switch (stage) {
            case 0: {
                class_1792 class_17922 = (class_1792)SCItems.BLACK_POWDER.get();
                break;
            }
            case 1: 
            case 3: {
                class_1792 class_17922 = (class_1792)KSItems.RAMROD.get();
                break;
            }
            case 2: {
                class_1792 class_17922 = class_1802.field_20391;
                break;
            }
            case 4: {
                class_1792 class_17922 = class_1802.field_8884;
                break;
            }
            default: {
                class_1792 class_17922 = expected = null;
            }
        }
        if (cooldown > 0) {
            return class_1269.field_5812;
        }
        if (item != expected) {
            String expectedName = expected != null ? expected.method_7854().method_7964().getString() : "Unknown";
            player.method_7353((class_2561)class_2561.method_43469((String)"entity.kingdomsieges.cannon_entity.next_load", (Object[])new Object[]{expectedName}), true);
            return class_1269.field_5812;
        }
        if (!player.method_7337()) {
            if (expected == SCItems.BLACK_POWDER.get()) {
                if (stack.method_7947() < 32) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"entity.kingdomsieges.cannon_entity.black_powder_needed"), true);
                    return class_1269.field_5814;
                }
                stack.method_7934(32);
            } else if (expected == class_1802.field_20391) {
                stack.method_7934(1);
            } else if (expected == class_1802.field_8884 || expected == KSItems.RAMROD.get()) {
                stack.method_7970(1, player.method_6051(), (class_3222)player);
                if (stack.method_7919() >= stack.method_7936()) {
                    stack.method_7939(0);
                }
            }
        }
        this.setLoadStage(stage + 1);
        if (this.getLoadStage() == 4) {
            this.triggerAnim("anim_controller", "loaded");
        }
        if (this.getLoadStage() == 5 && this.method_31483() == null) {
            this.setOwner((class_1297)player);
            this.fireCannon(serverWorld);
        }
        return class_1269.field_5812;
    }

    private void fireCannon(class_3218 serverWorld) {
        this.triggerAnim("anim_controller", "fire");
        CannonProjectile projectile = new CannonProjectile((class_1299<CannonProjectile>)((class_1299)ModEntities.CANNON_BALL.get()), (class_1309)this, (class_1937)serverWorld);
        class_243 mouthPos = this.getMouthOffset();
        projectile.method_23327(mouthPos.field_1352, mouthPos.field_1351, mouthPos.field_1350);
        double blocksPerTick = (double)this.getProjectileSpeed() / 20.0;
        float accuracyDegrees = this.getAccuracyMultiplier();
        float yawOffset = (this.field_5974.method_43057() - 0.5f) * 4.0f * accuracyDegrees;
        float pitchOffset = (this.field_5974.method_43057() - 0.5f) * 4.0f * accuracyDegrees;
        float adjustedYaw = this.method_43078() + yawOffset;
        float adjustedPitch = this.method_36455() + pitchOffset;
        float yawRad = adjustedYaw * ((float)Math.PI / 180);
        float pitchRad = adjustedPitch * ((float)Math.PI / 180);
        double x = -Math.sin(yawRad) * Math.cos(pitchRad);
        double y = -Math.sin(pitchRad);
        double z = Math.cos(yawRad) * Math.cos(pitchRad);
        class_243 direction = new class_243(x, y, z).method_1029();
        class_243 velocity = direction.method_1021(blocksPerTick);
        projectile.method_18799(velocity);
        projectile.method_7438(this.getBaseDamage());
        projectile.setDamageType(SCDamageCalculator.DamageType.BLUDGEONING);
        projectile.method_7432((class_1297)this);
        serverWorld.method_8649((class_1297)projectile);
        serverWorld.method_18456().forEach(p -> {
            double distance = p.method_19538().method_1022(this.method_19538());
            if (distance <= 200.0) {
                float closeVolume;
                float distantVolume = 0.0f;
                if (distance <= 50.0) {
                    closeVolume = 1.0f;
                } else {
                    float t = (float)((distance - 50.0) / 150.0);
                    closeVolume = 1.0f - t;
                    distantVolume = t;
                }
                if (closeVolume > 0.0f) {
                    p.method_17356((class_3414)ModSounds.CANNON_CLOSE.get(), class_3419.field_15256, closeVolume, 1.0f);
                }
                if (distantVolume > 0.0f) {
                    p.method_17356((class_3414)ModSounds.CANNON_DISTANT.get(), class_3419.field_15256, distantVolume, 1.0f);
                }
            }
        });
        this.setLoadStage(0);
        this.setCooldown(90);
        ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11251, mouthPos.field_1352, mouthPos.field_1351, mouthPos.field_1350, 20, 0.05, 0.05, 0.05, 0.01);
        CannonEntity.spawnParticleTrail(serverWorld, velocity.method_1029(), mouthPos, (class_2394)ModParticles.MUZZLES_SMOKE_PARTICLE.get(), 100, 0.2f, 5.0E-4f, 5);
        CannonEntity.spawnParticleTrail(serverWorld, velocity.method_1029(), mouthPos, (class_2394)ModParticles.MUZZLES_FLASH_PARTICLE.get(), 1, 0.0f, 0.1f, 6);
    }

    private static void spawnParticleTrail(class_3218 world, class_243 direction, class_243 pos, class_2394 particle, int count, float delta, float spread, int distance) {
        ArrayList<class_243> trailPositions = new ArrayList<class_243>();
        for (int i = 0; i < distance; ++i) {
            trailPositions.add(pos.method_1019(direction.method_1021((double)i)));
        }
        for (class_243 blockPos : trailPositions) {
            world.method_14199(particle, blockPos.field_1352, blockPos.field_1351, blockPos.field_1350, count, (double)delta, (double)delta, (double)delta, (double)spread);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "anim_controller", state -> PlayState.STOP).triggerableAnim("fire", this.fire).triggerableAnim("loaded", this.loaded).triggerableAnim("unloaded", this.unloaded)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public void method_5773() {
        boolean isMoving;
        super.method_5773();
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        boolean bl = isMoving = this.method_18798().field_1352 != 0.0 || this.method_18798().field_1351 != 0.0;
        if (isMoving && this.method_5805()) {
            if (this.moveTick >= 140 || this.moveTick == 0) {
                serverWorld.method_18456().forEach(p -> {
                    if (p.method_19538().method_1022(this.method_19538()) <= 30.0) {
                        p.method_17356((class_3414)ModSounds.SIEGE_ENGINE_MOVE.get(), class_3419.field_15256, (float)(1.0 - p.method_19538().method_1022(this.method_19538()) / 30.0), 1.0f);
                    }
                });
                if (this.moveTick != 0) {
                    this.moveTick = 0;
                }
            }
            ++this.moveTick;
        } else if (this.moveTick != 0 || !this.method_5805()) {
            this.moveTick = 0;
            serverWorld.method_18456().forEach(p -> p.field_13987.method_14364((class_2596)new class_2770(((class_3414)ModSounds.SIEGE_ENGINE_MOVE.get()).method_14833(), class_3419.field_15256)));
        }
        if (this.getLoadStage() != 4 && this.getLoadStage() != 5 && this.getCooldown() <= 10) {
            this.triggerAnim("anim_controller", "unloaded");
        }
        this.setCooldown(Math.max(0, this.getCooldown() - 1));
    }

    private class_243 getMouthOffset() {
        float yawRad = (float)Math.toRadians(this.method_43078());
        double forward = 1.4;
        double up = 1.0;
        double x = this.method_23317() - Math.sin(yawRad) * forward;
        double y = this.method_23318() + up - Math.sin(Math.toRadians(this.method_36455()));
        double z = this.method_23321() + Math.cos(yawRad) * forward;
        return new class_243(x, y, z);
    }

    public class_243 getPassengerOffset(class_1297 entity) {
        if (entity instanceof class_1498) {
            return new class_243(0.0, 0.0, -1.5);
        }
        return new class_243(0.5, 0.0, 1.0);
    }

    public class_243 getPlayerPOV() {
        return new class_243(0.0, 0.0, 0.0);
    }
}

