/*
 * Decompiled with CFR 0.152.
 */
package banduty.kingdomsieges.entity.custom.sieges;

import banduty.kingdomsieges.entity.ModEntities;
import banduty.kingdomsieges.entity.custom.projectiles.TrebuchetProjectile;
import banduty.kingdomsieges.sounds.ModSounds;
import banduty.stoneycore.entity.custom.AbstractSiegeEntity;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.siege.SiegeManager;
import banduty.stoneycore.util.SCDamageCalculator;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2770;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MangonelEntity
extends AbstractSiegeEntity
implements GeoEntity {
    private final Random random = new Random();
    private int moveTick;
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation shoot = RawAnimation.begin().then("shoot", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation reloading = RawAnimation.begin().then("reloading", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation loaded = RawAnimation.begin().then("loaded", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation unloaded = RawAnimation.begin().then("unloaded", Animation.LoopType.PLAY_ONCE);
    protected static final class_2940<String> AMMO_LOADED = class_2945.method_12791(MangonelEntity.class, (class_2941)class_2943.field_13326);
    public int reloadingTime;

    public MangonelEntity(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23719, 0.075).method_26868(class_5134.field_23718, 265.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(AMMO_LOADED, (Object)"");
    }

    public boolean method_5818(class_1297 entity) {
        return this.method_5685().isEmpty() && (entity instanceof class_1657 || entity instanceof class_1498);
    }

    public String getAmmoLoaded() {
        return (String)this.field_6011.method_12789(AMMO_LOADED);
    }

    public void setAmmoLoaded(String ammoLoaded) {
        this.field_6011.method_12778(AMMO_LOADED, (Object)ammoLoaded);
    }

    public int getReloadingTime() {
        return this.reloadingTime;
    }

    public void setReloadingTime(int reloadingTime) {
        this.reloadingTime = reloadingTime;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_3218 serverWorld;
        block12: {
            block11: {
                class_1937 class_19372 = this.method_37908();
                if (!(class_19372 instanceof class_3218)) break block11;
                serverWorld = (class_3218)class_19372;
                if (hand == class_1268.field_5808) break block12;
            }
            return super.method_5688(player, hand);
        }
        super.method_5688(player, hand);
        UUID playerId = player.method_5667();
        Optional siegeOpt = SiegeManager.getPlayerSiege((class_3218)serverWorld, (UUID)playerId);
        if (siegeOpt.map(siege -> siege.isDisabled(playerId)).orElse(false).booleanValue()) {
            return class_1269.field_5814;
        }
        LandState stateManager = LandState.get((class_3218)serverWorld);
        Optional maybeLand = stateManager.getLandAt(this.method_24515());
        boolean isOwnerOrAlly = maybeLand.map(land -> land.getOwnerUUID().equals(playerId) || land.isAlly(playerId) || player.method_7337()).orElse(true);
        if (!isOwnerOrAlly) {
            return class_1269.field_5814;
        }
        if (this.method_31483() != null) {
            return class_1269.field_5814;
        }
        int cooldown = this.getCooldown();
        class_1799 itemStack = player.method_5998(hand);
        if (cooldown > 0) {
            return class_1269.field_5814;
        }
        if (this.getAmmoLoaded() == null || this.getAmmoLoaded().isEmpty()) {
            if (itemStack.method_31574(class_1802.field_20391)) {
                itemStack.method_7934(1);
                this.setAmmoLoaded("stone");
                this.setReloadingTime(this.getBaseReload());
                this.triggerAnim("anim_controller", "reloading");
                serverWorld.method_18456().forEach(p -> {
                    float t;
                    float volume;
                    double distance = p.method_19538().method_1022(this.method_19538());
                    if (distance <= 15.0 && (volume = 1.0f - (t = (float)(distance / 15.0))) > 0.0f) {
                        p.method_17356((class_3414)ModSounds.ROPE_CHARGE_GN.get(), class_3419.field_15256, volume, this.random.nextFloat(0.75f, 1.25f));
                    }
                });
                return class_1269.field_5812;
            }
            if (itemStack.method_31574(class_1802.field_8354)) {
                itemStack.method_7934(1);
                this.setAmmoLoaded("magma");
                this.setReloadingTime(this.getBaseReload());
                this.triggerAnim("anim_controller", "reloading");
                serverWorld.method_18456().forEach(p -> {
                    float t;
                    float volume;
                    double distance = p.method_19538().method_1022(this.method_19538());
                    if (distance <= 15.0 && (volume = 1.0f - (t = (float)(distance / 15.0))) > 0.0f) {
                        p.method_17356((class_3414)ModSounds.ROPE_CHARGE_GN.get(), class_3419.field_15256, volume, this.random.nextFloat(0.75f, 1.25f));
                    }
                });
                return class_1269.field_5812;
            }
            player.method_7353((class_2561)class_2561.method_43471((String)"entity.kingdomsieges.mangonel_entity.ammo_needed"), true);
            return class_1269.field_5814;
        }
        if (this.getReloadingTime() == 0) {
            this.triggerAnim("anim_controller", "shoot");
            this.setCooldown(10);
            serverWorld.method_18456().forEach(p -> {
                float t;
                float volume;
                double distance = p.method_19538().method_1022(this.method_19538());
                if (distance <= 75.0 && (volume = 1.0f - (t = (float)(distance / 75.0))) > 0.0f) {
                    p.method_17356((class_3414)ModSounds.MANGONEL_SHOOT.get(), class_3419.field_15256, volume, this.random.nextFloat(0.75f, 1.25f));
                }
            });
            this.setOwner((class_1297)player);
        }
        return class_1269.field_5812;
    }

    private void fireMangonel(class_3218 serverWorld) {
        TrebuchetProjectile projectile = new TrebuchetProjectile((class_1299<TrebuchetProjectile>)((class_1299)ModEntities.TREBUCHET_PROJECTILE.get()), (class_1309)this, (class_1937)serverWorld);
        projectile.method_23327(this.method_23317(), this.method_23318() + 2.25, this.method_23321());
        double blocksPerTick = (double)this.getProjectileSpeed() / 20.0;
        float accuracyDegrees = this.getAccuracyMultiplier();
        float yawOffset = (this.random.nextFloat() - 0.5f) * 4.0f * accuracyDegrees;
        float adjustedYaw = this.method_43078() + yawOffset;
        float yawRad = adjustedYaw * ((float)Math.PI / 180);
        double x = -Math.sin(yawRad);
        double z = Math.cos(yawRad);
        class_243 direction = new class_243(x, 0.0, z).method_1029();
        projectile.method_18799(direction.method_1021(blocksPerTick));
        projectile.method_7438(this.getBaseDamage());
        projectile.setDamageType(SCDamageCalculator.DamageType.BLUDGEONING);
        projectile.method_7432((class_1297)this);
        if (this.getAmmoLoaded().equals("stone")) {
            projectile.setImpactMode(TrebuchetProjectile.ImpactMode.BREAK_BLOCKS);
            projectile.setTextureName("stone");
        } else if (this.getAmmoLoaded().equals("magma")) {
            projectile.setImpactMode(TrebuchetProjectile.ImpactMode.SPREAD_FIRE);
            projectile.setTextureName("magma");
        }
        serverWorld.method_8649((class_1297)projectile);
        this.setAmmoLoaded("");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "anim_controller", state -> PlayState.STOP).triggerableAnim("shoot", this.shoot).triggerableAnim("reloading", this.reloading).setAnimationSpeed(100.0 / (double)this.getBaseReload()).triggerableAnim("loaded", this.loaded).triggerableAnim("unloaded", this.unloaded)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public void method_5773() {
        boolean isMoving;
        super.method_5773();
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        boolean bl = isMoving = this.method_18798().field_1352 != 0.0 || this.method_18798().field_1351 != 0.0;
        if (isMoving && this.method_5805()) {
            if (this.moveTick >= 150 || this.moveTick == 0) {
                serverWorld.method_18456().forEach(p -> {
                    if (p.method_19538().method_1022(this.method_19538()) <= 30.0) {
                        p.method_17356((class_3414)ModSounds.SIEGE_ENGINE_MOVE.get(), class_3419.field_15256, (float)(1.0 - p.method_19538().method_1022(this.method_19538()) / 30.0), 1.0f);
                    }
                });
                if (this.moveTick != 0) {
                    this.moveTick = 0;
                }
            }
            ++this.moveTick;
        } else if (this.moveTick != 0 || !this.method_5805()) {
            this.moveTick = 0;
            serverWorld.method_18456().forEach(p -> p.field_13987.method_14364((class_2596)new class_2770(((class_3414)ModSounds.SIEGE_ENGINE_MOVE.get()).method_14833(), class_3419.field_15256)));
        }
        if (this.getAmmoLoaded() != null && !this.getAmmoLoaded().isEmpty()) {
            if (this.getReloadingTime() <= 0 && this.getCooldown() <= 0) {
                this.triggerAnim("anim_controller", "loaded");
            }
            if (this.getCooldown() == 7) {
                this.fireMangonel(serverWorld);
            }
        } else if (this.getCooldown() <= 0 && this.getReloadingTime() <= 0) {
            this.triggerAnim("anim_controller", "unloaded");
        }
        this.setReloadingTime(Math.max(0, this.getReloadingTime() - 1));
        this.setCooldown(Math.max(0, this.getCooldown() - 1));
    }

    public class_243 getPassengerOffset(class_1297 entity) {
        if (entity instanceof class_1498) {
            return new class_243(0.0, 0.0, -1.25);
        }
        return new class_243(0.0, 0.0, 2.0);
    }

    public class_243 getPlayerPOV() {
        return new class_243(0.0, (double)-0.7f, 0.0);
    }
}

