/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.cleardrops.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public final class MessageUtil {
    private MessageUtil() {
    }

    public static Component render(String template) {
        return MessageUtil.render(template, new HashMap<String, String>());
    }

    public static Component render(String template, Map<String, String> placeholders) {
        String filled = MessageUtil.applyPlaceholders(template, placeholders);
        return MessageUtil.parseGradient(filled);
    }

    public static Component withPrefix(Component prefix, Component content) {
        if (prefix == null || prefix.getString().isEmpty()) {
            return content;
        }
        MutableComponent result = Component.m_237119_();
        result.m_7220_(prefix);
        result.m_7220_((Component)Component.m_237113_((String)" "));
        result.m_7220_(content);
        return result;
    }

    private static String applyPlaceholders(String s, Map<String, String> map) {
        String out = s;
        for (Map.Entry<String, String> e : map.entrySet()) {
            out = out.replace("{" + e.getKey() + "}", e.getValue());
        }
        return out;
    }

    private static Component parseGradient(String s) {
        MutableComponent out = Component.m_237119_();
        int idx = 0;
        while (true) {
            int open;
            if ((open = s.indexOf("<gradient:", idx)) < 0) {
                out.m_7220_((Component)Component.m_237113_((String)s.substring(idx)));
                break;
            }
            if (open > idx) {
                out.m_7220_((Component)Component.m_237113_((String)s.substring(idx, open)));
            }
            int closeTag = s.indexOf(62, open);
            int endTag = s.indexOf("</gradient>", closeTag + 1);
            if (closeTag < 0 || endTag < 0) {
                out.m_7220_((Component)Component.m_237113_((String)s.substring(open)));
                break;
            }
            String header = s.substring(open + "<gradient:".length(), closeTag);
            String inner = s.substring(closeTag + 1, endTag);
            String[] parts = header.split(":");
            if (parts.length != 2) {
                out.m_7220_((Component)Component.m_237113_((String)s.substring(open, endTag + "</gradient>".length())));
                idx = endTag + "</gradient>".length();
                continue;
            }
            Integer c1 = MessageUtil.parseHexColor(parts[0]);
            Integer c2 = MessageUtil.parseHexColor(parts[1]);
            if (c1 == null || c2 == null) {
                out.m_7220_((Component)Component.m_237113_((String)s.substring(open, endTag + "</gradient>".length())));
                idx = endTag + "</gradient>".length();
                continue;
            }
            out.m_7220_(MessageUtil.gradient(inner, c1, c2));
            idx = endTag + "</gradient>".length();
        }
        return out;
    }

    private static Component gradient(String inner, int c1, int c2) {
        int[] cps = inner.codePoints().toArray();
        if (cps.length == 0) {
            return Component.m_237119_();
        }
        MutableComponent out = Component.m_237119_();
        for (int i = 0; i < cps.length; ++i) {
            float t = cps.length == 1 ? 0.0f : (float)i / (float)(cps.length - 1);
            int rgb = MessageUtil.lerpColor(c1, c2, t);
            TextColor color = TextColor.m_131266_((int)rgb);
            String ch = new String(Character.toChars(cps[i]));
            out.m_7220_((Component)Component.m_237113_((String)ch).m_130948_(Style.f_131099_.m_131148_(color)));
        }
        return out;
    }

    private static Integer parseHexColor(String s) {
        String x = s.trim();
        if (x.startsWith("#")) {
            x = x.substring(1);
        }
        if (x.length() != 6) {
            return null;
        }
        try {
            return Integer.parseInt(x, 16);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static int lerpColor(int a, int b, float t) {
        int ar = a >> 16 & 0xFF;
        int ag = a >> 8 & 0xFF;
        int ab = a & 0xFF;
        int br = b >> 16 & 0xFF;
        int bg = b >> 8 & 0xFF;
        int bb = b & 0xFF;
        int r = Math.round((float)ar + (float)(br - ar) * t);
        int g = Math.round((float)ag + (float)(bg - ag) * t);
        int bl = Math.round((float)ab + (float)(bb - ab) * t);
        return r << 16 | g << 8 | bl;
    }
}

