/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.cleardrops.command;

import cn.alini.cleardrops.Cleardrops;
import cn.alini.cleardrops.gui.TrashChestMenu;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CleardropsCommands {
    private static final Map<UUID, Integer> playerPageMap = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cleardrops").then(Commands.m_82127_((String)"help").executes(ctx -> CleardropsCommands.help((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"collect").requires(src -> src.m_6761_(2))).executes(ctx -> CleardropsCommands.collect((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"gui").executes(ctx -> CleardropsCommands.openGui((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"purge").requires(src -> src.m_6761_(2))).executes(ctx -> CleardropsCommands.purge((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"status").executes(ctx -> CleardropsCommands.status((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(src -> src.m_6761_(2))).executes(ctx -> CleardropsCommands.reload((CommandSourceStack)ctx.getSource()))));
    }

    private static int help(CommandSourceStack src) {
        src.m_288197_(() -> Cleardrops.SCHEDULER.helpMessage(), false);
        return 1;
    }

    private static int collect(CommandSourceStack src) {
        int moved = Cleardrops.SCHEDULER.collectNow();
        if (moved > 0) {
            src.m_288197_(() -> Cleardrops.SCHEDULER.cmdCollectFeedback(moved), true);
        } else {
            src.m_288197_(() -> Cleardrops.SCHEDULER.cmdCollectNoneFeedback(), true);
        }
        return 1;
    }

    public static void openGui(ServerPlayer sp, int page) {
        int totalPages = Cleardrops.SCHEDULER.getTrashStorage().getTotalPages();
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages) {
            page = totalPages - 1;
        }
        playerPageMap.put(sp.m_20148_(), page);
        int finalPage = page;
        sp.m_5893_((MenuProvider)new SimpleMenuProvider((containerId, playerInv, player) -> new TrashChestMenu(containerId, playerInv, Cleardrops.SCHEDULER.getTrashStorage(), finalPage), (Component)Component.m_237113_((String)("\u56de\u6536\u7ad9 \u00a78(\u7b2c\u00a7e" + (page + 1) + "\u00a78/\u00a7e" + totalPages + "\u00a78\u9875)"))));
    }

    private static int openGui(CommandSourceStack src) {
        Entity entity = src.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            int page = playerPageMap.getOrDefault(sp.m_20148_(), 0);
            CleardropsCommands.openGui(sp, 0);
            return 1;
        }
        src.m_81352_((Component)Component.m_237113_((String)"\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c\u3002"));
        return 0;
    }

    private static int purge(CommandSourceStack src) {
        int cleared = Cleardrops.SCHEDULER.purgeNow();
        src.m_288197_(() -> Cleardrops.SCHEDULER.cmdPurgeFeedback(cleared), true);
        return 1;
    }

    private static int status(CommandSourceStack src) {
        src.m_288197_(() -> Cleardrops.SCHEDULER.statusMessage(), false);
        return 1;
    }

    private static int reload(CommandSourceStack src) {
        Cleardrops.SCHEDULER.applyConfig();
        src.m_288197_(() -> Component.m_237113_((String)"\u5df2\u4ece\u914d\u7f6e\u6587\u4ef6\u5e94\u7528\u53c2\u6570\u3002"), true);
        return 1;
    }
}

