/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.cleardrops.gui;

import cn.alini.cleardrops.command.CleardropsCommands;
import cn.alini.cleardrops.storage.TrashStorage;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TrashChestMenu
extends AbstractContainerMenu {
    private final TrashStorage trashStorage;
    private final int page;
    private final int totalPages;
    private final Player player;

    public TrashChestMenu(int containerId, Inventory playerInv, TrashStorage trashStorage, int page) {
        super(MenuType.f_39962_, containerId);
        this.trashStorage = trashStorage;
        this.page = page;
        this.totalPages = trashStorage.getTotalPages();
        this.player = playerInv.f_35978_;
        for (int i = 0; i < 45; ++i) {
            int idx = page * 54 + i;
            this.m_38897_(new TrashSlot(trashStorage, idx, 8 + i % 9 * 18, 18 + i / 9 * 18));
        }
        int base = page * 54 + 45;
        for (int i = 0; i < 9; ++i) {
            int x = 8 + i * 18;
            int y = 108;
            OpSlot slot = new OpSlot(trashStorage, base + i, x, y);
            this.m_38897_(slot);
        }
        this.setOpBarItem(0, Items.f_42180_, "\u00a7f\u4e0a\u4e00\u9875");
        this.setOpBarItem(4, Items.f_42127_, "\u00a7c\u5173\u95ed");
        this.setOpBarItem(8, Items.f_42180_, "\u00a7f\u4e0b\u4e00\u9875");
        for (int i : new int[]{1, 2, 3, 5, 6, 7}) {
            this.setOpBarItem(i, Items.f_42183_, "");
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 198));
        }
    }

    private void setOpBarItem(int opIndex, Item item, String name) {
        int slotIdx = this.page * 54 + 45 + opIndex;
        ItemStack stack = new ItemStack((ItemLike)item);
        if (!name.isEmpty()) {
            stack.m_41714_((Component)Component.m_237113_((String)name));
        }
        this.trashStorage.m_6836_(slotIdx, stack);
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int slot) {
        return ItemStack.f_41583_;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (slotId == 45 && this.page > 0) {
            player.m_6915_();
            CleardropsCommands.openGui((ServerPlayer)player, this.page - 1);
        } else if (slotId == 49) {
            player.m_6915_();
        } else if (slotId == 53 && this.page < this.totalPages - 1) {
            player.m_6915_();
            CleardropsCommands.openGui((ServerPlayer)player, this.page + 1);
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    public static class TrashSlot
    extends Slot {
        public TrashSlot(TrashStorage storage, int index, int x, int y) {
            super((Container)storage, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }

    public static class OpSlot
    extends Slot {
        public OpSlot(TrashStorage storage, int index, int x, int y) {
            super((Container)storage, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player player) {
            return false;
        }
    }
}

