/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.cleardrops.server;

import cn.alini.cleardrops.config.CDConfig;
import cn.alini.cleardrops.storage.TrashStorage;
import cn.alini.cleardrops.util.MessageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ServerScheduler {
    private int intervalTicks = 6000;
    private int keepTicks = 2400;
    private boolean autoCollect = true;
    private boolean announce = true;
    private String prefixRaw = "[\u6e05\u9053\u592b]";
    private List<Integer> warnSeconds = Arrays.asList(60, 30, 10, 5, 4, 3, 2, 1);
    private String msgPreCollect = "\u5373\u5c06\u5728 {time}s \u540e\u56de\u6536\u4e16\u754c\u6389\u843d\u7269\uff0c\u8bf7\u53ca\u65f6\u62fe\u53d6\u91cd\u8981\u7269\u54c1\uff01";
    private String msgCollected = "\u5df2\u56de\u6536\u6389\u843d\u7269\uff0c\u5171 {entities} \u4e2a\u5b9e\u4f53\u3002\u4f7f\u7528 /cleardrops gui \u9886\u53d6\uff0c{keep}s \u540e\u6e05\u7a7a\u3002";
    private String msgPurged = "\u56de\u6536\u7ad9\u5df2\u5230\u671f\uff0c\u6e05\u7a7a {slots} \u4e2a\u69fd\u4f4d\u3002";
    private String msgStatus = "\u56de\u6536\u7ad9\uff1a{slotsUsed}/{slotsTotal} \u69fd\uff0c\u7269\u54c1 {items} \u4e2a\uff1b\u6e05\u7a7a\u5012\u8ba1\u65f6\uff1a{keep}\uff1b\u81ea\u52a8\u56de\u6536\uff1a{auto}\uff0c\u95f4\u9694\uff1a{interval}s\uff0c\u4fdd\u7559\uff1a{keepCfg}s\uff0c\u5e7f\u64ad\uff1a{announce}\u3002";
    private String msgHelp = "<gradient:#7AD7F0:#4FC3F7>Cleardrops \u5e2e\u52a9</gradient>\n...";
    private String msgCmdCollect = "\u5df2\u56de\u6536\u6389\u843d\u7269\uff0c\u5171 {entities} \u4e2a\u5b9e\u4f53\u3002{keep}s \u5185\u53ef\u5728\u56de\u6536\u7ad9\u9886\u53d6\u3002";
    private String msgCmdCollectNone = "\u6ca1\u6709\u53ef\u6e05\u7406\u7684\u6389\u843d\u7269\uff01";
    private String msgAutoCollectNone = "\u672c\u6b21\u81ea\u52a8\u56de\u6536\u6ca1\u6709\u53ef\u6e05\u7406\u7684\u6389\u843d\u7269\u3002";
    private String msgCmdPurge = "\u5df2\u6e05\u7a7a\u56de\u6536\u7ad9\uff0c\u6e05\u9664\u4e86 {slots} \u4e2a\u69fd\u4f4d\u4e2d\u7684\u7269\u54c1\uff08\u9ed1\u540d\u5355\u7269\u54c1\u5df2\u8df3\u8fc7\uff09\u3002";
    private boolean voidProtect = true;
    private int voidRaiseMax = 6;
    private boolean voidResetVel = true;
    private static final int VOID_PROTECT_BUDGET_PER_TICK = 1024;
    private final Set<ResourceLocation> blacklist = new HashSet<ResourceLocation>();
    private int collectCountdown = this.intervalTicks;
    private int purgeCountdown = -1;
    private final Set<Integer> warnedThisCycle = new HashSet<Integer>();
    private final LinkedHashSet<ItemEntity> trackedItems = new LinkedHashSet();
    private final TrashStorage trashStorage = new TrashStorage(540);

    public TrashStorage getTrashStorage() {
        return this.trashStorage;
    }

    public synchronized void applyConfig() {
        int newInterval = (Integer)CDConfig.TICKS_PER_COLLECT.get();
        int newKeep = (Integer)CDConfig.TICKS_KEEP_AFTER_COLLECT.get();
        boolean newAuto = (Boolean)CDConfig.ENABLE_AUTO_COLLECT.get();
        boolean newAnnounce = (Boolean)CDConfig.ANNOUNCE_MESSAGES.get();
        this.prefixRaw = (String)CDConfig.PREFIX.get();
        List ws = (List)CDConfig.WARN_SECONDS.get();
        this.warnSeconds = new ArrayList<Integer>();
        for (Object o : ws) {
            Integer i;
            if (!(o instanceof Integer) || (i = (Integer)o) < 0) continue;
            this.warnSeconds.add(i);
        }
        this.warnSeconds.sort(Comparator.reverseOrder());
        this.msgPreCollect = (String)CDConfig.MSG_PRE_COLLECT.get();
        this.msgCollected = (String)CDConfig.MSG_COLLECTED.get();
        this.msgPurged = (String)CDConfig.MSG_PURGED.get();
        this.msgStatus = (String)CDConfig.MSG_STATUS.get();
        this.msgHelp = ((String)CDConfig.MSG_HELP.get()).replace("\\n", "\n");
        this.msgCmdCollect = (String)CDConfig.MSG_CMD_COLLECT.get();
        this.msgCmdCollectNone = (String)CDConfig.MSG_CMD_COLLECT_NONE.get();
        this.msgAutoCollectNone = (String)CDConfig.MSG_AUTO_COLLECT_NONE.get();
        this.msgCmdPurge = (String)CDConfig.MSG_CMD_PURGE.get();
        this.voidProtect = (Boolean)CDConfig.ENABLE_VOID_PROTECT.get();
        this.voidRaiseMax = (Integer)CDConfig.VOID_RAISE_MAX_STEPS.get();
        this.voidResetVel = (Boolean)CDConfig.VOID_RESET_VELOCITY.get();
        this.blacklist.clear();
        for (Object o : (List)CDConfig.ITEM_BLACKLIST.get()) {
            String s;
            if (!(o instanceof String) || !(s = (String)o).contains(":")) continue;
            try {
                this.blacklist.add(new ResourceLocation(s));
            }
            catch (Exception exception) {}
        }
        int oldInterval = this.intervalTicks;
        int oldKeep = this.keepTicks;
        this.intervalTicks = newInterval;
        this.keepTicks = newKeep;
        this.autoCollect = newAuto;
        this.announce = newAnnounce;
        if (this.collectCountdown > newInterval || oldInterval != newInterval) {
            this.collectCountdown = Math.min(this.collectCountdown, newInterval);
            if (this.collectCountdown <= 0) {
                this.collectCountdown = newInterval;
            }
            this.warnedThisCycle.clear();
        }
        if (this.purgeCountdown >= 0 && (this.purgeCountdown > newKeep || oldKeep != newKeep)) {
            this.purgeCountdown = Math.min(this.purgeCountdown, newKeep);
            if (this.purgeCountdown <= 0 && newKeep > 0) {
                this.purgeCountdown = newKeep;
            }
            if (newKeep == 0) {
                this.purgeCountdown = 0;
            }
        }
    }

    public void onServerTick(TickEvent.ServerTickEvent event) {
        Map<String, String> ph;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        if (this.autoCollect) {
            int secBefore = (this.collectCountdown + 19) / 20;
            if (this.announce && this.warnSeconds.contains(secBefore) && !this.warnedThisCycle.contains(secBefore)) {
                ph = Map.of("time", String.valueOf(secBefore));
                this.broadcastPrefixed(server, this.msgPreCollect, ph);
                this.warnedThisCycle.add(secBefore);
            }
            if (--this.collectCountdown <= 0) {
                int moved = this.collectNow(server);
                this.purgeCountdown = this.keepTicks;
                if (this.announce) {
                    if (moved > 0) {
                        Map<String, String> ph2 = Map.of("entities", String.valueOf(moved), "keep", String.valueOf(this.keepTicks / 20));
                        this.broadcastPrefixed(server, this.msgCollected, ph2);
                    } else {
                        this.broadcastPrefixed(server, this.msgAutoCollectNone, Map.of());
                    }
                }
                this.collectCountdown = this.intervalTicks;
                this.warnedThisCycle.clear();
            }
        }
        if (this.purgeCountdown >= 0 && --this.purgeCountdown == 0) {
            int cleared = this.purgeNow();
            if (this.announce) {
                ph = Map.of("slots", String.valueOf(cleared));
                this.broadcastPrefixed(server, this.msgPurged, ph);
            }
            this.purgeCountdown = -1;
        }
        if (this.voidProtect && !this.trackedItems.isEmpty()) {
            int processed = 0;
            Iterator it = this.trackedItems.iterator();
            while (it.hasNext() && processed < 1024) {
                ItemEntity ie = (ItemEntity)it.next();
                if (ie.m_213877_() || ie.m_9236_().f_46443_) {
                    it.remove();
                    continue;
                }
                Level level = ie.m_9236_();
                if (!(level instanceof ServerLevel)) {
                    it.remove();
                    continue;
                }
                ServerLevel level2 = (ServerLevel)level;
                int minY = level2.m_141937_();
                if (ie.m_20186_() < (double)minY) {
                    double x = Math.floor(ie.m_20185_()) + 0.5;
                    double z = Math.floor(ie.m_20189_()) + 0.5;
                    int y = minY + 1;
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((int)Math.floor(x), y, (int)Math.floor(z));
                    for (int steps = 0; steps < this.voidRaiseMax && !level2.m_46859_((BlockPos)pos); ++steps) {
                        pos.m_142448_(pos.m_123342_() + 1);
                    }
                    if (level2.m_46859_(pos.m_7495_())) {
                        pos.m_142448_(pos.m_123342_() + 1);
                    }
                    ie.m_6034_(x, (double)pos.m_123342_() + 0.25, z);
                    if (this.voidResetVel) {
                        ie.m_20334_(0.0, 0.0, 0.0);
                    }
                    ie.m_6853_(true);
                }
                ++processed;
            }
        }
    }

    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity ie = (ItemEntity)entity;
            this.trackedItems.add(ie);
        }
    }

    public void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity ie = (ItemEntity)entity;
            this.trackedItems.remove(ie);
        }
    }

    public int collectNow() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return 0;
        }
        return this.collectNow(server);
    }

    public int collectNow(MinecraftServer server) {
        int entitiesMoved = 0;
        for (ServerLevel level : server.m_129785_()) {
            AABB box = new AABB(-3.0E7, (double)level.m_141937_(), -3.0E7, 3.0E7, (double)level.m_151558_(), 3.0E7);
            List items = level.m_6443_(ItemEntity.class, box, e -> !e.m_213877_() && !e.m_32055_().m_41619_());
            for (ItemEntity e2 : items) {
                ItemStack stack = e2.m_32055_();
                if (this.isBlacklisted(stack)) continue;
                ItemStack rem = this.trashStorage.insertStack(stack);
                if (rem.m_41619_()) {
                    e2.m_146870_();
                } else {
                    if (rem.m_41613_() == stack.m_41613_()) continue;
                    e2.m_32045_(rem);
                }
                ++entitiesMoved;
            }
        }
        if (entitiesMoved > 0) {
            this.purgeCountdown = this.keepTicks;
        }
        return entitiesMoved;
    }

    public int purgeNow() {
        int cleared = 0;
        for (int i = 0; i < this.trashStorage.m_6643_(); ++i) {
            ItemStack s = this.trashStorage.m_8020_(i);
            if (s.m_41619_() || this.isBlacklisted(s)) continue;
            this.trashStorage.m_6836_(i, ItemStack.f_41583_);
            ++cleared;
        }
        this.trashStorage.m_6596_();
        return cleared;
    }

    public Component statusMessage() {
        int slotsTotal = this.trashStorage.m_6643_();
        int slotsUsed = 0;
        int totalItems = 0;
        int blacklistedStacks = 0;
        for (int i = 0; i < slotsTotal; ++i) {
            ItemStack s = this.trashStorage.m_8020_(i);
            if (s.m_41619_()) continue;
            ++slotsUsed;
            totalItems += s.m_41613_();
            if (!this.isBlacklisted(s)) continue;
            ++blacklistedStacks;
        }
        String keepDisp = this.purgeCountdown >= 0 ? this.purgeCountdown / 20 + "s" : "\u672a\u5b89\u6392";
        HashMap<String, String> ph = new HashMap<String, String>();
        ph.put("slotsUsed", String.valueOf(slotsUsed));
        ph.put("slotsTotal", String.valueOf(slotsTotal));
        ph.put("items", String.valueOf(totalItems));
        ph.put("keep", keepDisp);
        ph.put("auto", String.valueOf(this.autoCollect));
        ph.put("interval", String.valueOf(this.intervalTicks / 20));
        ph.put("keepCfg", String.valueOf(this.keepTicks / 20));
        ph.put("announce", String.valueOf(this.announce));
        ph.put("blacklistedStacks", String.valueOf(blacklistedStacks));
        Component content = MessageUtil.render(this.msgStatus, ph);
        Component prefix = MessageUtil.render(this.prefixRaw);
        return MessageUtil.withPrefix(prefix, content);
    }

    public Component helpMessage() {
        return MessageUtil.withPrefix(MessageUtil.render(this.prefixRaw), MessageUtil.render(this.msgHelp));
    }

    public Component cmdCollectFeedback(int moved) {
        Map<String, String> ph = Map.of("entities", String.valueOf(moved), "keep", String.valueOf(this.keepTicks / 20));
        return MessageUtil.withPrefix(MessageUtil.render(this.prefixRaw), MessageUtil.render(this.msgCmdCollect, ph));
    }

    public Component cmdCollectNoneFeedback() {
        return MessageUtil.withPrefix(MessageUtil.render(this.prefixRaw), MessageUtil.render(this.msgCmdCollectNone));
    }

    public Component cmdPurgeFeedback(int cleared) {
        Map<String, String> ph = Map.of("slots", String.valueOf(cleared));
        return MessageUtil.withPrefix(MessageUtil.render(this.prefixRaw), MessageUtil.render(this.msgCmdPurge, ph));
    }

    private void broadcastPrefixed(MinecraftServer server, String template, Map<String, String> ph) {
        Component prefix = MessageUtil.render(this.prefixRaw);
        Component content = MessageUtil.render(template, ph);
        Component msg = MessageUtil.withPrefix(prefix, content);
        server.m_6846_().m_11314_().forEach(p -> p.m_213846_(msg));
    }

    private boolean isBlacklisted(ItemStack stack) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        return id != null && this.blacklist.contains(id);
    }
}

