/*
 * Decompiled with CFR 0.152.
 */
package com.aim.coltonjgriswold.pg;

import com.aim.coltonjgriswold.pg.commands.PGGiveCommand;
import com.aim.coltonjgriswold.pg.commands.PGListGrenadesCommand;
import com.aim.coltonjgriswold.pg.commands.PGReloadCommand;
import com.aim.coltonjgriswold.pg.commands.PGSpawnCommand;
import com.aim.coltonjgriswold.pg.utilities.Debugging;
import com.aim.coltonjgriswold.pg.utilities.Grenade;
import com.aim.coltonjgriswold.pg.utilities.GrenadeHandler;
import com.aim.coltonjgriswold.pg.utilities.GrenadeUtils;
import com.aim.coltonjgriswold.pg.utilities.VersionUtils;
import com.sk89q.worldguard.WorldGuard;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.recipe.CraftingBookCategory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;

public class ParticleGrenades
extends JavaPlugin {
    private static final Logger log = LogManager.getLogger(ParticleGrenades.class);
    private static ParticleGrenades plugin;
    private Set<Recipe> recipes;
    private WorldGuard worldGuard;

    public void onEnable() {
        Debugging.enable();
        plugin = this;
        this.recipes = new HashSet<Recipe>();
        this.worldGuardLoaded();
        this.saveDefaultConfig();
        this.updateConfigs();
        this.parseConfig(false);
        this.generateText();
        this.getServer().getPluginManager().registerEvents((Listener)new GrenadeHandler(), (Plugin)this);
        this.getCommand("pgreload").setExecutor((CommandExecutor)new PGReloadCommand());
        this.getCommand("pglist").setExecutor((CommandExecutor)new PGListGrenadesCommand());
        PGGiveCommand give = new PGGiveCommand();
        this.getCommand("pggive").setTabCompleter((TabCompleter)give);
        this.getCommand("pggive").setExecutor((CommandExecutor)give);
        PGSpawnCommand spawn = new PGSpawnCommand();
        this.getCommand("pgspawn").setTabCompleter((TabCompleter)spawn);
        this.getCommand("pgspawn").setExecutor((CommandExecutor)spawn);
    }

    public void onDisable() {
        this.recipes.forEach(r -> this.getServer().removeRecipe(((CraftingRecipe)r).getKey()));
    }

    public static ParticleGrenades instance() {
        return plugin;
    }

    private void generateText() {
        try {
            ArrayList sounds;
            ArrayList<Object> particles;
            ArrayList<Object> effects;
            ArrayList<Object> materials;
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdir();
            }
            if (VersionUtils.isAtLeast("1.20.4")) {
                materials = new ArrayList(Registry.MATERIAL.stream().toList());
                effects = new ArrayList(Registry.EFFECT.stream().toList());
                particles = new ArrayList(Registry.PARTICLE_TYPE.stream().toList());
                sounds = new ArrayList(Registry.SOUNDS.stream().toList());
            } else {
                materials = new ArrayList<Material>(List.of(Material.values()));
                effects = new ArrayList<PotionEffectType>(List.of(PotionEffectType.values()));
                particles = new ArrayList<Particle>(List.of(Particle.values()));
                sounds = new ArrayList(StreamSupport.stream(Registry.SOUNDS.spliterator(), false).toList());
            }
            File file = new File(this.getDataFolder(), "materials.txt");
            FileWriter writer = new FileWriter(file);
            materials.sort(Comparator.comparing(Enum::name));
            for (Material material : materials) {
                NamespacedKey key = VersionUtils.getKey(material);
                if (key.getKey().startsWith("LEGACY")) continue;
                writer.write(key.getKey() + "\r\n");
            }
            writer.close();
            file = new File(this.getDataFolder(), "effects.txt");
            writer = new FileWriter(file);
            effects.sort(Comparator.comparing(e -> VersionUtils.getKey(e).getKey()));
            for (PotionEffectType potionEffectType : effects) {
                if (potionEffectType == null) continue;
                writer.write(VersionUtils.getKey(potionEffectType).getKey() + "\r\n");
            }
            writer.close();
            file = new File(this.getDataFolder(), "particles.txt");
            writer = new FileWriter(file);
            particles.sort(Comparator.comparing(Enum::name));
            for (Particle particle : particles) {
                String name = particle.name();
                if (VersionUtils.isAtLeast("1.20.2")) {
                    name = VersionUtils.getKey(particle).getKey();
                }
                if (name.startsWith("LEGACY")) continue;
                writer.write(name + "\r\n");
            }
            writer.close();
            file = new File(this.getDataFolder(), "sounds.txt");
            writer = new FileWriter(file);
            sounds.sort(Comparator.comparing(s -> VersionUtils.getKey(s).getKey()));
            for (Sound sound : sounds) {
                writer.write(VersionUtils.getKey(sound).getKey() + "\r\n");
            }
            writer.close();
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    private void remove() {
        HashSet temp = new HashSet();
        Iterable iter = () -> this.getServer().recipeIterator();
        StreamSupport.stream(iter.spliterator(), false).filter(r -> {
            ShapedRecipe recipe;
            return r instanceof ShapedRecipe && VersionUtils.getKey(recipe = (ShapedRecipe)r).getNamespace().equalsIgnoreCase(this.getName().toLowerCase(Locale.ROOT));
        }).forEach(k -> this.getServer().removeRecipe(VersionUtils.getKey((ShapedRecipe)k)));
    }

    public File[] getGrenades() {
        File folder = new File(this.getDataFolder() + "/grenades/");
        return folder.listFiles(f -> f.getName().endsWith(".yml"));
    }

    private void updateConfigs() {
        this.getConfig().getKeys(false).forEach(key -> {
            File file = new File(this.getDataFolder() + "/grenades/" + key + ".yml");
            if (!file.exists()) {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                this.getConfig().getConfigurationSection(key).getValues(true).forEach((arg_0, arg_1) -> ((YamlConfiguration)config).set(arg_0, arg_1));
                try {
                    config.save(file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void parseConfig(boolean reload) {
        this.remove();
        char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'};
        HashSet<Recipe> temp = new HashSet<Recipe>();
        Arrays.stream(this.getGrenades()).forEach(Grenade::new);
        Grenade.values().forEach((key, grenade) -> {
            String k = key.getKey();
            ShapedRecipe recipe = new ShapedRecipe(key, grenade.create());
            List<String> list = grenade.getIngredients();
            List<String> grid = grenade.getGrid();
            if (grid.size() > 3) {
                grid.subList(4, grid.size()).clear();
            }
            grid = grid.stream().map(s -> s.replace(chars[list.size()], ' ')).toList();
            recipe.shape(grid.toArray(new String[0]));
            for (int n = 0; n < list.size(); ++n) {
                char character;
                String ingredient;
                String[] split = list.get(n).split(":");
                if (split.length == 1) {
                    ingredient = list.get(n).toLowerCase();
                    character = chars[n];
                } else {
                    ingredient = split[1].toLowerCase();
                    character = split[0].toLowerCase().charAt(0);
                }
                if (Grenade.contains(ingredient)) {
                    ItemStack i = Grenade.create(ingredient);
                    recipe.setIngredient(character, (RecipeChoice)new RecipeChoice.ExactChoice(i));
                    continue;
                }
                Material mat = VersionUtils.isAtLeast("1.20.4") ? (Material)Registry.MATERIAL.get(NamespacedKey.minecraft((String)ingredient)) : Material.valueOf((String)ingredient.toUpperCase(Locale.ROOT));
                if (mat == null || mat == Material.AIR) continue;
                recipe.setIngredient(character, mat);
            }
            recipe.setGroup(grenade.getKey().getKey());
            recipe.setCategory(CraftingBookCategory.REDSTONE);
            temp.add((Recipe)recipe);
        });
        if (reload) {
            this.recipes.forEach(r -> this.getServer().removeRecipe(VersionUtils.getKey((ShapedRecipe)r)));
            this.getServer().getOnlinePlayers().forEach(GrenadeUtils::giveRecipes);
        }
        temp.forEach(Bukkit::addRecipe);
        this.recipes = temp;
    }

    private ItemStack createGrenade(String g) {
        YamlConfiguration c = (YamlConfiguration)this.getConfig();
        String name = c.getString(g + ".name");
        List description = c.getStringList(g + ".description");
        ItemStack item = new ItemStack(Material.TNT);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        ArrayList lore = new ArrayList();
        description.forEach(s -> lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s)));
        meta.setLore(lore);
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this, "pgdata"), PersistentDataType.STRING, (Object)g);
        item.setItemMeta(meta);
        return item;
    }

    private boolean worldGuardLoaded() {
        if (this.getServer().getPluginManager().getPlugin("WorldGuard") == null) {
            return false;
        }
        this.worldGuard = WorldGuard.getInstance();
        return this.worldGuard != null;
    }

    public WorldGuard getWorldGuard() {
        return this.worldGuard;
    }
}

