/*
 * Decompiled with CFR 0.152.
 */
package com.aim.coltonjgriswold.pg.commands;

import com.aim.coltonjgriswold.pg.commands.abstraction.PGTabCommand;
import com.aim.coltonjgriswold.pg.utilities.Grenade;
import com.aim.coltonjgriswold.pg.utilities.GrenadeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class PGGiveCommand
extends PGTabCommand {
    @Override
    public boolean onCmd() {
        if (this.player != null) {
            if (this.args.length == 1 || this.args.length == 2) {
                if (Grenade.contains(this.args[0].toLowerCase())) {
                    Grenade g = Grenade.getByKey(this.args[0].toLowerCase());
                    if (!this.hasPermission(g.getGivePerm())) {
                        this.response("&cYou do not have permission!");
                    } else {
                        int amount = Material.TNT.getMaxStackSize();
                        if (this.args.length == 2) {
                            try {
                                amount = Integer.parseInt(this.args[1]);
                                if (amount < 1) {
                                    this.response("&cSecond argument must be a positive number!");
                                    return true;
                                }
                            }
                            catch (NumberFormatException ex) {
                                this.response("&cSecond argument must be a number!");
                            }
                        }
                        ItemStack item = GrenadeUtils.createGrenade(g);
                        item.setAmount(amount);
                        HashMap map = this.player.getInventory().addItem(new ItemStack[]{item});
                        if (!map.isEmpty()) {
                            this.response("&aSuccesfully gave &l%1$s &aof &l%2$s!", amount - ((ItemStack)map.values().iterator().next()).getAmount(), g.getName());
                        } else {
                            this.response("&aSuccesfully gave &l%1$s &aof &l%2$s!", amount, g.getName());
                        }
                    }
                } else {
                    this.response("&cInvalid grenade!");
                }
            } else {
                this.response("&cUsage: /pggive <grenade> [amount]");
            }
        }
        return true;
    }

    @Override
    public List<String> onTab() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.args.length == 1 && this.player != null) {
            Grenade.values().forEach((k, v) -> {
                if (this.hasPermission(v.getGivePerm())) {
                    list.add(k.getKey());
                }
            });
        }
        return list;
    }
}

