/*
 * Decompiled with CFR 0.152.
 */
package com.aim.coltonjgriswold.pg.commands;

import com.aim.coltonjgriswold.pg.commands.abstraction.PGTabCommand;
import com.aim.coltonjgriswold.pg.utilities.Grenade;
import com.aim.coltonjgriswold.pg.utilities.GrenadeUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class PGSpawnCommand
extends PGTabCommand {
    @Override
    public boolean onCmd() {
        if (this.player != null) {
            if (this.args.length == 4) {
                if (Grenade.contains(this.args[0].toLowerCase())) {
                    Grenade g = Grenade.getByKey(this.args[0].toLowerCase());
                    if (!this.hasPermission(g.getGivePerm())) {
                        this.response("&cYou do not have permission!");
                    } else {
                        double x = 0.0;
                        double y = 0.0;
                        double z = 0.0;
                        try {
                            x = Double.parseDouble(this.args[1]);
                        }
                        catch (NumberFormatException ex) {
                            this.response("&cInvalid X coordinate!");
                            return false;
                        }
                        try {
                            y = Double.parseDouble(this.args[2]);
                        }
                        catch (NumberFormatException ex) {
                            this.response("&cInvalid Y coordinate!");
                            return false;
                        }
                        try {
                            z = Double.parseDouble(this.args[3]);
                        }
                        catch (NumberFormatException ex) {
                            this.response("&cInvalid Z coordinate!");
                            return false;
                        }
                        GrenadeUtils.spawnGrenade(new Location(this.player.getWorld(), x, y, z), g.getKey(), (LivingEntity)this.player, new Vector(0, -10, 0));
                        this.response("&aSuccessfully spawned &l%1$s &aat &l%3$s %2$s %4$s!", g.getName(), x, y, z);
                    }
                } else {
                    this.response("&cInvalid grenade!");
                }
            } else {
                this.response("&cUsage: /pgspawn <grenade> <x> <y> <z>");
            }
        }
        return true;
    }

    @Override
    public List<String> onTab() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.args.length == 1 && this.player != null) {
            Grenade.values().forEach((k, v) -> {
                if (this.hasPermission(v.getGivePerm())) {
                    list.add(k.getKey());
                }
            });
        }
        return list;
    }
}

