/*
 * Decompiled with CFR 0.152.
 */
package com.aim.coltonjgriswold.pg.utilities;

import com.aim.coltonjgriswold.pg.ParticleGrenades;
import com.aim.coltonjgriswold.pg.utilities.FileUtils;
import com.aim.coltonjgriswold.pg.utilities.GrenadeUtils;
import com.aim.coltonjgriswold.pg.utilities.VersionUtils;
import com.aim.coltonjgriswold.pg.utilities.random.WeightedChance;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Grenade {
    private static Map<NamespacedKey, Grenade> grenades = new HashMap<NamespacedKey, Grenade>();
    private String name;
    private List<String> description;
    private String usePerm;
    private String givePerm;
    private Color explosionColor;
    private Color explosionfadeColor;
    private Color smokeColor;
    private double radius;
    private boolean proximity;
    private boolean impact;
    private int fuse;
    private long cooldown;
    private double velocity;
    private double lifespan;
    private double damage;
    private double force;
    private double hitbox;
    private List<PotionEffect> effects;
    private boolean smokeEnabled;
    private WeightedChance<Particle> particles;
    private Sound sound;
    private float volume;
    private float pitch;
    private int fragments;
    private List<Material> breakOnHit;
    private List<Material> destroyOnHit;
    private List<Material> breakOnPenetrate;
    private List<Material> destroyOnPenetrate;
    private List<Material> ignore;
    private List<Material> throwOnHit;
    private List<Material> throwOnPenetrate;
    private Map<List<Material>, WeightedChance<Material>> convertOnHit;
    private Map<List<Material>, WeightedChance<Material>> convertOnPenetrate;
    private double distance;
    private NamespacedKey key;
    private List<String> ingredients;
    private List<String> grid;

    public Grenade(String name) {
        this(FileUtils.getFile("/grenades/" + name + ".yml"));
    }

    public Grenade(File file) {
        this.key = new NamespacedKey((Plugin)ParticleGrenades.instance(), file.getName().replace(".yml", ""));
        YamlConfiguration config = FileUtils.loadConfig(file);
        this.name = config.getString("name");
        this.description = config.getStringList("description");
        this.usePerm = "particlegrenades.use." + config.getName();
        this.givePerm = "particlegrenades.give." + config.getName();
        int color = 0;
        try {
            color = Integer.parseInt(config.getString("particles.explosion.color.from"), 16);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.explosionColor = Color.fromRGB((int)color);
        color = 0;
        try {
            color = Integer.parseInt(config.getString("particles.explosion.color.to"), 16);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.explosionfadeColor = Color.fromRGB((int)color);
        color = 0;
        try {
            color = Integer.parseInt(config.getString("particles.smoke.color"), 16);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.smokeColor = Color.fromRGB((int)color);
        this.fuse = config.getInt("behavior.fuse");
        this.proximity = config.getBoolean("behavior.proximity");
        this.radius = config.getDouble("behavior.radius");
        this.impact = config.getBoolean("behavior.impact");
        this.cooldown = config.getLong("cooldown");
        this.velocity = config.getDouble("particles.explosion.velocity");
        this.lifespan = config.getDouble("particles.explosion.lifespan");
        this.damage = config.getDouble("particles.explosion.damage");
        this.force = config.getDouble("particles.explosion.force");
        this.hitbox = config.getDouble("particles.explosion.hitbox");
        this.effects = config.getStringList("effects").stream().filter(token -> {
            String[] tokens = token.split(":");
            NamespacedKey k = NamespacedKey.minecraft((String)tokens[0].toLowerCase());
            PotionEffectType effect = VersionUtils.isAtLeast("1.20.4") ? (PotionEffectType)Registry.EFFECT.get(k) : PotionEffectType.getByKey((NamespacedKey)k);
            return effect != null;
        }).map(token -> {
            String[] tokens = token.split(":");
            NamespacedKey k = NamespacedKey.minecraft((String)tokens[0].toLowerCase());
            PotionEffectType effect = VersionUtils.isAtLeast("1.20.4") ? (PotionEffectType)Registry.EFFECT.get(k) : PotionEffectType.getByKey((NamespacedKey)k);
            int amplifier = 0;
            try {
                amplifier = Integer.parseInt(tokens[1]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            int duration = 0;
            try {
                duration = Integer.parseInt(tokens[2]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return new PotionEffect(effect, duration, amplifier);
        }).toList();
        this.smokeEnabled = config.getBoolean("particles.smoke.enabled");
        List list = config.getStringList("particles.explosion.particles");
        WeightedChance chance = new WeightedChance();
        list.stream().distinct().forEach(token -> {
            try {
                String num = token.replaceAll("[^0-9]+\\.?[^0-9]+", "");
                double weight = (double)list.size() / 100.0;
                if (!num.isBlank()) {
                    weight = Double.parseDouble(num) / 100.0;
                }
                NamespacedKey k = NamespacedKey.minecraft((String)token.replaceAll("%[0-9*.?0-9+]*", "").toLowerCase());
                Particle particle = null;
                if (VersionUtils.isAtLeast("1.20.4")) {
                    particle = (Particle)Registry.PARTICLE_TYPE.get(k);
                } else if (Arrays.stream(Particle.values()).anyMatch(part -> part.name().equalsIgnoreCase(k.getKey()))) {
                    particle = Particle.valueOf((String)k.getKey().toUpperCase(Locale.ROOT));
                }
                if (particle != null) {
                    chance.add(particle, weight);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        });
        this.particles = chance;
        String[] tokens = config.getString("sound").split(":");
        NamespacedKey k = NamespacedKey.minecraft((String)tokens[0].toLowerCase());
        this.sound = (Sound)Registry.SOUNDS.get(k);
        float volume = 0.0f;
        try {
            volume = Float.parseFloat(tokens[1]);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.volume = volume;
        float pitch = 0.0f;
        try {
            pitch = Float.parseFloat(tokens[2]);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.pitch = pitch;
        this.fragments = config.getInt("particles.explosion.fragments");
        this.breakOnHit = this.filterMaterials(config.getStringList("particles.explosion.blocks.on_hit.break"));
        this.destroyOnHit = this.filterMaterials(config.getStringList("particles.explosion.blocks.on_hit.destroy"));
        this.breakOnPenetrate = this.filterMaterials(config.getStringList("particles.explosion.blocks.on_penetrate.break"));
        this.destroyOnPenetrate = this.filterMaterials(config.getStringList("particles.explosion.blocks.on_penetrate.destroy"));
        this.ignore = this.filterMaterials(config.getStringList("particles.explosion.blocks.on_penetrate.ignore"));
        this.throwOnHit = this.filterMaterials(config.getStringList("particles.explosion.blocks.on_hit.throw"));
        this.throwOnPenetrate = this.filterMaterials(config.getStringList("particles.explosion.blocks.on_penetrate.throw"));
        HashMap<List<Object>, WeightedChance<Object>> map = new HashMap<List<Material>, WeightedChance<Material>>();
        config.getStringList("particles.explosion.blocks.on_hit.convert").forEach(token -> {
            String[] split = token.split(":");
            ArrayList<Material> from = new ArrayList<Material>(this.filterMaterials(Arrays.asList(split[0].split(","))));
            WeightedChance<Material> to = this.addWeight(Arrays.asList(split[1].split(",")));
            map.put(from, to);
        });
        this.convertOnHit = map;
        map = new HashMap();
        config.getStringList("particles.explosion.blocks.on_penetrate.convert").forEach(token -> {
            String[] split = token.split(":");
            ArrayList<Material> from = new ArrayList<Material>(this.filterMaterials(Arrays.asList(split[0].split(","))));
            WeightedChance<Material> to = this.addWeight(Arrays.asList(split[1].split(",")));
            map.put(from, to);
        });
        this.convertOnPenetrate = map;
        this.distance = config.getDouble("distance");
        this.ingredients = config.getStringList("recipe.ingredients");
        this.grid = config.getStringList("recipe.grid");
        grenades.put(this.key, this);
    }

    private List<Material> filterMaterials(List<String> list) {
        Stream<Material> stream = VersionUtils.isAtLeast("1.20.4") ? Registry.MATERIAL.stream() : Arrays.stream(Material.values());
        return stream.filter(material -> {
            boolean pass = false;
            for (String token : list) {
                if (this.matches((Material)material, token)) {
                    pass = true;
                }
                if (!this.matches((Material)material, token) || !token.startsWith("-")) continue;
                return false;
            }
            return pass;
        }).distinct().toList();
    }

    private WeightedChance<Material> addWeight(List<String> list) {
        WeightedChance<Material> chance = new WeightedChance<Material>();
        this.filterMaterials(list).forEach(material -> list.stream().filter(t -> !t.startsWith("-")).toList().forEach(token -> {
            if (this.matches((Material)material, (String)token)) {
                try {
                    String num = token.replaceAll("[^0-9]+\\.?[^0-9]+", "");
                    double weight = (double)list.size() / 100.0;
                    if (!num.isBlank() && !num.equals("?")) {
                        weight = Double.parseDouble(num) / 100.0;
                    }
                    chance.add((Material)material, weight);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }));
        return chance;
    }

    private boolean matches(Material material, String token) {
        String t = token.replace("?", ".*").replaceAll("[-%][0-9*.?0-9+]*", "");
        return switch (t.toLowerCase()) {
            case "burnable" -> material.isBurnable();
            case "flammable" -> material.isFlammable();
            case "logs" -> Tag.LOGS.isTagged((Keyed)material);
            case "leaves" -> Tag.LEAVES.isTagged((Keyed)material);
            case "planks" -> Tag.PLANKS.isTagged((Keyed)material);
            default -> VersionUtils.getKey(material).getKey().matches(t) && (material.isBlock() || material.isAir());
        };
    }

    public String getName() {
        return this.name;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public String getUsePerm() {
        return this.usePerm;
    }

    public String getGivePerm() {
        return this.givePerm;
    }

    public Color getExplosionfadeColor() {
        return this.explosionColor;
    }

    public Color getExplosionFadeColor() {
        return this.explosionfadeColor;
    }

    public Color getSmokeColor() {
        return this.smokeColor;
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean getProximity() {
        return this.proximity;
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean getImpact() {
        return this.impact;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getLifespan() {
        return this.lifespan;
    }

    public double getDamage() {
        return this.damage;
    }

    public double getForce() {
        return this.force;
    }

    public double getHitboxSize() {
        return this.hitbox;
    }

    public List<PotionEffect> getEffects() {
        return this.effects;
    }

    public boolean isSmokeEnabled() {
        return this.smokeEnabled;
    }

    public WeightedChance<Particle> getParticles() {
        return this.particles;
    }

    public Sound getSound() {
        return this.sound;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getFragments() {
        return this.fragments;
    }

    public List<Material> getBreakOnHit() {
        return this.breakOnHit;
    }

    public List<Material> getDestroyOnHit() {
        return this.destroyOnHit;
    }

    public List<Material> getBreakOnPenetrate() {
        return this.breakOnPenetrate;
    }

    public List<Material> getDestroyOnPenetrate() {
        return this.destroyOnPenetrate;
    }

    public List<Material> getIgnoreList() {
        return this.ignore;
    }

    public List<Material> getThrowOnHitList() {
        return this.throwOnHit;
    }

    public List<Material> getThrowOnPenetrateList() {
        return this.throwOnPenetrate;
    }

    public Map<List<Material>, WeightedChance<Material>> getConvertOnHitList() {
        return this.convertOnHit;
    }

    public Map<List<Material>, WeightedChance<Material>> getConvertOnPenetrateList() {
        return this.convertOnPenetrate;
    }

    public double getDistance() {
        return this.distance;
    }

    public List<String> getIngredients() {
        return this.ingredients;
    }

    public List<String> getGrid() {
        return this.grid;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public ItemStack create() {
        return GrenadeUtils.createGrenade(this);
    }

    public static void reload() {
        grenades.clear();
    }

    public static Grenade getByKey(NamespacedKey key) {
        if (grenades.containsKey(key)) {
            return grenades.get(key);
        }
        return null;
    }

    public static Grenade getByKey(String key) {
        return Grenade.getByKey(new NamespacedKey((Plugin)ParticleGrenades.instance(), key));
    }

    public static Map<NamespacedKey, Grenade> values() {
        return grenades;
    }

    public static boolean contains(String key) {
        return grenades.containsKey(new NamespacedKey((Plugin)ParticleGrenades.instance(), key));
    }

    public static NamespacedKey getKey(String name) {
        if (Grenade.contains(name)) {
            return new NamespacedKey((Plugin)ParticleGrenades.instance(), name);
        }
        return null;
    }

    public static NamespacedKey getKey(ItemStack item) {
        if (GrenadeUtils.isGrenade(item)) {
            return GrenadeUtils.getGrenade(item).getKey();
        }
        return null;
    }

    public static ItemStack create(String key) {
        return GrenadeUtils.createGrenade(Grenade.getByKey(key));
    }
}

