/*
 * Decompiled with CFR 0.152.
 */
package com.aim.coltonjgriswold.pg.utilities;

import com.aim.coltonjgriswold.pg.ParticleGrenades;
import com.aim.coltonjgriswold.pg.utilities.ChatUtils;
import com.aim.coltonjgriswold.pg.utilities.Grenade;
import com.aim.coltonjgriswold.pg.utilities.GrenadeUtils;
import com.aim.coltonjgriswold.pg.utilities.VersionUtils;
import com.aim.coltonjgriswold.pg.utilities.data.PGDataUtil;
import com.aim.coltonjgriswold.pg.utilities.worldguard.Utils;
import com.sk89q.worldguard.protection.flags.Flags;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GrenadeHandler
implements Listener {
    private static final Logger log = LogManager.getLogger(GrenadeHandler.class);

    @EventHandler
    public void onGrenade(PlayerDropItemEvent event) {
        this.dropGrenade(event);
    }

    @EventHandler
    public void onReload(ServerLoadEvent event) {
        if (event.getType().equals((Object)ServerLoadEvent.LoadType.RELOAD)) {
            Bukkit.getOnlinePlayers().forEach(GrenadeUtils::giveRecipes);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        GrenadeUtils.giveRecipes(event.getPlayer());
    }

    private void dropGrenade(final PlayerDropItemEvent event) {
        final Item i = event.getItemDrop();
        if (!i.getItemStack().getType().equals((Object)Material.TNT)) {
            return;
        }
        if (!GrenadeUtils.isGrenade(i.getItemStack())) {
            return;
        }
        String name = GrenadeUtils.getName(i.getItemStack());
        final Grenade g = Grenade.getByKey(name);
        if (g == null) {
            return;
        }
        final Player p = event.getPlayer();
        Date date = new Date();
        long time = date.getTime() + g.getCooldown() * 50L;
        if (!p.hasMetadata("pg_" + name) || p.getMetadata("pg_" + name).isEmpty()) {
            p.setMetadata("pg_" + name, (MetadataValue)new FixedMetadataValue((Plugin)ParticleGrenades.instance(), (Object)0));
        }
        if (p.isSneaking()) {
            if (!p.hasPermission(g.getUsePerm())) {
                ChatUtils.response((CommandSender)p, "&cYou do not have permission to use that!");
                event.setCancelled(true);
                return;
            }
            event.setCancelled(date.getTime() <= ((MetadataValue)p.getMetadata("pg_" + name).get(0)).asLong());
            if (event.isCancelled()) {
                return;
            }
            p.setMetadata("pg_" + name, (MetadataValue)new FixedMetadataValue((Plugin)ParticleGrenades.instance(), (Object)time));
            if (Utils.worldGuardLoaded() && Utils.flag((LivingEntity)p, p.getLocation(), Flags.ITEM_DROP)) {
                ChatUtils.response((CommandSender)p, "&cThis area is protected!");
                event.setCancelled(true);
                return;
            }
            p.getWorld().playSound(i.getLocation(), Sound.ENTITY_TNT_PRIMED, 1.0f, 1.0f);
            i.setVelocity(p.getEyeLocation().getDirection().normalize().multiply(g.getDistance()));
            i.setPickupDelay(g.getFuse() + 20);
            i.setMetadata("ParticleGrenade", (MetadataValue)new FixedMetadataValue((Plugin)ParticleGrenades.instance(), (Object)true));
            if (g.isSmokeEnabled()) {
                new BukkitRunnable(){
                    Color color;
                    {
                        this.color = g.getSmokeColor();
                    }

                    public void run() {
                        if (!event.getItemDrop().isValid()) {
                            this.cancel();
                            return;
                        }
                        Particle p = VersionUtils.isAtLeast("1.20.5") ? Particle.valueOf((String)"DUST") : Particle.valueOf((String)"REDSTONE");
                        i.getWorld().spawnParticle(p, i.getLocation().add(0.0, 0.5, 0.0), 0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(this.color, 0.75f));
                    }
                }.runTaskTimer((Plugin)ParticleGrenades.instance(), 0L, 2L);
            }
            new BukkitRunnable(){
                private long time;
                private double dist;
                private double square;
                private Vector prev;
                private double change;
                {
                    this.time = g.getFuse();
                    this.dist = g.getRadius();
                    this.square = this.dist * this.dist;
                    this.change = 0.0;
                }

                public void run() {
                    List near;
                    if (!i.isValid()) {
                        this.cancel();
                        i.remove();
                        return;
                    }
                    if (Utils.worldGuardLoaded() && Utils.flag((LivingEntity)p, i.getLocation(), Flags.POTION_SPLASH, Flags.BLOCK_BREAK)) {
                        i.remove();
                        this.cancel();
                        ChatUtils.response((CommandSender)p, "&cThat area is protected!");
                        return;
                    }
                    if (g.getProximity() && !(near = i.getNearbyEntities(this.square, this.square, this.square)).isEmpty() && near.stream().filter(e -> e instanceof LivingEntity && e.getUniqueId() != i.getThrower()).anyMatch(e -> i.getWorld() == e.getWorld() && e.getLocation().toVector().isInSphere(i.getLocation().toVector(), this.dist))) {
                        this.explode();
                        return;
                    }
                    if (g.getImpact()) {
                        Vector v = i.getVelocity();
                        if (this.prev != null) {
                            boolean impact;
                            double cur = this.prev.clone().subtract(v).length();
                            boolean bl = impact = Math.abs(this.change - cur) >= 0.5;
                            if (impact) {
                                this.explode();
                                return;
                            }
                            this.change = cur;
                        }
                        this.prev = v;
                    }
                    if (this.time-- <= 0L) {
                        this.explode();
                    }
                }

                private void explode() {
                    GrenadeUtils.explode(g, i.getLocation(), (LivingEntity)p);
                    i.remove();
                    this.cancel();
                }
            }.runTaskTimer((Plugin)ParticleGrenades.instance(), 0L, 1L);
        }
    }

    @EventHandler
    public void OnMerge(ItemMergeEvent event) {
        Item i = event.getEntity();
        Item j = event.getTarget();
        event.setCancelled(i.getItemStack().getType().equals((Object)Material.TNT) && i.hasMetadata("ParticleGrenade") || j.getItemStack().getType().equals((Object)Material.TNT) && j.hasMetadata("ParticleGrenade"));
    }

    @EventHandler
    public void OnPlace(BlockPlaceEvent event) {
        ItemStack i;
        ItemStack itemStack = i = event.getHand().equals((Object)EquipmentSlot.HAND) ? event.getPlayer().getInventory().getItemInMainHand() : event.getPlayer().getInventory().getItemInOffHand();
        if (GrenadeUtils.isGrenade(i)) {
            Player p;
            if (!VersionUtils.isAtLeast("1.20.5")) {
                event.setCancelled(true);
                return;
            }
            if (Utils.worldGuardLoaded() && Utils.flag((LivingEntity)(p = event.getPlayer()), p.getLocation(), Flags.BUILD)) {
                ChatUtils.response((CommandSender)p, "&cThis area is protected!");
                event.setCancelled(true);
                return;
            }
            Location loc = event.getBlockPlaced().getLocation();
            PGDataUtil.addData(loc.getWorld(), loc.toVector(), Grenade.getKey(GrenadeUtils.getName(i)));
        }
    }

    @EventHandler
    public void OnIgnite(TNTPrimeEvent event) {
        if (!VersionUtils.isAtLeast("1.20.5")) {
            return;
        }
        Block block = event.getBlock();
        if (PGDataUtil.hasData(block)) {
            LivingEntity e;
            Entity entity;
            if (Utils.worldGuardLoaded()) {
                if (event.getCause().equals((Object)TNTPrimeEvent.PrimeCause.PLAYER)) {
                    Player player = (Player)event.getPrimingEntity();
                    if (Utils.flag((LivingEntity)player, block.getLocation(), Flags.POTION_SPLASH, Flags.TNT, Flags.BUILD)) {
                        ChatUtils.response((CommandSender)player, "&cThis area is protected!");
                        event.setCancelled(true);
                        return;
                    }
                } else if (Utils.flag(block.getLocation(), Flags.POTION_SPLASH, Flags.TNT)) {
                    event.setCancelled(true);
                    return;
                }
            }
            NamespacedKey key = PGDataUtil.getData(block);
            GrenadeUtils.spawnGrenade(block.getLocation().add(0.5, 0.5, 0.5), key, (entity = event.getPrimingEntity()) instanceof LivingEntity ? (e = (LivingEntity)entity) : null);
            PGDataUtil.removeData(block, key);
            event.setCancelled(true);
            block.setType(Material.AIR);
        }
    }

    @EventHandler
    public void OnDispense(BlockDispenseEvent event) {
        BlockState blockState;
        final ItemStack item = event.getItem();
        if (GrenadeUtils.isGrenade(item) && (blockState = event.getBlock().getState()) instanceof Dispenser) {
            Dispenser block = (Dispenser)blockState;
            if (Utils.worldGuardLoaded() && Utils.flag(block.getLocation(), Flags.POTION_SPLASH, Flags.TNT)) {
                event.setCancelled(true);
                return;
            }
            Grenade g = GrenadeUtils.getGrenade(item);
            Vector facing = ((Directional)block.getBlockData()).getFacing().getDirection();
            GrenadeUtils.spawnGrenade(event.getBlock().getLocation().add(0.5, 0.5, 0.5).add(facing.clone().normalize().multiply(0.6)), g.getKey(), facing.normalize().multiply(g.getDistance()));
            final Inventory inventory = block.getInventory();
            event.setCancelled(true);
            new BukkitRunnable(){

                public void run() {
                    inventory.removeItem(new ItemStack[]{item});
                }
            }.runTask((Plugin)ParticleGrenades.instance());
        }
    }

    @EventHandler
    public void OnBreak(BlockBreakEvent event) {
        if (!VersionUtils.isAtLeast("1.20.5")) {
            return;
        }
        Block block = event.getBlock();
        if (PGDataUtil.hasData(block)) {
            NamespacedKey key = PGDataUtil.getData(block);
            PGDataUtil.removeData(block, key);
        }
    }
}

