/*
 * Decompiled with CFR 0.152.
 */
package com.aim.coltonjgriswold.pg.utilities.data;

import com.aim.coltonjgriswold.pg.utilities.Grenade;
import com.aim.coltonjgriswold.pg.utilities.VersionUtils;
import com.aim.coltonjgriswold.pg.utilities.data.PGDataType;
import com.aim.coltonjgriswold.pg.utilities.data.PGKeys;
import com.aim.coltonjgriswold.pg.utilities.data.VectorListData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public class PGDataUtil {
    public static boolean has(PersistentDataContainer data, NamespacedKey namespace) {
        if (VersionUtils.isAtLeast("1.20.4")) {
            return data.has(namespace);
        }
        return data.getKeys().contains(namespace);
    }

    public static <T extends PersistentDataHolder, P, C> boolean hasCustom(T t, NamespacedKey namespace, PersistentDataType<P, C> type) {
        return t != null && t.getPersistentDataContainer().has(namespace, type);
    }

    public static <T extends PersistentDataHolder, P, C> boolean hasCustom(T t, NamespacedKey namespace) {
        return t != null && PGDataUtil.has(t.getPersistentDataContainer(), namespace);
    }

    public static boolean hasData(ItemStack item) {
        return PGDataUtil.hasCustom(item.getItemMeta(), PGKeys.DATA);
    }

    public static boolean hasData(World world) {
        return PGDataUtil.hasCustom(world, PGKeys.LOCATION);
    }

    public static boolean hasData(World world, NamespacedKey key) {
        return PGDataUtil.hasData(world) && PGDataUtil.getData(world).has(key, (PersistentDataType)new VectorListData());
    }

    public static boolean hasData(World world, Vector vector) {
        return PGDataUtil.hasData(world) && PGDataUtil.getData(world).getKeys().stream().anyMatch(key -> PGDataUtil.getData(world, key).contains(vector));
    }

    public static boolean hasData(Location location) {
        World world = location.getWorld();
        return PGDataUtil.hasData(world) && PGDataUtil.getData(world).getKeys().stream().anyMatch(key -> PGDataUtil.getData(world, key).contains(location.toVector().toBlockVector()));
    }

    public static boolean hasData(Block block) {
        return PGDataUtil.hasData(block.getWorld(), block.getLocation().toVector());
    }

    public static <T extends PersistentDataHolder, P, C> C getCustom(T t, NamespacedKey namespace, PersistentDataType<P, C> type) {
        return (C)(PGDataUtil.hasCustom(t, namespace, type) ? t.getPersistentDataContainer().get(namespace, type) : null);
    }

    public static <T extends PersistentDataHolder> PersistentDataContainer getTags(T t, NamespacedKey namespace) {
        return PGDataUtil.getCustom(t, namespace, PGDataType.TAG_CONTAINER);
    }

    public static String getData(ItemStack item) {
        return PGDataUtil.getCustom(item.getItemMeta(), PGKeys.DATA, PGDataType.STRING);
    }

    public static PersistentDataContainer getData(World world) {
        return PGDataUtil.getTags(world, PGKeys.LOCATION);
    }

    public static List<Vector> getData(World world, NamespacedKey key) {
        return (List)PGDataUtil.getData(world).get(key, (PersistentDataType)new VectorListData());
    }

    public static NamespacedKey getData(Location location) {
        return PGDataUtil.hasData(location) ? (NamespacedKey)PGDataUtil.getData(location.getWorld()).getKeys().stream().filter(key -> PGDataUtil.contains(location, key)).findFirst().orElse(null) : null;
    }

    public static NamespacedKey getData(Block block) {
        return PGDataUtil.hasData(block) ? (NamespacedKey)PGDataUtil.getData(block.getWorld()).getKeys().stream().filter(key -> PGDataUtil.contains(block, key)).findFirst().orElse(null) : null;
    }

    public static <T extends PersistentDataHolder, P, C> void setCustom(T t, NamespacedKey key, PersistentDataType<P, C> type, C data) {
        if (type instanceof PersistentDataContainer) {
            PersistentDataContainer tag = (PersistentDataContainer)type;
            tag.set(key, type, data);
        } else {
            t.getPersistentDataContainer().set(key, type, data);
        }
    }

    public static void addData(ItemStack item, String data) {
        PGDataUtil.setCustom(item.getItemMeta(), PGKeys.DATA, PGDataType.STRING, data);
    }

    public static void addData(ItemMeta meta, String data) {
        PGDataUtil.setCustom(meta, PGKeys.DATA, PGDataType.STRING, data);
    }

    public static void addData(World world, Vector vector, NamespacedKey key) {
        PersistentDataContainer data;
        if (!PGDataUtil.hasData(world)) {
            PGDataUtil.setCustom(world, PGKeys.LOCATION, PGDataType.TAG_CONTAINER, world.getPersistentDataContainer().getAdapterContext().newPersistentDataContainer());
        }
        if ((data = PGDataUtil.getData(world)) == null) {
            return;
        }
        List<Object> list = new ArrayList<Vector>();
        if (PGDataUtil.has(data, key)) {
            list = new ArrayList((Collection)data.get(key, (PersistentDataType)new VectorListData()));
        }
        list.add(vector);
        list = list.stream().distinct().toList();
        data.set(key, PGDataType.VECTORLIST, list);
        PGDataUtil.setCustom(world, PGKeys.LOCATION, PGDataType.TAG_CONTAINER, data);
    }

    public static boolean contains(World world, Vector vector, NamespacedKey key) {
        if (PGDataUtil.hasData(world, key)) {
            return PGDataUtil.getData(world, key).contains(vector);
        }
        return false;
    }

    public static boolean contains(Location location, NamespacedKey key) {
        return PGDataUtil.contains(location.getWorld(), location.toVector(), key);
    }

    public static boolean contains(Block block, NamespacedKey key) {
        return PGDataUtil.contains(block.getLocation(), key);
    }

    public static void removeCustom(World world, NamespacedKey key) {
        if (PGDataUtil.hasData(world)) {
            PersistentDataContainer data = PGDataUtil.getData(world);
            if (data == null) {
                return;
            }
            if (PGDataUtil.has(data, key)) {
                data.remove(key);
                world.getPersistentDataContainer().set(PGKeys.LOCATION, PGDataType.TAG_CONTAINER, (Object)data);
                if (data.isEmpty()) {
                    world.getPersistentDataContainer().remove(PGKeys.LOCATION);
                }
            }
        }
    }

    public static void removeData(ItemStack item) {
        if (PGDataUtil.hasData(item)) {
            item.getItemMeta().getPersistentDataContainer().remove(Grenade.getKey(PGDataUtil.getData(item)));
        }
    }

    public static void removeData(World world, Vector vector, NamespacedKey key) {
        if (PGDataUtil.hasData(world)) {
            PersistentDataContainer data = PGDataUtil.getData(world);
            if (data == null) {
                return;
            }
            ArrayList list = new ArrayList();
            if (data.has(key)) {
                list = new ArrayList((Collection)data.get(key, (PersistentDataType)new VectorListData()));
            }
            list.remove(vector);
            data.set(key, (PersistentDataType)new VectorListData(), list);
            PGDataUtil.setCustom(world, PGKeys.LOCATION, PGDataType.TAG_CONTAINER, data);
        }
    }

    public static void removeData(Block block, NamespacedKey key) {
        PGDataUtil.removeData(block.getWorld(), block.getLocation().toVector(), key);
    }

    public static void removeData(Location location, NamespacedKey key) {
        PGDataUtil.removeData(location.getWorld(), location.toVector(), key);
    }
}

