/*
 * Decompiled with CFR 0.152.
 */
package com.aim.coltonjgriswold.pg.utilities.random;

import com.aim.coltonjgriswold.pg.utilities.random.Weighted;
import com.aim.coltonjgriswold.pg.utilities.random.WeightedEntry;
import com.aim.coltonjgriswold.pg.utilities.random.WeightedRandom;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Predicate;

public class WeightedChance<E> {
    private NavigableMap<Double, Weighted<E>> map = new TreeMap<Double, Weighted<E>>();
    private WeightedRandom random;
    private double total = 0.0;

    public WeightedChance() {
        this.random = new WeightedRandom();
    }

    public WeightedChance(WeightedRandom random) {
        this.random = random;
    }

    public WeightedChance(Collection<? extends Weighted<E>> collection) {
        this.addAll(collection);
    }

    public static <E> WeightedChance<E> fromCollection(Collection<? extends Weighted<E>> collection) {
        return new WeightedChance<E>(collection);
    }

    public static <E> E select(Collection<? extends Weighted<E>> collection) {
        return WeightedChance.select(new WeightedRandom(), collection);
    }

    public static <E> E select(WeightedRandom random, Collection<? extends Weighted<E>> collection) {
        return WeightedChance.fromCollection(collection).select(random);
    }

    public boolean add(E value, double weight) {
        WeightedEntry<E> entry = new WeightedEntry<E>(value, weight);
        if (weight <= 0.0 || this.contains(value)) {
            return false;
        }
        this.total += weight;
        this.map.put(this.total, entry);
        return true;
    }

    public boolean add(Weighted<E> entry) {
        if (entry.weight() <= 0.0 || this.contains(entry)) {
            return false;
        }
        this.total += entry.weight();
        this.map.put(this.total, entry);
        return true;
    }

    public void addAll(Collection<? extends Weighted<E>> collection) {
        collection.forEach(this::add);
    }

    public boolean remove(E value) {
        TreeMap<Double, Weighted<E>> tempMap = new TreeMap<Double, Weighted<E>>();
        this.total = 0.0;
        this.map.values().stream().filter(entry -> !entry.value().equals(value)).forEach(entry -> {
            this.total += entry.weight();
            tempMap.put(this.total, (Weighted<E>)entry);
        });
        boolean change = this.map.size() != tempMap.size();
        this.map = tempMap;
        return change;
    }

    public boolean remove(Predicate<Weighted<E>> predicate) {
        TreeMap<Double, Weighted<E>> tempMap = new TreeMap<Double, Weighted<E>>();
        this.total = 0.0;
        this.map.values().stream().filter(entry -> !predicate.test((Weighted)entry)).forEach(entry -> {
            this.total += entry.weight();
            tempMap.put(this.total, (Weighted<E>)entry);
        });
        boolean change = this.map.size() != tempMap.size();
        this.map = tempMap;
        return change;
    }

    public E select() {
        return this.select(this.random);
    }

    public E select(WeightedRandom random) {
        double next = random.nextDouble() * this.total;
        return this.map.ceilingEntry(next).getValue().value();
    }

    public double getWeight(E value) {
        Weighted e = this.map.values().stream().filter(entry -> entry.value().equals(value)).findFirst().orElse(null);
        if (e != null) {
            return e.weight();
        }
        return 0.0;
    }

    public double getTotal() {
        return this.total;
    }

    public List<E> getValues() {
        return this.map.values().stream().map(Weighted::value).toList();
    }

    public boolean contains(E value) {
        return this.map.values().stream().anyMatch(entry -> entry.value().equals(value));
    }

    public boolean contains(Weighted<E> weighted) {
        return this.map.values().stream().anyMatch(entry -> entry.value().equals(weighted));
    }
}

