/*
 * Decompiled with CFR 0.152.
 */
package com.aim.coltonjgriswold.pg.commands.abstraction;

import com.aim.coltonjgriswold.pg.commands.abstraction.IPGCommand;
import com.aim.coltonjgriswold.pg.utilities.ChatUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public abstract class PGCommand
implements IPGCommand {
    protected CommandSender sender;
    protected Player player;
    protected Command command;
    protected String[] args;
    protected boolean console = false;

    public final boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.command = command;
        this.sender = sender;
        if (sender instanceof Player) {
            Player player;
            this.player = player = (Player)sender;
            if (!this.hasPermission()) {
                this.response("&c", "Insufficient Permissions!");
                return true;
            }
            this.args = args;
            return this.onCmd();
        }
        if (sender instanceof ConsoleCommandSender) {
            ConsoleCommandSender c = (ConsoleCommandSender)sender;
            this.args = args;
            this.console = true;
            return this.onCmd();
        }
        return false;
    }

    public final boolean hasPermission(String node) {
        return this.player != null ? this.player.hasPermission(node) : this.sender.hasPermission(node);
    }

    public final boolean hasPermission(String node, Object ... args) {
        return this.player != null ? this.player.hasPermission(node.formatted(args)) : this.sender.hasPermission(node.formatted(args));
    }

    public final boolean hasPermission(String node, String[] args) {
        return this.player != null ? this.player.hasPermission(node.formatted(args)) : this.sender.hasPermission(node.formatted(args));
    }

    public final boolean hasPermission() {
        return this.player != null ? this.player.hasPermission(this.command.getPermission()) : this.sender.hasPermission(this.command.getPermission());
    }

    public final void response(String message) {
        ChatUtils.response(this.sender, message);
    }

    public final void response(String message, Object ... args) {
        ChatUtils.response(this.sender, message, args);
    }

    public final void response(String message, String[] args) {
        ChatUtils.response(this.sender, message, args);
    }

    public final void response(String[] messages) {
        ChatUtils.response(this.sender, messages);
    }
}

