/*
 * Decompiled with CFR 0.152.
 */
package com.aim.coltonjgriswold.pg.utilities;

import com.aim.coltonjgriswold.api.ParticleProjectile;
import com.aim.coltonjgriswold.pg.utilities.Grenade;
import com.aim.coltonjgriswold.pg.utilities.VersionUtils;
import com.aim.coltonjgriswold.pg.utilities.random.WeightedChance;
import com.aim.coltonjgriswold.pg.utilities.worldguard.Utils;
import com.sk89q.worldguard.protection.flags.Flags;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class GrenadeEffect
extends ParticleProjectile {
    private Grenade grenade;

    public GrenadeEffect(Grenade g) {
        super(g.getParticles().getValues().get(0), g.getHitboxSize(), g.getVelocity(), g.getLifespan());
        this.setColor(g.getExplosionfadeColor());
        this.setSecondaryColor(g.getExplosionFadeColor());
        this.grenade = g;
        this.grenade.getIgnoreList().forEach(arg_0 -> ((GrenadeEffect)this).ignoreMaterial(arg_0));
        this.grenade.getBreakOnPenetrate().forEach(arg_0 -> ((GrenadeEffect)this).ignoreMaterial(arg_0));
        this.grenade.getConvertOnPenetrateList().keySet().forEach(k -> k.forEach(arg_0 -> ((GrenadeEffect)this).ignoreMaterial(arg_0)));
        this.grenade.getDestroyOnPenetrate().forEach(arg_0 -> ((GrenadeEffect)this).ignoreMaterial(arg_0));
        this.grenade.getThrowOnPenetrateList().forEach(arg_0 -> ((GrenadeEffect)this).ignoreMaterial(arg_0));
        this.setTicks(2L);
    }

    public void OnHitEntity(LivingEntity who, World world, Vector start, Vector end, Entity entity, double t) {
        if (entity instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            if (Utils.worldGuardLoaded()) {
                if (who instanceof Player) {
                    Player p = (Player)who;
                    if (!Utils.flag((LivingEntity)p, e.getLocation(), Flags.DAMAGE_ANIMALS, Flags.PVP, Flags.POTION_SPLASH)) {
                        return;
                    }
                }
                if (!Utils.flag(e.getLocation(), Flags.DAMAGE_ANIMALS, Flags.PVP, Flags.POTION_SPLASH)) {
                    return;
                }
            }
            if (e.equals(who)) {
                who.damage(this.grenade.getDamage());
            } else {
                e.damage(this.grenade.getDamage(), (Entity)who);
            }
            if (!this.grenade.getEffects().isEmpty()) {
                e.addPotionEffects(this.grenade.getEffects());
            }
        }
        entity.setVelocity(end.subtract(start).normalize().multiply(this.grenade.getForce()));
    }

    public void OnHitBlock(LivingEntity who, World world, Vector start, Vector end, Block block, double t) {
        if (Utils.worldGuardLoaded()) {
            Player p;
            if (who instanceof Player && !Utils.flag((LivingEntity)(p = (Player)who), block.getLocation(), Flags.BUILD, Flags.TNT)) {
                return;
            }
            if (!Utils.flag(block.getLocation(), Flags.TNT)) {
                return;
            }
        }
        if (this.grenade.getIgnoreList().contains(block.getType())) {
            return;
        }
        if (this.grenade.getThrowOnHitList().contains(block.getType())) {
            BlockData data = block.getBlockData();
            block.setType(Material.AIR);
            FallingBlock sand = world.spawnFallingBlock(block.getLocation(), data);
            sand.setVelocity(this.getDirection().normalize().multiply(this.grenade.getForce()));
        }
        if (this.grenade.getBreakOnHit().contains(block.getType())) {
            block.breakNaturally();
        }
        if (!this.grenade.getConvertOnHitList().isEmpty() && !block.getType().equals((Object)Material.AIR)) {
            Map<List<Material>, WeightedChance<Material>> map = this.grenade.getConvertOnHitList();
            map.forEach((k, v) -> {
                if (k.contains(block.getType())) {
                    block.setType((Material)v.select());
                }
            });
        }
        if (this.grenade.getDestroyOnHit().contains(block.getType())) {
            block.setType(Material.AIR);
        }
    }

    public void OnPenetrateBlock(LivingEntity who, World world, Vector where, Block block, double t) {
        if (Utils.worldGuardLoaded()) {
            Player p;
            if (who instanceof Player && !Utils.flag((LivingEntity)(p = (Player)who), block.getLocation(), Flags.BUILD, Flags.TNT)) {
                return;
            }
            if (!Utils.flag(block.getLocation(), Flags.TNT)) {
                return;
            }
        }
        if (this.grenade.getIgnoreList().contains(block.getType())) {
            return;
        }
        if (this.grenade.getThrowOnPenetrateList().contains(block.getType())) {
            BlockData data = block.getBlockData();
            block.setType(Material.AIR);
            FallingBlock sand = world.spawnFallingBlock(block.getLocation(), data);
            sand.setVelocity(this.getDirection().normalize().multiply(this.grenade.getForce()));
        }
        if (this.grenade.getBreakOnPenetrate().contains(block.getType())) {
            block.breakNaturally();
        }
        if (!this.grenade.getConvertOnPenetrateList().isEmpty() && !block.getType().equals((Object)Material.AIR)) {
            Map<List<Material>, WeightedChance<Material>> map = this.grenade.getConvertOnPenetrateList();
            map.forEach((k, v) -> {
                if (k.contains(block.getType())) {
                    block.setType((Material)v.select());
                }
            });
        }
        if (this.grenade.getDestroyOnPenetrate().contains(block.getType())) {
            block.setType(Material.AIR);
        }
    }

    public void OnMove(World world, Vector previous, Vector current, double t) {
        Particle p;
        Particle particle = p = VersionUtils.isAtLeast("1.20.5") ? Particle.valueOf((String)"DUST") : Particle.valueOf((String)"REDSTONE");
        if (!this.getParticleType().equals((Object)p)) {
            return;
        }
        Color a = this.grenade.getExplosionfadeColor();
        Color b = this.grenade.getExplosionFadeColor();
        int red = (int)((double)a.getRed() + (double)(b.getRed() - a.getRed()) * t);
        int green = (int)((double)a.getGreen() + (double)(b.getGreen() - a.getGreen()) * t);
        int blue = (int)((double)a.getBlue() + (double)(b.getBlue() - a.getBlue()) * t);
        this.setColor(Color.fromRGB((int)red, (int)green, (int)blue));
    }
}

