/*
 * Decompiled with CFR 0.152.
 */
package com.aim.coltonjgriswold.pg.utilities;

import com.aim.coltonjgriswold.api.LaunchedProjectileData;
import com.aim.coltonjgriswold.api.ParticleProjectile;
import com.aim.coltonjgriswold.api.ParticleProjectiles;
import com.aim.coltonjgriswold.pg.ParticleGrenades;
import com.aim.coltonjgriswold.pg.utilities.ChatUtils;
import com.aim.coltonjgriswold.pg.utilities.Grenade;
import com.aim.coltonjgriswold.pg.utilities.GrenadeEffect;
import com.aim.coltonjgriswold.pg.utilities.VersionUtils;
import com.aim.coltonjgriswold.pg.utilities.data.PGDataUtil;
import com.aim.coltonjgriswold.pg.utilities.data.PGKeys;
import com.aim.coltonjgriswold.pg.utilities.random.WeightedChance;
import com.aim.coltonjgriswold.pg.utilities.worldguard.Utils;
import com.sk89q.worldguard.protection.flags.Flags;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GrenadeUtils {
    private static double G = 3.266666666666667;

    public static void giveRecipes(Player player) {
        Grenade.values().forEach((k, v) -> {
            player.undiscoverRecipe(k);
            if (player.hasPermission(v.getUsePerm()) || player.isOp()) {
                player.discoverRecipe(k);
            }
        });
    }

    public static void giveRecipes() {
        Bukkit.getOnlinePlayers().forEach(GrenadeUtils::giveRecipes);
    }

    public static void spawnGrenade(Location location, NamespacedKey key, final LivingEntity entity, Vector velocity) {
        final Item i = location.getWorld().dropItem(location, new ItemStack(Material.TNT));
        i.setVelocity(velocity);
        final Grenade g = Grenade.getByKey(key);
        if (g == null) {
            return;
        }
        location.getWorld().playSound(i.getLocation(), Sound.ENTITY_TNT_PRIMED, 1.0f, 1.0f);
        i.setPickupDelay(g.getFuse() + 20);
        i.setMetadata("ParticleGrenade", (MetadataValue)new FixedMetadataValue((Plugin)ParticleGrenades.instance(), (Object)true));
        if (g.isSmokeEnabled()) {
            new BukkitRunnable(){
                Color color;
                {
                    this.color = g.getSmokeColor();
                }

                public void run() {
                    if (!i.isValid()) {
                        this.cancel();
                        return;
                    }
                    Particle p = VersionUtils.isAtLeast("1.20.5") ? Particle.valueOf((String)"DUST") : Particle.valueOf((String)"REDSTONE");
                    i.getWorld().spawnParticle(p, i.getLocation().add(0.0, 0.5, 0.0), 0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(this.color, 0.75f));
                }
            }.runTaskTimer((Plugin)ParticleGrenades.instance(), 0L, 2L);
        }
        new BukkitRunnable(){
            private long time;
            private double dist;
            private double square;
            {
                this.time = g.getFuse();
                this.dist = g.getDistance();
                this.square = this.dist * this.dist;
            }

            public void run() {
                List near;
                if (!i.isValid()) {
                    this.cancel();
                    i.remove();
                    return;
                }
                if (Utils.worldGuardLoaded()) {
                    boolean flag;
                    boolean bl = flag = !Utils.flag(entity, entity.getLocation(), Flags.POTION_SPLASH, Flags.TNT);
                    if (flag) {
                        i.remove();
                        this.cancel();
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            ChatUtils.response((CommandSender)player, "&cThat area is protected!");
                        }
                        return;
                    }
                }
                if (g.getProximity() && !(near = i.getNearbyEntities(this.square, this.square, this.square)).isEmpty() && near.stream().filter(e -> e instanceof LivingEntity && e.getUniqueId() != i.getThrower()).anyMatch(e -> i.getWorld() == e.getWorld() && e.getLocation().toVector().isInSphere(i.getLocation().toVector(), this.dist))) {
                    this.explode();
                    return;
                }
                if (g.getImpact()) {
                    Vector v = i.getVelocity();
                    if (!i.isOnGround() && v.getX() == 0.0 || v.getY() == 0.0 || v.getZ() == 0.0) {
                        this.explode();
                        return;
                    }
                }
                if (this.time-- <= 0L) {
                    this.explode();
                }
            }

            private void explode() {
                GrenadeUtils.explode(g, i.getLocation(), entity);
                i.remove();
                this.cancel();
            }
        }.runTaskTimer((Plugin)ParticleGrenades.instance(), 0L, 1L);
    }

    public static void spawnGrenade(Location location, NamespacedKey key, LivingEntity entity) {
        GrenadeUtils.spawnGrenade(location, key, entity, new Vector());
    }

    public static void spawnGrenade(Location location, NamespacedKey key, Vector velocity) {
        GrenadeUtils.spawnGrenade(location, key, null, velocity);
    }

    public static void spawnGrenade(Location location, NamespacedKey key) {
        GrenadeUtils.spawnGrenade(location, key, null, new Vector());
    }

    public static void explode(Grenade g, Location location, LivingEntity entity) {
        Location where = location.clone();
        where.getWorld().playSound(where, g.getSound(), g.getVolume(), g.getPitch());
        WeightedChance<Particle> particle = g.getParticles();
        ArrayList data = new ArrayList();
        IntStream.range(0, g.getFragments()).forEach(n -> {
            GrenadeEffect grenade = new GrenadeEffect(g);
            grenade.setParticleType((Particle)particle.select());
            Material material = where.clone().add(0.5, 0.5, 0.5).getBlock().getType();
            if (material.equals((Object)Material.AIR)) {
                grenade.setData(material);
            }
            Location loc = where.clone().setDirection(Vector.getRandom().subtract(Vector.getRandom()).multiply(2.0));
            grenade.setVelocity((g.getVelocity() / 5.0 + (g.getVelocity() - g.getVelocity() / 5.0)) * new Random().nextDouble());
            grenade.setLifespan((g.getLifespan() / 5.0 + (g.getLifespan() - g.getLifespan() / 5.0)) * new Random().nextDouble());
            data.add(new LaunchedProjectileData((ParticleProjectile)grenade, entity, where.getWorld(), loc, Vector.getRandom().subtract(Vector.getRandom()).multiply(2.0), Vector.getRandom().subtract(Vector.getRandom()).multiply(2.0), true));
        });
        ParticleProjectiles.launchMultiple(data);
    }

    public static void explode(Grenade g, Location location) {
        GrenadeUtils.explode(g, location, null);
    }

    public static boolean isGrenade(ItemStack item) {
        return GrenadeUtils.isGrenade(item.getItemMeta());
    }

    public static <T extends PersistentDataHolder> boolean isGrenade(T t) {
        PersistentDataContainer data = t.getPersistentDataContainer();
        return data.has(new NamespacedKey((Plugin)ParticleGrenades.instance(), "pgdata"), PersistentDataType.STRING);
    }

    public static Grenade getGrenade(ItemStack item) {
        return GrenadeUtils.getGrenade(item.getItemMeta());
    }

    public static <T extends PersistentDataHolder> Grenade getGrenade(T t) {
        if (GrenadeUtils.isGrenade(t)) {
            String name = GrenadeUtils.getName(t);
            if (!Grenade.contains(name)) {
                return null;
            }
            return Grenade.getByKey(name);
        }
        return null;
    }

    public static String getName(ItemStack item) {
        return PGDataUtil.getData(item);
    }

    private static <T extends PersistentDataHolder> String getName(T t) {
        PersistentDataContainer data = t.getPersistentDataContainer();
        if (!data.has(PGKeys.DATA, PersistentDataType.STRING)) {
            return "";
        }
        return (String)data.get(PGKeys.DATA, PersistentDataType.STRING);
    }

    public static ItemStack createGrenade(Grenade grenade) {
        ItemStack item = new ItemStack(Material.TNT);
        ItemMeta meta = item.getItemMeta();
        PGDataUtil.addData(meta, grenade.getKey().getKey().toLowerCase());
        meta.setDisplayName(ChatUtils.color(grenade.getName()));
        ArrayList lore = new ArrayList();
        grenade.getDescription().forEach(s -> lore.add(ChatUtils.color(s)));
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createGrenade(String key) {
        return GrenadeUtils.createGrenade(Grenade.getByKey(key));
    }
}

